/*
 * Decompiled with CFR 0.152.
 */
package io.sterodium.extensions.node.upload;

import com.google.common.io.Files;
import com.google.common.net.MediaType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;

public class FileUploadServlet
extends HttpServlet {
    private static final Logger LOGGER = Logger.getLogger(FileUploadServlet.class.getName());

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LOGGER.info(String.format("Request Content-Type: %s, Content-Length:%d", req.getContentType(), req.getContentLength()));
        if (!MediaType.OCTET_STREAM.toString().equals(req.getContentType())) {
            resp.sendError(400, "Content type " + req.getContentType() + " is not supported");
            return;
        }
        LOGGER.info("Creating temporary file");
        File tempFile = File.createTempFile("selenium_node", ".zip");
        try (ServletInputStream inputStream = req.getInputStream();
             FileOutputStream outputStream = new FileOutputStream(tempFile);){
            LOGGER.info("Copying request input stream to file");
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        LOGGER.info("Unzipping zip archive");
        File imagesBaseDir = FileUploadServlet.unZip(tempFile);
        if (!tempFile.delete()) {
            throw new IOException("Unable to delete file: " + tempFile);
        }
        LOGGER.info("Writing directory to response");
        PrintWriter writer = resp.getWriter();
        writer.write(imagesBaseDir.getAbsolutePath());
    }

    private static File unZip(File zippedFile) throws IOException {
        File outputFolder = Files.createTempDir();
        try (ZipFile zipFile = new ZipFile(zippedFile);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File entryDestination = new File(outputFolder, entry.getName());
                if (entry.isDirectory()) {
                    entryDestination.mkdirs();
                    continue;
                }
                entryDestination.getParentFile().mkdirs();
                InputStream in = zipFile.getInputStream(entry);
                FileOutputStream out = new FileOutputStream(entryDestination);
                IOUtils.copy((InputStream)in, (OutputStream)out);
                IOUtils.closeQuietly((InputStream)in);
                ((OutputStream)out).close();
            }
        }
        return outputFolder;
    }
}

