/*
 * Decompiled with CFR 0.152.
 */
package io.sterodium.extensions.node.rmi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.sikuli.api.ImageTarget;

public class TargetFactory {
    private File folderToScan = new File(".");

    public void setImagePrefix(String imagePathPrefix) {
        String imageFolder = !imagePathPrefix.endsWith("/") ? imagePathPrefix + "/" : imagePathPrefix;
        this.folderToScan = new File(imageFolder);
        Preconditions.checkState(this.folderToScan.exists(), "Folder %s does not exist", this.folderToScan.getAbsolutePath());
        Preconditions.checkState(this.folderToScan.isDirectory(), "Folder %s is not a folder", this.folderToScan.getAbsolutePath());
    }

    public ImageTarget createImageTarget(String imageFile) {
        return new ImageTarget(this.findImageFile(imageFile));
    }

    @VisibleForTesting
    protected File findImageFile(String imageFile) {
        File foundImageFile = this.findImageFile(this.folderToScan, imageFile);
        return foundImageFile == null ? new File(imageFile) : foundImageFile;
    }

    private File findImageFile(File lookupFolder, String lookupTarget) {
        String[] foldersToFind;
        String[] paths = lookupTarget.split("[/\\\\]");
        for (String folderToFind : foldersToFind = Arrays.copyOfRange(paths, 0, paths.length - 1)) {
            if ((lookupFolder = this.findFolderRecursively(lookupFolder, folderToFind)) != null) continue;
            return null;
        }
        lookupTarget = paths[paths.length - 1];
        Collection files = FileUtils.listFiles((File)lookupFolder, (IOFileFilter)new NameFileFilter(lookupTarget), (IOFileFilter)TrueFileFilter.TRUE);
        return files.isEmpty() ? null : (File)files.iterator().next();
    }

    private File findFolderRecursively(File folderToScan, final String folderToFind) {
        if (folderToFind.isEmpty()) {
            return folderToScan;
        }
        Collection<File> foundFolders = FileUtils.listFilesAndDirs((File)folderToScan, (IOFileFilter)DirectoryFileFilter.DIRECTORY, (IOFileFilter)TrueFileFilter.TRUE);
        return (foundFolders = Collections2.filter(foundFolders, new Predicate<File>(){

            @Override
            public boolean apply(File file) {
                String fileName = file.getAbsolutePath();
                return fileName.endsWith("/" + folderToFind) || fileName.endsWith("\\" + folderToFind);
            }
        })).isEmpty() ? null : foundFolders.iterator().next();
    }
}

