/*
 * Decompiled with CFR 0.152.
 */
package io.sterodium.extensions.node.rmi;

import io.sterodium.extensions.node.rmi.TargetFactory;
import io.sterodium.rmi.protocol.MethodInvocationDto;
import io.sterodium.rmi.protocol.MethodInvocationResultDto;
import io.sterodium.rmi.protocol.server.RmiFacade;
import java.awt.Toolkit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sikuli.api.DesktopScreenRegion;
import org.sikuli.api.robot.desktop.DesktopKeyboard;
import org.sikuli.api.robot.desktop.DesktopMouse;

public class SikuliApplication {
    private static final Logger LOGGER = Logger.getLogger(SikuliApplication.class.getName());
    private final RmiFacade rmiFacade = new RmiFacade();

    public SikuliApplication() {
        this.rmiFacade.add("mouse", new DesktopMouse());
        this.rmiFacade.add("keyboard", new DesktopKeyboard());
        try {
            this.rmiFacade.add("desktop", new DesktopScreenRegion());
            this.rmiFacade.add("clipboard", Toolkit.getDefaultToolkit().getSystemClipboard());
        }
        catch (ExceptionInInitializerError e) {
            LOGGER.log(Level.SEVERE, "Sikuli operations are not available on this environment.", e);
        }
        this.rmiFacade.add("target-factory", new TargetFactory());
    }

    public MethodInvocationResultDto invoke(String objectId, MethodInvocationDto invocation) {
        return this.rmiFacade.invoke(objectId, invocation);
    }
}

