/*
 * Decompiled with CFR 0.152.
 */
package io.sterodium.extensions.node.download;

import com.google.common.net.MediaType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;

public class FileDownloadServlet
extends HttpServlet {
    private static final Logger LOGGER = Logger.getLogger(FileDownloadServlet.class.getName());

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        LOGGER.info("Request for file download received with path: " + pathInfo);
        File file = new File(pathInfo);
        if (!this.fileExistsAndNotDirectory(file, resp)) {
            return;
        }
        String contentType = this.identifyFileContentType(file);
        resp.setContentType(contentType);
        resp.setHeader("Content-Disposition", "attachment; filename=" + file.getName());
        try (FileInputStream fileInputStream = new FileInputStream(file);
             ServletOutputStream outputStream = resp.getOutputStream();){
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)outputStream);
        }
    }

    private String identifyFileContentType(File file) throws IOException {
        String contentType = Files.probeContentType(file.toPath());
        return contentType != null ? contentType : MediaType.OCTET_STREAM.toString();
    }

    private boolean fileExistsAndNotDirectory(File requestedFile, HttpServletResponse resp) throws IOException {
        if (!requestedFile.exists()) {
            LOGGER.info("Requested file doesn't exist: " + requestedFile.getAbsolutePath());
            this.sendError(resp, "Requested file doesn't exist.");
            return false;
        }
        if (requestedFile.isDirectory()) {
            LOGGER.info("Requested file is directory: " + requestedFile.getAbsolutePath());
            this.sendError(resp, "Requested file is directory.");
            return false;
        }
        if (!requestedFile.canRead()) {
            LOGGER.info("Requested file cannot bet read: " + requestedFile.getAbsolutePath());
            this.sendError(resp, "Requested file can be read.");
            return false;
        }
        return true;
    }

    private void sendError(HttpServletResponse resp, String msg) throws IOException {
        resp.setStatus(400);
        resp.getWriter().write(msg);
    }
}

