/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class PStyledText
extends PNode {
    private static final long serialVersionUID = 1L;
    protected static FontRenderContext SWING_FRC = new FontRenderContext(null, true, false);
    protected static Line2D paintLine = new Line2D.Double();
    protected Document document;
    protected transient ArrayList stringContents;
    protected transient LineInfo[] lines;
    protected boolean editing;
    protected Insets insets = new Insets(0, 0, 0, 0);
    protected boolean constrainHeightToTextHeight = true;
    protected boolean constrainWidthToTextWidth = true;

    public void setConstrainWidthToTextWidth(boolean constrainWidthToTextWidth) {
        this.constrainWidthToTextWidth = constrainWidthToTextWidth;
        this.recomputeLayout();
    }

    public void setConstrainHeightToTextHeight(boolean constrainHeightToTextHeight) {
        this.constrainHeightToTextHeight = constrainHeightToTextHeight;
        this.recomputeLayout();
    }

    public boolean getConstrainWidthToTextWidth() {
        return this.constrainWidthToTextWidth;
    }

    public boolean getConstrainHeightToTextHeight() {
        return this.constrainHeightToTextHeight;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
        this.syncWithDocument();
    }

    public void syncWithDocument() {
        String documentString;
        this.stringContents = new ArrayList();
        try {
            documentString = this.document.getText(0, this.document.getLength());
        }
        catch (BadLocationException e) {
            return;
        }
        ArrayList pEnds = this.extractParagraphRanges(documentString);
        StyleContext styleContext = StyleContext.getDefaultStyleContext();
        RunInfo paragraphRange = null;
        Iterator contentIterator = this.stringContents.iterator();
        Iterator paragraphIterator = pEnds.iterator();
        while (contentIterator.hasNext() && paragraphIterator.hasNext()) {
            Font font;
            Color foreground;
            AttributeSet attributes;
            paragraphRange = (RunInfo)paragraphIterator.next();
            AttributedString attributedString = (AttributedString)contentIterator.next();
            int pos = paragraphRange.startIndex;
            Element curElement = null;
            Element rootElement = this.document.getDefaultRootElement();
            if (paragraphRange.isEmpty()) {
                curElement = this.drillDownFromRoot(pos, rootElement);
                attributes = curElement.getAttributes();
                foreground = styleContext.getForeground(attributes);
                attributedString.addAttribute(TextAttribute.FOREGROUND, foreground, Math.max(0, curElement.getStartOffset() - paragraphRange.startIndex), Math.min(paragraphRange.length(), curElement.getEndOffset() - paragraphRange.startIndex));
                font = this.extractFont(styleContext, pos, rootElement, attributes);
                this.applyFontAttribute(paragraphRange, attributedString, curElement, font);
                this.applyBackgroundAttribute(styleContext, paragraphRange, attributedString, curElement, attributes);
                this.applyUnderlineAttribute(paragraphRange, attributedString, curElement, attributes);
                this.applyStrikeThroughAttribute(paragraphRange, attributedString, curElement, attributes);
                continue;
            }
            while (pos < paragraphRange.endIndex) {
                curElement = this.drillDownFromRoot(pos, rootElement);
                attributes = curElement.getAttributes();
                foreground = styleContext.getForeground(attributes);
                attributedString.addAttribute(TextAttribute.FOREGROUND, foreground, Math.max(0, curElement.getStartOffset() - paragraphRange.startIndex), Math.min(paragraphRange.length(), curElement.getEndOffset() - paragraphRange.startIndex));
                font = this.extractFont(styleContext, pos, rootElement, attributes);
                this.applyFontAttribute(paragraphRange, attributedString, curElement, font);
                this.applyBackgroundAttribute(styleContext, paragraphRange, attributedString, curElement, attributes);
                this.applyUnderlineAttribute(paragraphRange, attributedString, curElement, attributes);
                this.applyStrikeThroughAttribute(paragraphRange, attributedString, curElement, attributes);
                pos = curElement.getEndOffset();
            }
        }
        this.recomputeLayout();
    }

    private Element drillDownFromRoot(int pos, Element rootElement) {
        Element curElement = rootElement;
        while (!curElement.isLeaf()) {
            curElement = curElement.getElement(curElement.getElementIndex(pos));
        }
        return curElement;
    }

    private void applyFontAttribute(RunInfo paragraphRange, AttributedString attributedString, Element curElement, Font font) {
        if (font != null) {
            attributedString.addAttribute(TextAttribute.FONT, font, Math.max(0, curElement.getStartOffset() - paragraphRange.startIndex), Math.min(paragraphRange.endIndex - paragraphRange.startIndex, curElement.getEndOffset() - paragraphRange.startIndex));
        }
    }

    private void applyStrikeThroughAttribute(RunInfo paragraphRange, AttributedString attributedString, Element curElement, AttributeSet attributes) {
        boolean strikethrough = StyleConstants.isStrikeThrough(attributes);
        if (strikethrough) {
            attributedString.addAttribute(TextAttribute.STRIKETHROUGH, Boolean.TRUE, Math.max(0, curElement.getStartOffset() - paragraphRange.startIndex), Math.min(paragraphRange.endIndex - paragraphRange.startIndex, curElement.getEndOffset() - paragraphRange.startIndex));
        }
    }

    private void applyUnderlineAttribute(RunInfo paragraphRange, AttributedString attributedString, Element curElement, AttributeSet attributes) {
        boolean underline = StyleConstants.isUnderline(attributes);
        if (underline) {
            attributedString.addAttribute(TextAttribute.UNDERLINE, Boolean.TRUE, Math.max(0, curElement.getStartOffset() - paragraphRange.startIndex), Math.min(paragraphRange.endIndex - paragraphRange.startIndex, curElement.getEndOffset() - paragraphRange.startIndex));
        }
    }

    private void applyBackgroundAttribute(StyleContext style, RunInfo paragraphRange, AttributedString attributedString, Element curElement, AttributeSet attributes) {
        if (attributes.isDefined(StyleConstants.Background)) {
            Color background = style.getBackground(attributes);
            attributedString.addAttribute(TextAttribute.BACKGROUND, background, Math.max(0, curElement.getStartOffset() - paragraphRange.startIndex), Math.min(paragraphRange.endIndex - paragraphRange.startIndex, curElement.getEndOffset() - paragraphRange.startIndex));
        }
    }

    private Font extractFont(StyleContext style, int pos, Element rootElement, AttributeSet attributes) {
        Font font = null;
        if (attributes.isDefined(StyleConstants.FontSize) || attributes.isDefined(StyleConstants.FontFamily)) {
            font = style.getFont(attributes);
        }
        if (font == null) {
            font = this.document instanceof DefaultStyledDocument ? this.extractFontFromDefaultStyledDocument((DefaultStyledDocument)this.document, style, pos, rootElement) : style.getFont(rootElement.getAttributes());
        }
        return font;
    }

    private Font extractFontFromDefaultStyledDocument(DefaultStyledDocument styledDocument, StyleContext style, int pos, Element rootElement) {
        Font font = style.getFont(styledDocument.getCharacterElement(pos).getAttributes());
        if (font == null && (font = style.getFont(styledDocument.getParagraphElement(pos).getAttributes())) == null) {
            font = style.getFont(rootElement.getAttributes());
        }
        return font;
    }

    private ArrayList extractParagraphRanges(String documentString) {
        ArrayList<RunInfo> paragraphRanges = new ArrayList<RunInfo>();
        int pos = 0;
        StringTokenizer tokenizer = new StringTokenizer(documentString, "\n", true);
        boolean lastNewLine = true;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("\n")) {
                if (lastNewLine) {
                    this.stringContents.add(new AttributedString(" "));
                    paragraphRanges.add(new RunInfo(pos, pos + 1));
                }
                ++pos;
                lastNewLine = true;
                continue;
            }
            if (token.equals("")) {
                this.stringContents.add(new AttributedString(" "));
                paragraphRanges.add(new RunInfo(pos, pos));
                lastNewLine = false;
                continue;
            }
            this.stringContents.add(new AttributedString(token));
            paragraphRanges.add(new RunInfo(pos, pos + token.length()));
            pos += token.length();
            lastNewLine = false;
        }
        if (lastNewLine) {
            this.stringContents.add(new AttributedString(" "));
            paragraphRanges.add(new RunInfo(pos, pos + 1));
        }
        return paragraphRanges;
    }

    public void recomputeLayout() {
        if (this.stringContents == null) {
            return;
        }
        ArrayList<LineInfo> linesList = new ArrayList<LineInfo>();
        double textWidth = 0.0;
        double textHeight = 0.0;
        Iterator contentIterator = this.stringContents.iterator();
        while (contentIterator.hasNext()) {
            AttributedString ats = (AttributedString)contentIterator.next();
            AttributedCharacterIterator itr = ats.getIterator();
            ArrayList breakList = null;
            LineBreakMeasurer measurer = new LineBreakMeasurer(itr, SWING_FRC);
            breakList = this.extractLineBreaks(itr, measurer);
            measurer = new LineBreakMeasurer(itr, PPaintContext.RENDER_QUALITY_HIGH_FRC);
            LineInfo lineInfo = null;
            boolean newLine = true;
            double lineWidth = 0.0;
            while (measurer.getPosition() < itr.getEndIndex()) {
                int lineEnd;
                TextLayout aTextLayout = null;
                if (newLine) {
                    newLine = false;
                    double lineHeight = this.calculateLineHeightFromLineInfo(lineInfo);
                    textHeight += lineHeight;
                    textWidth = Math.max(textWidth, lineWidth);
                    lineInfo = new LineInfo();
                    linesList.add(lineInfo);
                }
                if ((lineEnd = ((Integer)breakList.get(0)).intValue()) <= itr.getRunLimit()) {
                    breakList.remove(0);
                    newLine = true;
                }
                aTextLayout = measurer.nextLayout(Float.MAX_VALUE, Math.min(lineEnd, itr.getRunLimit()), false);
                SegmentInfo sInfo = new SegmentInfo();
                sInfo.font = (Font)itr.getAttribute(TextAttribute.FONT);
                sInfo.foreground = (Color)itr.getAttribute(TextAttribute.FOREGROUND);
                sInfo.background = (Color)itr.getAttribute(TextAttribute.BACKGROUND);
                sInfo.underline = (Boolean)itr.getAttribute(TextAttribute.UNDERLINE);
                sInfo.layout = aTextLayout;
                FontMetrics metrics = StyleContext.getDefaultStyleContext().getFontMetrics((Font)itr.getAttribute(TextAttribute.FONT));
                lineInfo.maxAscent = Math.max(lineInfo.maxAscent, (double)metrics.getMaxAscent());
                lineInfo.maxDescent = Math.max(lineInfo.maxDescent, (double)metrics.getMaxDescent());
                lineInfo.leading = Math.max(lineInfo.leading, (double)metrics.getLeading());
                lineInfo.segments.add(sInfo);
                itr.setIndex(measurer.getPosition());
                lineWidth += (double)aTextLayout.getAdvance();
            }
            double lineHeight = this.calculateLineHeightFromLineInfo(lineInfo);
            textHeight += lineHeight;
            textWidth = Math.max(textWidth, lineWidth);
        }
        this.lines = linesList.toArray(new LineInfo[linesList.size()]);
        this.constrainDimensionsIfNeeded(textWidth, textHeight);
    }

    private double calculateLineHeightFromLineInfo(LineInfo lineInfo) {
        double lineHeight = lineInfo == null ? 0.0 : lineInfo.maxAscent + lineInfo.maxDescent + lineInfo.leading;
        return lineHeight;
    }

    private void constrainDimensionsIfNeeded(double textWidth, double textHeight) {
        if (!this.constrainWidthToTextWidth && !this.constrainHeightToTextHeight) {
            return;
        }
        double newWidth = this.getWidth();
        double newHeight = this.getHeight();
        if (this.constrainWidthToTextWidth) {
            newWidth = textWidth + (double)this.insets.left + (double)this.insets.right;
        }
        if (this.constrainHeightToTextHeight) {
            newHeight = Math.max(textHeight, this.getInitialFontHeight()) + (double)this.insets.top + (double)this.insets.bottom;
        }
        super.setBounds(this.getX(), this.getY(), newWidth, newHeight);
    }

    private ArrayList extractLineBreaks(AttributedCharacterIterator itr, LineBreakMeasurer measurer) {
        ArrayList<Integer> breakList = new ArrayList<Integer>();
        while (measurer.getPosition() < itr.getEndIndex()) {
            if (this.constrainWidthToTextWidth) {
                measurer.nextLayout(Float.MAX_VALUE);
            } else {
                measurer.nextLayout((float)Math.ceil(this.getWidth() - (double)this.insets.left - (double)this.insets.right));
            }
            breakList.add(new Integer(measurer.getPosition()));
        }
        return breakList;
    }

    public double getInitialFontHeight() {
        Element rootElement = this.document.getDefaultRootElement();
        Element curElement = this.drillDownFromRoot(0, rootElement);
        StyleContext context = StyleContext.getDefaultStyleContext();
        Font font = context.getFont(curElement.getAttributes());
        FontMetrics curFM = context.getFontMetrics(font);
        return curFM.getMaxAscent() + curFM.getMaxDescent() + curFM.getLeading();
    }

    protected void paint(PPaintContext paintContext) {
        if (this.lines == null || this.lines.length == 0) {
            return;
        }
        float x = (float)(this.getX() + (double)this.insets.left);
        float y = (float)(this.getY() + (double)this.insets.top);
        float bottomY = (float)(this.getY() + this.getHeight() - (double)this.insets.bottom);
        Graphics2D g2 = paintContext.getGraphics();
        if (this.getPaint() != null) {
            g2.setPaint(this.getPaint());
            g2.fill(this.getBoundsReference());
        }
        for (int i = 0; i < this.lines.length; ++i) {
            LineInfo lineInfo = this.lines[i];
            y = (float)((double)y + lineInfo.maxAscent);
            float curX = x;
            if (bottomY < y) {
                return;
            }
            for (int j = 0; j < lineInfo.segments.size(); ++j) {
                SegmentInfo sInfo = (SegmentInfo)lineInfo.segments.get(j);
                float width = sInfo.layout.getAdvance();
                if (sInfo.background != null) {
                    g2.setPaint(sInfo.background);
                    g2.fill(new Rectangle2D.Double(curX, (double)y - lineInfo.maxAscent, width, lineInfo.maxAscent + lineInfo.maxDescent + lineInfo.leading));
                }
                sInfo.applyFont(g2);
                g2.setPaint(sInfo.foreground);
                sInfo.layout.draw(g2, curX, y);
                if (sInfo.underline != null) {
                    paintLine.setLine(x, (double)y + lineInfo.maxDescent / 2.0, x + width, (double)y + lineInfo.maxDescent / 2.0);
                    g2.draw(paintLine);
                }
                curX += width;
            }
            y = (float)((double)y + (lineInfo.maxDescent + lineInfo.leading));
        }
    }

    public void fullPaint(PPaintContext paintContext) {
        if (!this.editing) {
            super.fullPaint(paintContext);
        }
    }

    public void setEditing(boolean editing) {
        this.editing = editing;
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void setInsets(Insets insets) {
        if (insets != null) {
            this.insets.left = insets.left;
            this.insets.right = insets.right;
            this.insets.top = insets.top;
            this.insets.bottom = insets.bottom;
            this.recomputeLayout();
        }
    }

    public Insets getInsets() {
        return (Insets)this.insets.clone();
    }

    public boolean setBounds(double x, double y, double width, double height) {
        if (this.document == null || !super.setBounds(x, y, width, height)) {
            return false;
        }
        this.recomputeLayout();
        return true;
    }

    protected static class SegmentInfo {
        public TextLayout layout;
        public Font font;
        public Color foreground;
        public Color background;
        public Boolean underline;

        public void applyFont(Graphics2D g2) {
            if (this.font != null) {
                g2.setFont(this.font);
            }
        }
    }

    protected static class LineInfo {
        public List segments = new ArrayList();
        public double maxAscent;
        public double maxDescent;
        public double leading;
    }

    protected static class RunInfo {
        private int startIndex;
        private int endIndex;

        public RunInfo(int runStart, int runLimit) {
            this.startIndex = runStart;
            this.endIndex = runLimit;
        }

        public boolean isEmpty() {
            return this.startIndex == this.endIndex;
        }

        public int length() {
            return this.endIndex - this.startIndex;
        }
    }
}

