/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PUtil;
import edu.umd.cs.piccolox.util.LineShape;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class PLine
extends PNode {
    private static final long serialVersionUID = 1L;
    private static final PAffineTransform TEMP_TRANSFORM = new PAffineTransform();
    private static final BasicStroke DEFAULT_STROKE = new BasicStroke(1.0f);
    private static final Color DEFAULT_STROKE_PAINT = Color.black;
    private final transient LineShape lineShape;
    private transient Stroke stroke;
    private Paint strokePaint = DEFAULT_STROKE_PAINT;

    public PLine() {
        this((LineShape)null);
    }

    public PLine(LineShape lineShape) {
        this.stroke = DEFAULT_STROKE;
        this.lineShape = lineShape == null ? new LineShape(null) : lineShape;
    }

    public PLine(LineShape line, Stroke aStroke) {
        this(line);
        this.stroke = aStroke;
    }

    public Paint getStrokePaint() {
        return this.strokePaint;
    }

    public void setStrokePaint(Paint newStrokePaint) {
        Paint oldPaint = this.strokePaint;
        this.strokePaint = newStrokePaint;
        this.invalidatePaint();
        this.firePropertyChange(65536, "strokePaint", oldPaint, this.strokePaint);
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke newStroke) {
        Stroke oldStroke = this.stroke;
        this.stroke = newStroke;
        this.updateBoundsFromLine();
        this.invalidatePaint();
        this.firePropertyChange(131072, "stroke", oldStroke, this.stroke);
    }

    public boolean setBounds(double x, double y, double width, double height) {
        if (this.lineShape == null || !super.setBounds(x, y, width, height)) {
            return false;
        }
        Rectangle2D lineBounds = this.lineShape.getBounds2D();
        Rectangle2D lineStrokeBounds = this.getLineBoundsWithStroke();
        double strokeOutset = Math.max(lineStrokeBounds.getWidth() - lineBounds.getWidth(), lineStrokeBounds.getHeight() - lineBounds.getHeight());
        double adjustedX = x + strokeOutset / 2.0;
        double adjustedY = y + strokeOutset / 2.0;
        double adjustedWidth = width - strokeOutset;
        double adjustedHeight = height - strokeOutset;
        TEMP_TRANSFORM.setToIdentity();
        TEMP_TRANSFORM.translate(adjustedX, adjustedY);
        TEMP_TRANSFORM.scale(adjustedWidth / lineBounds.getWidth(), adjustedHeight / lineBounds.getHeight());
        TEMP_TRANSFORM.translate(-lineBounds.getX(), -lineBounds.getY());
        this.lineShape.transformPoints(TEMP_TRANSFORM);
        return true;
    }

    public boolean intersects(Rectangle2D aBounds) {
        if (super.intersects(aBounds)) {
            if (this.lineShape.intersects(aBounds)) {
                return true;
            }
            if (this.stroke != null && this.strokePaint != null) {
                return this.stroke.createStrokedShape(this.lineShape).intersects(aBounds);
            }
        }
        return false;
    }

    public Rectangle2D getLineBoundsWithStroke() {
        if (this.stroke != null) {
            return this.stroke.createStrokedShape(this.lineShape).getBounds2D();
        }
        return this.lineShape.getBounds2D();
    }

    public void updateBoundsFromLine() {
        if (this.lineShape.getPointCount() == 0) {
            this.resetBounds();
        } else {
            Rectangle2D b = this.getLineBoundsWithStroke();
            super.setBounds(b.getX(), b.getY(), b.getWidth(), b.getHeight());
        }
    }

    protected void paint(PPaintContext paintContext) {
        Graphics2D g2 = paintContext.getGraphics();
        if (this.stroke != null && this.strokePaint != null) {
            g2.setPaint(this.strokePaint);
            g2.setStroke(this.stroke);
            g2.draw(this.lineShape);
        }
    }

    public LineShape getLineReference() {
        return this.lineShape;
    }

    public int getPointCount() {
        return this.lineShape.getPointCount();
    }

    public Point2D getPoint(int pointIndex, Point2D dst) {
        Point2D result = dst == null ? new Point2D.Double() : dst;
        return this.lineShape.getPoint(pointIndex, result);
    }

    protected void lineChanged() {
        this.firePropertyChange(262144, "path", null, this.lineShape);
        this.updateBoundsFromLine();
        this.invalidatePaint();
    }

    public void setPoint(int pointIndex, double x, double y) {
        this.lineShape.setPoint(pointIndex, x, y);
        this.lineChanged();
    }

    public void addPoint(int pointIndex, double x, double y) {
        this.lineShape.addPoint(pointIndex, x, y);
        this.lineChanged();
    }

    public void removePoints(int startIndex, int numberOfPoints) {
        this.lineShape.removePoints(startIndex, numberOfPoints);
        this.lineChanged();
    }

    public void removeAllPoints() {
        this.lineShape.removePoints(0, this.lineShape.getPointCount());
        this.lineChanged();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        PUtil.writeStroke(this.stroke, out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.stroke = PUtil.readStroke(in);
    }
}

