/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.activities;

import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.activities.PActivityScheduler;
import edu.umd.cs.piccolo.util.PUtil;

public class PInterpolatingActivity
extends PActivity {
    public static final int SOURCE_TO_DESTINATION = 1;
    public static final int DESTINATION_TO_SOURCE = 2;
    public static final int SOURCE_TO_DESTINATION_TO_SOURCE = 3;
    private int mode;
    private boolean slowInSlowOut;
    private int loopCount;
    private boolean firstLoop;

    public PInterpolatingActivity(long duration) {
        this(duration, PUtil.DEFAULT_ACTIVITY_STEP_RATE, 1, 1);
    }

    public PInterpolatingActivity(long duration, long stepRate) {
        this(duration, stepRate, 1, 1);
    }

    public PInterpolatingActivity(long duration, long stepRate, int loopCount, int mode) {
        this(duration, stepRate, System.currentTimeMillis(), loopCount, mode);
    }

    public PInterpolatingActivity(long duration, long stepRate, long startTime, int loopCount, int mode) {
        super(duration, stepRate, startTime);
        this.loopCount = loopCount;
        this.mode = mode;
        this.slowInSlowOut = true;
        this.firstLoop = true;
    }

    public void setDuration(long duration) {
        if (duration <= 0L) {
            throw new IllegalArgumentException("Duration for PInterpolatingActivity must be greater then 0");
        }
        super.setDuration(duration);
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public void setLoopCount(int loopCount) {
        this.loopCount = loopCount;
    }

    public boolean getFirstLoop() {
        return this.firstLoop;
    }

    public void setFirstLoop(boolean firstLoop) {
        this.firstLoop = firstLoop;
    }

    public boolean getSlowInSlowOut() {
        return this.slowInSlowOut;
    }

    public void setSlowInSlowOut(boolean isSlowInSlowOut) {
        this.slowInSlowOut = isSlowInSlowOut;
    }

    protected void activityStarted() {
        super.activityStarted();
        this.setRelativeTargetValueAdjustingForMode(0.0f);
    }

    protected void activityStep(long elapsedTime) {
        super.activityStep(elapsedTime);
        float t = (float)elapsedTime / (float)this.getDuration();
        t = Math.min(1.0f, t);
        t = Math.max(0.0f, t);
        if (this.getSlowInSlowOut()) {
            t = this.computeSlowInSlowOut(t);
        }
        this.setRelativeTargetValueAdjustingForMode(t);
    }

    protected void activityFinished() {
        this.setRelativeTargetValueAdjustingForMode(1.0f);
        super.activityFinished();
        PActivityScheduler scheduler = this.getActivityScheduler();
        if (this.loopCount > 1) {
            if (this.loopCount != Integer.MAX_VALUE) {
                --this.loopCount;
            }
            this.firstLoop = false;
            this.setStartTime(scheduler.getRoot().getGlobalTime());
            scheduler.addActivity(this);
        }
    }

    public void terminate() {
        this.loopCount = 0;
        super.terminate();
    }

    public void setRelativeTargetValue(float zeroToOne) {
    }

    public float computeSlowInSlowOut(float zeroToOne) {
        if (zeroToOne < 0.5f) {
            return 2.0f * zeroToOne * zeroToOne;
        }
        float complement = 1.0f - zeroToOne;
        return 1.0f - 2.0f * complement * complement;
    }

    protected void setRelativeTargetValueAdjustingForMode(float zeroToOne) {
        float adjustedZeroToOne;
        switch (this.mode) {
            case 2: {
                adjustedZeroToOne = 1.0f - zeroToOne;
                break;
            }
            case 3: {
                if (zeroToOne <= 0.5f) {
                    adjustedZeroToOne = zeroToOne * 2.0f;
                    break;
                }
                adjustedZeroToOne = 2.0f * (1.0f - zeroToOne);
                break;
            }
            default: {
                adjustedZeroToOne = zeroToOne;
            }
        }
        this.setRelativeTargetValue(adjustedZeroToOne);
    }
}

