/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.common.http;

import io.stargate.sgv2.common.grpc.StargateBridgeClient;
import io.stargate.sgv2.common.grpc.StargateBridgeClientFactory;
import io.stargate.sgv2.common.http.CreateStargateBridgeClient;
import java.util.Optional;
import java.util.UUID;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;

@Provider
@CreateStargateBridgeClient
public abstract class CreateStargateBridgeClientFilter
implements ContainerRequestFilter {
    public static final String CLIENT_KEY = StargateBridgeClient.class.getName();
    private static final String HOST_HEADER_NAME = "Host";
    private static final String HOST_HEADER_NAME_LOWER = "host";
    private final StargateBridgeClientFactory stargateBridgeClientFactory;

    public CreateStargateBridgeClientFilter(StargateBridgeClientFactory stargateBridgeClientFactory) {
        this.stargateBridgeClientFactory = stargateBridgeClientFactory;
    }

    protected abstract Response buildError(Response.Status var1, String var2, MediaType var3);

    public void filter(ContainerRequestContext context) {
        String token = context.getHeaderString("X-Cassandra-Token");
        if (token == null || token.isEmpty()) {
            context.abortWith(this.buildError(Response.Status.UNAUTHORIZED, "Missing or invalid Auth Token", context.getMediaType()));
        } else {
            context.setProperty(CLIENT_KEY, (Object)this.stargateBridgeClientFactory.newClient(token, this.getTenantId((MultivaluedMap<String, String>)context.getHeaders())));
        }
    }

    private Optional<String> getTenantId(MultivaluedMap<String, String> headers) {
        String host = (String)headers.getFirst((Object)HOST_HEADER_NAME);
        if (host == null) {
            host = (String)headers.getFirst((Object)HOST_HEADER_NAME_LOWER);
        }
        return CreateStargateBridgeClientFilter.extractTenantId(host);
    }

    private static Optional<String> extractTenantId(String host) {
        if (host == null || host.length() < 36) {
            return Optional.empty();
        }
        try {
            UUID uuid = UUID.fromString(host.substring(0, 36));
            return Optional.of(uuid.toString());
        }
        catch (IllegalArgumentException __) {
            return Optional.empty();
        }
    }
}

