/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.common.grpc;

import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class UnaryStreamObserver<T>
implements StreamObserver<T> {
    private final CompletableFuture<T> future = new CompletableFuture();

    public void onNext(T value) {
        if (!this.future.complete(value)) {
            throw this.illegalState();
        }
    }

    public void onError(Throwable t) {
        if (!this.future.completeExceptionally(t)) {
            throw this.illegalState();
        }
    }

    public void onCompleted() {
    }

    public CompletionStage<T> asFuture() {
        return this.future;
    }

    private IllegalStateException illegalState() {
        return new IllegalStateException("onNext/onError should be called only once");
    }
}

