/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.common.grpc;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.grpc.Channel;
import io.stargate.proto.Schema;
import io.stargate.sgv2.common.grpc.DefaultStargateBridgeClient;
import io.stargate.sgv2.common.grpc.StargateBridgeClient;
import io.stargate.sgv2.common.grpc.StargateBridgeClientFactory;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

class DefaultStargateBridgeClientFactory
implements StargateBridgeClientFactory {
    private final Channel channel;
    private final Schema.SchemaRead.SourceApi sourceApi;
    private final Cache<String, Schema.CqlKeyspaceDescribe> keyspaceCache = Caffeine.newBuilder().maximumSize(1000L).expireAfterAccess(5L, TimeUnit.MINUTES).build();

    DefaultStargateBridgeClientFactory(Channel channel, Schema.SchemaRead.SourceApi sourceApi) {
        this.channel = channel;
        this.sourceApi = sourceApi;
    }

    @Override
    public StargateBridgeClient newClient(String authToken, Optional<String> tenantId) {
        return new DefaultStargateBridgeClient(this.channel, authToken, tenantId, this.keyspaceCache, this.sourceApi);
    }
}

