/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.common.cql;

import io.stargate.sgv2.common.cql.ReservedKeywords;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ColumnUtils {
    private static final Pattern PATTERN_DOUBLE_QUOTE = Pattern.compile("\"", 16);
    private static final String ESCAPED_DOUBLE_QUOTE = Matcher.quoteReplacement("\"\"");
    private static final Pattern UNQUOTED_IDENTIFIER = Pattern.compile("[a-z][a-z0-9_]*");

    public static String maybeQuote(String text) {
        if (UNQUOTED_IDENTIFIER.matcher(text).matches() && !ReservedKeywords.isReserved(text)) {
            return text;
        }
        return '\"' + PATTERN_DOUBLE_QUOTE.matcher(text).replaceAll(ESCAPED_DOUBLE_QUOTE) + '\"';
    }
}

