package io.stargate.sgv2.common.cql.builder;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ValueModifier}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableValueModifier.builder()}.
 */
@Generated(from = "ValueModifier", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableValueModifier implements ValueModifier {
  private final ValueModifier.Target target;
  private final ValueModifier.Operation operation;
  private final Term value;

  private ImmutableValueModifier(
      ValueModifier.Target target,
      ValueModifier.Operation operation,
      Term value) {
    this.target = target;
    this.operation = operation;
    this.value = value;
  }

  /**
   * @return The value of the {@code target} attribute
   */
  @Override
  public ValueModifier.Target target() {
    return target;
  }

  /**
   * @return The value of the {@code operation} attribute
   */
  @Override
  public ValueModifier.Operation operation() {
    return operation;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public Term value() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ValueModifier#target() target} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for target
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableValueModifier withTarget(ValueModifier.Target value) {
    if (this.target == value) return this;
    ValueModifier.Target newValue = Objects.requireNonNull(value, "target");
    return new ImmutableValueModifier(newValue, this.operation, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ValueModifier#operation() operation} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for operation
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableValueModifier withOperation(ValueModifier.Operation value) {
    if (this.operation == value) return this;
    ValueModifier.Operation newValue = Objects.requireNonNull(value, "operation");
    if (this.operation.equals(newValue)) return this;
    return new ImmutableValueModifier(this.target, newValue, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ValueModifier#value() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableValueModifier withValue(Term value) {
    if (this.value == value) return this;
    Term newValue = Objects.requireNonNull(value, "value");
    return new ImmutableValueModifier(this.target, this.operation, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableValueModifier} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableValueModifier
        && equalTo((ImmutableValueModifier) another);
  }

  private boolean equalTo(ImmutableValueModifier another) {
    return target.equals(another.target)
        && operation.equals(another.operation)
        && value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code target}, {@code operation}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + target.hashCode();
    h += (h << 5) + operation.hashCode();
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ValueModifier} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ValueModifier")
        .omitNullValues()
        .add("target", target)
        .add("operation", operation)
        .add("value", value)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ValueModifier} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ValueModifier instance
   */
  public static ImmutableValueModifier copyOf(ValueModifier instance) {
    if (instance instanceof ImmutableValueModifier) {
      return (ImmutableValueModifier) instance;
    }
    return ImmutableValueModifier.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableValueModifier ImmutableValueModifier}.
   * <pre>
   * ImmutableValueModifier.builder()
   *    .target(io.stargate.sgv2.common.cql.builder.ValueModifier.Target) // required {@link ValueModifier#target() target}
   *    .operation(io.stargate.sgv2.common.cql.builder.ValueModifier.Operation) // required {@link ValueModifier#operation() operation}
   *    .value(io.stargate.sgv2.common.cql.builder.Term) // required {@link ValueModifier#value() value}
   *    .build();
   * </pre>
   * @return A new ImmutableValueModifier builder
   */
  public static ImmutableValueModifier.Builder builder() {
    return new ImmutableValueModifier.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableValueModifier ImmutableValueModifier}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ValueModifier", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TARGET = 0x1L;
    private static final long INIT_BIT_OPERATION = 0x2L;
    private static final long INIT_BIT_VALUE = 0x4L;
    private long initBits = 0x7L;

    private @Nullable ValueModifier.Target target;
    private @Nullable ValueModifier.Operation operation;
    private @Nullable Term value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ValueModifier} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ValueModifier instance) {
      Objects.requireNonNull(instance, "instance");
      target(instance.target());
      operation(instance.operation());
      value(instance.value());
      return this;
    }

    /**
     * Initializes the value for the {@link ValueModifier#target() target} attribute.
     * @param target The value for target 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder target(ValueModifier.Target target) {
      this.target = Objects.requireNonNull(target, "target");
      initBits &= ~INIT_BIT_TARGET;
      return this;
    }

    /**
     * Initializes the value for the {@link ValueModifier#operation() operation} attribute.
     * @param operation The value for operation 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder operation(ValueModifier.Operation operation) {
      this.operation = Objects.requireNonNull(operation, "operation");
      initBits &= ~INIT_BIT_OPERATION;
      return this;
    }

    /**
     * Initializes the value for the {@link ValueModifier#value() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(Term value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableValueModifier ImmutableValueModifier}.
     * @return An immutable instance of ValueModifier
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableValueModifier build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableValueModifier(target, operation, value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TARGET) != 0) attributes.add("target");
      if ((initBits & INIT_BIT_OPERATION) != 0) attributes.add("operation");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build ValueModifier, some of required attributes are not set " + attributes;
    }
  }
}
