package io.stargate.sgv2.common.cql.builder;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Column}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableColumn.builder()}.
 */
@Generated(from = "Column", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableColumn implements Column {
  private final String name;
  private final @Nullable String type;
  private final @Nullable Column.Kind kind;
  private final @Nullable Column.Order order;
  private transient final int hashCode;

  private ImmutableColumn(
      String name,
      @Nullable String type,
      @Nullable Column.Kind kind,
      @Nullable Column.Order order) {
    this.name = name;
    this.type = type;
    this.kind = kind;
    this.order = order;
    this.hashCode = computeHashCode();
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   *TODO do we ever need a more structured representation? 
   */
  @Override
  public @Nullable String type() {
    return type;
  }

  /**
   * @return The value of the {@code kind} attribute
   */
  @Override
  public @Nullable Column.Kind kind() {
    return kind;
  }

  /**
   * @return The value of the {@code order} attribute
   */
  @Override
  public @Nullable Column.Order order() {
    return order;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Column#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumn withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableColumn(newValue, this.type, this.kind, this.order);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Column#type() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumn withType(@Nullable String value) {
    if (Objects.equals(this.type, value)) return this;
    return new ImmutableColumn(this.name, value, this.kind, this.order);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Column#kind() kind} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for kind (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumn withKind(@Nullable Column.Kind value) {
    if (this.kind == value) return this;
    if (Objects.equals(this.kind, value)) return this;
    return new ImmutableColumn(this.name, this.type, value, this.order);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Column#order() order} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for order (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumn withOrder(@Nullable Column.Order value) {
    if (this.order == value) return this;
    if (Objects.equals(this.order, value)) return this;
    return new ImmutableColumn(this.name, this.type, this.kind, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableColumn} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableColumn
        && equalTo((ImmutableColumn) another);
  }

  private boolean equalTo(ImmutableColumn another) {
    if (hashCode != another.hashCode) return false;
    return name.equals(another.name)
        && Objects.equals(type, another.type)
        && Objects.equals(kind, another.kind)
        && Objects.equals(order, another.order);
  }

  /**
   * Returns a precomputed-on-construction hash code from attributes: {@code name}, {@code type}, {@code kind}, {@code order}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return hashCode;
  }

  private int computeHashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(kind);
    h += (h << 5) + Objects.hashCode(order);
    return h;
  }

  /**
   * Prints the immutable value {@code Column} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Column")
        .omitNullValues()
        .add("name", name)
        .add("type", type)
        .add("kind", kind)
        .add("order", order)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long CQL_NAME_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient String cqlName;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Column#cqlName() cqlName} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code cqlName} attribute
   */
  @Override
  public String cqlName() {
    if ((lazyInitBitmap & CQL_NAME_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & CQL_NAME_LAZY_INIT_BIT) == 0) {
          this.cqlName = Objects.requireNonNull(Column.super.cqlName(), "cqlName");
          lazyInitBitmap |= CQL_NAME_LAZY_INIT_BIT;
        }
      }
    }
    return cqlName;
  }

  /**
   * Creates an immutable copy of a {@link Column} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Column instance
   */
  public static ImmutableColumn copyOf(Column instance) {
    if (instance instanceof ImmutableColumn) {
      return (ImmutableColumn) instance;
    }
    return ImmutableColumn.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableColumn ImmutableColumn}.
   * <pre>
   * ImmutableColumn.builder()
   *    .name(String) // required {@link Column#name() name}
   *    .type(String | null) // nullable {@link Column#type() type}
   *    .kind(io.stargate.sgv2.common.cql.builder.Column.Kind | null) // nullable {@link Column#kind() kind}
   *    .order(io.stargate.sgv2.common.cql.builder.Column.Order | null) // nullable {@link Column#order() order}
   *    .build();
   * </pre>
   * @return A new ImmutableColumn builder
   */
  public static ImmutableColumn.Builder builder() {
    return new ImmutableColumn.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableColumn ImmutableColumn}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Column", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String name;
    private @Nullable String type;
    private @Nullable Column.Kind kind;
    private @Nullable Column.Order order;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Column} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Column instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.name());
      @Nullable String typeValue = instance.type();
      if (typeValue != null) {
        type(typeValue);
      }
      @Nullable Column.Kind kindValue = instance.kind();
      if (kindValue != null) {
        kind(kindValue);
      }
      @Nullable Column.Order orderValue = instance.order();
      if (orderValue != null) {
        order(orderValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Column#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Column#type() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link Column#kind() kind} attribute.
     * @param kind The value for kind (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder kind(@Nullable Column.Kind kind) {
      this.kind = kind;
      return this;
    }

    /**
     * Initializes the value for the {@link Column#order() order} attribute.
     * @param order The value for order (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder order(@Nullable Column.Order order) {
      this.order = order;
      return this;
    }

    /**
     * Builds a new {@link ImmutableColumn ImmutableColumn}.
     * @return An immutable instance of Column
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableColumn build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableColumn(name, type, kind, order);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build Column, some of required attributes are not set " + attributes;
    }
  }
}
