/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.schema;

import com.google.protobuf.Int32Value;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import io.quarkus.cache.Cache;
import io.quarkus.cache.CacheName;
import io.quarkus.cache.CaffeineCache;
import io.quarkus.cache.CompositeCacheKey;
import io.quarkus.grpc.GrpcClient;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.mockito.InjectMock;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.test.AssertSubscriber;
import io.smallrye.mutiny.helpers.test.UniAssertSubscriber;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.stargate.bridge.grpc.Values;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.bridge.proto.Schema;
import io.stargate.bridge.proto.StargateBridge;
import io.stargate.bridge.proto.StargateBridgeGrpc;
import io.stargate.sgv2.api.common.StargateRequestInfo;
import io.stargate.sgv2.api.common.grpc.UnauthorizedKeyspaceException;
import io.stargate.sgv2.api.common.grpc.UnauthorizedTableException;
import io.stargate.sgv2.api.common.schema.SchemaManager;
import io.stargate.sgv2.common.bridge.BridgeTest;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.assertj.core.api.iterable.ThrowingExtractor;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@QuarkusTest
class SchemaManagerTest
extends BridgeTest {
    @Inject
    SchemaManager schemaManager;
    @Inject
    @CacheName(value="keyspace-cache")
    Cache keyspaceCache;
    @GrpcClient(value="bridge")
    StargateBridge bridge;
    @InjectMock
    StargateRequestInfo requestInfo;
    ArgumentCaptor<Schema.DescribeKeyspaceQuery> describeKeyspaceCaptor;
    ArgumentCaptor<Schema.AuthorizeSchemaReadsRequest> schemaReadsCaptor;
    ArgumentCaptor<QueryOuterClass.Query> queryCaptor;
    ArgumentCaptor<Schema.QueryWithSchema> queryWithSchemaCaptor;

    SchemaManagerTest() {
    }

    @BeforeEach
    public void init() {
        this.describeKeyspaceCaptor = ArgumentCaptor.forClass(Schema.DescribeKeyspaceQuery.class);
        this.schemaReadsCaptor = ArgumentCaptor.forClass(Schema.AuthorizeSchemaReadsRequest.class);
        this.queryCaptor = ArgumentCaptor.forClass(QueryOuterClass.Query.class);
        this.queryWithSchemaCaptor = ArgumentCaptor.forClass(Schema.QueryWithSchema.class);
        ((StargateRequestInfo)Mockito.doAnswer(invocation -> this.bridge).when((Object)this.requestInfo)).getStargateBridge();
    }

    @Nested
    class QueryWithSchemaAuthorized {
        QueryWithSchemaAuthorized() {
        }

        @Test
        public void happyPath() {
            String keyspace = RandomStringUtils.randomAlphanumeric((int)16);
            String table = RandomStringUtils.randomAlphanumeric((int)16);
            int hash = RandomUtils.nextInt();
            Schema.CqlKeyspace cqlKeyspace = Schema.CqlKeyspace.newBuilder().setName(keyspace).build();
            Schema.CqlTable cqlTable = Schema.CqlTable.newBuilder().setName(table).build();
            Schema.CqlKeyspaceDescribe keyspaceResponse = Schema.CqlKeyspaceDescribe.newBuilder().setCqlKeyspace(cqlKeyspace).setHash(Int32Value.of((int)hash)).addTables(cqlTable).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)keyspaceResponse);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            UniAssertSubscriber cache = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.getKeyspace(keyspace).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            cache.awaitItem().assertCompleted();
            QueryOuterClass.Response queryResponse = QueryOuterClass.Response.newBuilder().addWarnings("whatever").build();
            Schema.QueryWithSchemaResponse queryWithSchemaResponse = Schema.QueryWithSchemaResponse.newBuilder().setResponse(queryResponse).build();
            Schema.AuthorizeSchemaReadsResponse authResponse = Schema.AuthorizeSchemaReadsResponse.newBuilder().addAuthorized(true).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)authResponse);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).authorizeSchemaReads((Schema.AuthorizeSchemaReadsRequest)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)queryWithSchemaResponse);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).executeQueryWithSchema((Schema.QueryWithSchema)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            Function<Schema.CqlTable, Uni> queryFunction = t -> {
                String cql = "SELECT FROM %s".formatted(t.getName());
                QueryOuterClass.Query query = QueryOuterClass.Query.newBuilder().setCql(cql).build();
                return Uni.createFrom().item((Object)query);
            };
            UniAssertSubscriber result = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.queryWithSchemaAuthorized(keyspace, table, k -> Uni.createFrom().nothing(), queryFunction).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            result.awaitItem().assertItem((Object)queryResponse).assertCompleted();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)SchemaManagerTest.this.describeKeyspaceCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).authorizeSchemaReads((Schema.AuthorizeSchemaReadsRequest)SchemaManagerTest.this.schemaReadsCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).executeQueryWithSchema((Schema.QueryWithSchema)SchemaManagerTest.this.queryWithSchemaCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SchemaManagerTest.this.bridgeService});
            Assertions.assertThat((List)SchemaManagerTest.this.describeKeyspaceCaptor.getAllValues()).allSatisfy(r -> Assertions.assertThat((String)r.getKeyspaceName()).isEqualTo(keyspace));
            ((ObjectAssert)Assertions.assertThat((List)SchemaManagerTest.this.schemaReadsCaptor.getAllValues()).singleElement()).extracting(Schema.AuthorizeSchemaReadsRequest::getSchemaReadsList).satisfies(new ThrowingConsumer[]{reads -> ((ObjectAssert)Assertions.assertThat((List)reads).singleElement()).satisfies(new ThrowingConsumer[]{read -> {
                Assertions.assertThat((String)read.getKeyspaceName()).isEqualTo(keyspace);
                Assertions.assertThat((Comparable)read.getElementType()).isEqualTo((Object)Schema.SchemaRead.ElementType.KEYSPACE);
            }})});
            Assertions.assertThat((List)SchemaManagerTest.this.queryWithSchemaCaptor.getAllValues()).allSatisfy(queryWithSchema -> {
                Assertions.assertThat((String)queryWithSchema.getKeyspaceName()).isEqualTo(keyspace);
                Assertions.assertThat((int)queryWithSchema.getKeyspaceHash()).isEqualTo(hash);
                Assertions.assertThat((String)queryWithSchema.getQuery().getCql()).isEqualTo("SELECT FROM %s".formatted(table));
            });
        }
    }

    @Nested
    class QueryWithSchema {
        QueryWithSchema() {
        }

        @Test
        public void happyPath() {
            String keyspace = RandomStringUtils.randomAlphanumeric((int)16);
            String table = RandomStringUtils.randomAlphanumeric((int)16);
            int hash = RandomUtils.nextInt();
            Schema.CqlKeyspace cqlKeyspace = Schema.CqlKeyspace.newBuilder().setName(keyspace).build();
            Schema.CqlTable cqlTable = Schema.CqlTable.newBuilder().setName(table).build();
            Schema.CqlKeyspaceDescribe keyspaceResponse = Schema.CqlKeyspaceDescribe.newBuilder().setCqlKeyspace(cqlKeyspace).setHash(Int32Value.of((int)hash)).addTables(cqlTable).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)keyspaceResponse);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            UniAssertSubscriber cache = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.getKeyspace(keyspace).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            cache.awaitItem().assertCompleted();
            QueryOuterClass.Response queryResponse = QueryOuterClass.Response.newBuilder().addWarnings("whatever").build();
            Schema.QueryWithSchemaResponse queryWithSchemaResponse = Schema.QueryWithSchemaResponse.newBuilder().setResponse(queryResponse).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)queryWithSchemaResponse);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).executeQueryWithSchema((Schema.QueryWithSchema)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            Function<Schema.CqlTable, Uni> queryFunction = t -> {
                String cql = "SELECT FROM %s".formatted(t.getName());
                QueryOuterClass.Query query = QueryOuterClass.Query.newBuilder().setCql(cql).build();
                return Uni.createFrom().item((Object)query);
            };
            UniAssertSubscriber result = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.queryWithSchema(keyspace, table, k -> {
                throw new RuntimeException("Must not throw!");
            }, queryFunction).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            result.awaitItem().assertItem((Object)queryResponse).assertCompleted();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)SchemaManagerTest.this.describeKeyspaceCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).executeQueryWithSchema((Schema.QueryWithSchema)SchemaManagerTest.this.queryWithSchemaCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SchemaManagerTest.this.bridgeService});
            Assertions.assertThat((List)SchemaManagerTest.this.describeKeyspaceCaptor.getAllValues()).allSatisfy(r -> Assertions.assertThat((String)r.getKeyspaceName()).isEqualTo(keyspace));
            Assertions.assertThat((List)SchemaManagerTest.this.queryWithSchemaCaptor.getAllValues()).allSatisfy(queryWithSchema -> {
                Assertions.assertThat((String)queryWithSchema.getKeyspaceName()).isEqualTo(keyspace);
                Assertions.assertThat((int)queryWithSchema.getKeyspaceHash()).isEqualTo(hash);
                Assertions.assertThat((String)queryWithSchema.getQuery().getCql()).isEqualTo("SELECT FROM %s".formatted(table));
            });
        }

        @Test
        public void happyPathWithoutPreCaching() {
            String keyspace = RandomStringUtils.randomAlphanumeric((int)16);
            String table = RandomStringUtils.randomAlphanumeric((int)16);
            int hash = RandomUtils.nextInt();
            Schema.CqlKeyspace cqlKeyspace = Schema.CqlKeyspace.newBuilder().setName(keyspace).build();
            Schema.CqlTable cqlTable = Schema.CqlTable.newBuilder().setName(table).build();
            Schema.CqlKeyspaceDescribe keyspaceResponse = Schema.CqlKeyspaceDescribe.newBuilder().setCqlKeyspace(cqlKeyspace).setHash(Int32Value.of((int)hash)).addTables(cqlTable).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)keyspaceResponse);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            QueryOuterClass.Response queryResponse = QueryOuterClass.Response.newBuilder().addWarnings("whatever").build();
            Schema.QueryWithSchemaResponse queryWithSchemaResponse = Schema.QueryWithSchemaResponse.newBuilder().setResponse(queryResponse).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)queryWithSchemaResponse);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).executeQueryWithSchema((Schema.QueryWithSchema)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            Function<Schema.CqlTable, Uni> queryFunction = t -> {
                String cql = "SELECT FROM %s".formatted(t.getName());
                QueryOuterClass.Query query = QueryOuterClass.Query.newBuilder().setCql(cql).build();
                return Uni.createFrom().item((Object)query);
            };
            UniAssertSubscriber result = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.queryWithSchema(keyspace, table, k -> {
                throw new RuntimeException("Must not throw!");
            }, queryFunction).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            result.awaitItem().assertItem((Object)queryResponse).assertCompleted();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)SchemaManagerTest.this.describeKeyspaceCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).executeQueryWithSchema((Schema.QueryWithSchema)SchemaManagerTest.this.queryWithSchemaCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SchemaManagerTest.this.bridgeService});
            Assertions.assertThat((List)SchemaManagerTest.this.describeKeyspaceCaptor.getAllValues()).allSatisfy(r -> Assertions.assertThat((String)r.getKeyspaceName()).isEqualTo(keyspace));
            Assertions.assertThat((List)SchemaManagerTest.this.queryWithSchemaCaptor.getAllValues()).allSatisfy(queryWithSchema -> {
                Assertions.assertThat((String)queryWithSchema.getKeyspaceName()).isEqualTo(keyspace);
                Assertions.assertThat((int)queryWithSchema.getKeyspaceHash()).isEqualTo(hash);
                Assertions.assertThat((String)queryWithSchema.getQuery().getCql()).isEqualTo("SELECT FROM %s".formatted(table));
            });
        }

        @Test
        public void keyspaceRemoved() {
            String keyspace = RandomStringUtils.randomAlphanumeric((int)16);
            String table = RandomStringUtils.randomAlphanumeric((int)16);
            int hash = RandomUtils.nextInt();
            Schema.CqlKeyspace cqlKeyspace = Schema.CqlKeyspace.newBuilder().setName(keyspace).build();
            Schema.CqlTable cqlTable = Schema.CqlTable.newBuilder().setName(table).build();
            Schema.CqlKeyspaceDescribe keyspaceResponse = Schema.CqlKeyspaceDescribe.newBuilder().setCqlKeyspace(cqlKeyspace).setHash(Int32Value.of((int)hash)).addTables(cqlTable).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)keyspaceResponse);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            UniAssertSubscriber cache = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.getKeyspace(keyspace).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            cache.awaitItem().assertCompleted();
            Schema.QueryWithSchemaResponse queryWithSchemaResponse = Schema.QueryWithSchemaResponse.newBuilder().setNoKeyspace(Schema.QueryWithSchemaResponse.NoKeyspace.newBuilder().build()).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)queryWithSchemaResponse);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).executeQueryWithSchema((Schema.QueryWithSchema)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            Function<Schema.CqlTable, Uni> queryFunction = t -> {
                String cql = "SELECT FROM %s".formatted(t.getName());
                QueryOuterClass.Query query = QueryOuterClass.Query.newBuilder().setCql(cql).build();
                return Uni.createFrom().item((Object)query);
            };
            RuntimeException exception = new RuntimeException("my-exception");
            Function<String, Uni> missingKeyspace = k -> Uni.createFrom().failure((Throwable)exception);
            UniAssertSubscriber result = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.queryWithSchema(keyspace, table, missingKeyspace, queryFunction).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            Throwable failure = result.awaitFailure().getFailure();
            Assertions.assertThat((Throwable)failure).isEqualTo((Object)exception);
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)SchemaManagerTest.this.describeKeyspaceCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).executeQueryWithSchema((Schema.QueryWithSchema)SchemaManagerTest.this.queryWithSchemaCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SchemaManagerTest.this.bridgeService});
            Assertions.assertThat((List)SchemaManagerTest.this.describeKeyspaceCaptor.getAllValues()).allSatisfy(r -> Assertions.assertThat((String)r.getKeyspaceName()).isEqualTo(keyspace));
            Assertions.assertThat((List)SchemaManagerTest.this.queryWithSchemaCaptor.getAllValues()).allSatisfy(queryWithSchema -> {
                Assertions.assertThat((String)queryWithSchema.getKeyspaceName()).isEqualTo(keyspace);
                Assertions.assertThat((int)queryWithSchema.getKeyspaceHash()).isEqualTo(hash);
                Assertions.assertThat((String)queryWithSchema.getQuery().getCql()).isEqualTo("SELECT FROM %s".formatted(table));
            });
        }

        @Test
        public void keyspaceUpdated() throws Exception {
            String keyspace = RandomStringUtils.randomAlphanumeric((int)16);
            String table = RandomStringUtils.randomAlphanumeric((int)16);
            int hash = RandomUtils.nextInt();
            Schema.CqlKeyspace cqlKeyspace = Schema.CqlKeyspace.newBuilder().setName(keyspace).build();
            Schema.CqlTable cqlTable = Schema.CqlTable.newBuilder().setName(table).build();
            Schema.CqlKeyspaceDescribe keyspaceResponse = Schema.CqlKeyspaceDescribe.newBuilder().setCqlKeyspace(cqlKeyspace).setHash(Int32Value.of((int)hash)).addTables(cqlTable).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)keyspaceResponse);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            UniAssertSubscriber cache = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.getKeyspace(keyspace).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            cache.awaitItem().assertCompleted();
            int updatedHash = RandomUtils.nextInt();
            Schema.CqlKeyspace updatedCqlKeyspace = Schema.CqlKeyspace.newBuilder().setName(keyspace).build();
            Schema.CqlTable updatedCqlTable = Schema.CqlTable.newBuilder().setName(table).addColumns(QueryOuterClass.ColumnSpec.newBuilder().setName("column").build()).build();
            Schema.CqlKeyspaceDescribe updatedKeyspace = Schema.CqlKeyspaceDescribe.newBuilder().setCqlKeyspace(updatedCqlKeyspace).setHash(Int32Value.of((int)updatedHash)).addTables(updatedCqlTable).build();
            Schema.QueryWithSchemaResponse updatedKeyspaceResponse = Schema.QueryWithSchemaResponse.newBuilder().setNewKeyspace(updatedKeyspace).build();
            QueryOuterClass.Response queryResponse = QueryOuterClass.Response.newBuilder().addWarnings("whatever").build();
            Schema.QueryWithSchemaResponse queryExecutedResponse = Schema.QueryWithSchemaResponse.newBuilder().setResponse(queryResponse).build();
            AtomicInteger callCount = new AtomicInteger(0);
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                int call = callCount.getAndIncrement();
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)(call == 0 ? updatedKeyspaceResponse : queryExecutedResponse));
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).executeQueryWithSchema((Schema.QueryWithSchema)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            Function<Schema.CqlTable, Uni> queryFunction = t -> {
                String col = t.getColumnsList().isEmpty() ? "*" : ((QueryOuterClass.ColumnSpec)t.getColumnsList().get(0)).getName();
                String cql = "SELECT %s FROM %s".formatted(col, t.getName());
                QueryOuterClass.Query query = QueryOuterClass.Query.newBuilder().setCql(cql).build();
                return Uni.createFrom().item((Object)query);
            };
            UniAssertSubscriber result = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.queryWithSchema(keyspace, table, k -> Uni.createFrom().nothing(), queryFunction).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            result.awaitItem().assertItem((Object)queryResponse).assertCompleted();
            CompletableFuture cachedKeyspace = ((CaffeineCache)SchemaManagerTest.this.keyspaceCache.as(CaffeineCache.class)).getIfPresent((Object)new CompositeCacheKey(new Object[]{keyspace, Optional.empty()}));
            Assertions.assertThat((CompletableFuture)cachedKeyspace).isNotNull();
            Assertions.assertThat(cachedKeyspace.get()).isEqualTo((Object)updatedKeyspace);
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)SchemaManagerTest.this.describeKeyspaceCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService, (VerificationMode)Mockito.times((int)2))).executeQueryWithSchema((Schema.QueryWithSchema)SchemaManagerTest.this.queryWithSchemaCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SchemaManagerTest.this.bridgeService});
            Assertions.assertThat((List)SchemaManagerTest.this.describeKeyspaceCaptor.getAllValues()).allSatisfy(r -> Assertions.assertThat((String)r.getKeyspaceName()).isEqualTo(keyspace));
            ((ListAssert)((ListAssert)Assertions.assertThat((List)SchemaManagerTest.this.queryWithSchemaCaptor.getAllValues()).hasSize(2)).anySatisfy(queryWithSchema -> {
                Assertions.assertThat((String)queryWithSchema.getKeyspaceName()).isEqualTo(keyspace);
                Assertions.assertThat((int)queryWithSchema.getKeyspaceHash()).isEqualTo(hash);
                Assertions.assertThat((String)queryWithSchema.getQuery().getCql()).isEqualTo("SELECT * FROM %s".formatted(table));
            })).anySatisfy(queryWithSchema -> {
                Assertions.assertThat((String)queryWithSchema.getKeyspaceName()).isEqualTo(keyspace);
                Assertions.assertThat((int)queryWithSchema.getKeyspaceHash()).isEqualTo(updatedHash);
                Assertions.assertThat((String)queryWithSchema.getQuery().getCql()).isEqualTo("SELECT column FROM %s".formatted(table));
            });
        }

        @Test
        public void tableDoesNotExistRevalidate() throws Exception {
            String keyspace = RandomStringUtils.randomAlphanumeric((int)16);
            String table = RandomStringUtils.randomAlphanumeric((int)16);
            int withTableHash = RandomUtils.nextInt();
            int withoutTableHash = RandomUtils.nextInt();
            Schema.CqlKeyspace cqlKeyspace = Schema.CqlKeyspace.newBuilder().setName(keyspace).build();
            Schema.CqlTable cqlTable = Schema.CqlTable.newBuilder().setName(table).build();
            Schema.CqlKeyspaceDescribe keyspaceResponse = Schema.CqlKeyspaceDescribe.newBuilder().setCqlKeyspace(cqlKeyspace).setHash(Int32Value.of((int)withTableHash)).addTables(cqlTable).build();
            Schema.CqlKeyspaceDescribe keyspaceWithoutTableResponse = Schema.CqlKeyspaceDescribe.newBuilder().setCqlKeyspace(cqlKeyspace).setHash(Int32Value.of((int)withoutTableHash)).build();
            AtomicInteger describeCalls = new AtomicInteger(0);
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                int call = describeCalls.getAndIncrement();
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)(call == 0 ? keyspaceWithoutTableResponse : keyspaceResponse));
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            UniAssertSubscriber cache = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.getKeyspace(keyspace).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            cache.awaitItem().assertCompleted();
            QueryOuterClass.Response queryResponse = QueryOuterClass.Response.newBuilder().addWarnings("whatever").build();
            Schema.QueryWithSchemaResponse queryWithSchemaResponse = Schema.QueryWithSchemaResponse.newBuilder().setResponse(queryResponse).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)queryWithSchemaResponse);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).executeQueryWithSchema((Schema.QueryWithSchema)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            Function<Schema.CqlTable, Uni> queryFunction = t -> {
                String cql = "SELECT FROM %s".formatted(t.getName());
                QueryOuterClass.Query query = QueryOuterClass.Query.newBuilder().setCql(cql).build();
                return Uni.createFrom().item((Object)query);
            };
            UniAssertSubscriber result = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.queryWithSchema(keyspace, table, k -> {
                throw new RuntimeException("Must not throw!");
            }, queryFunction).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            result.awaitItem().assertItem((Object)queryResponse).assertCompleted();
            CompletableFuture cachedKeyspace = ((CaffeineCache)SchemaManagerTest.this.keyspaceCache.as(CaffeineCache.class)).getIfPresent((Object)new CompositeCacheKey(new Object[]{keyspace, Optional.empty()}));
            Assertions.assertThat((CompletableFuture)cachedKeyspace).isNotNull();
            Assertions.assertThat(cachedKeyspace.get()).isEqualTo((Object)keyspaceResponse);
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService, (VerificationMode)Mockito.times((int)2))).describeKeyspace((Schema.DescribeKeyspaceQuery)SchemaManagerTest.this.describeKeyspaceCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).executeQueryWithSchema((Schema.QueryWithSchema)SchemaManagerTest.this.queryWithSchemaCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SchemaManagerTest.this.bridgeService});
            Assertions.assertThat((List)SchemaManagerTest.this.describeKeyspaceCaptor.getAllValues()).allSatisfy(r -> Assertions.assertThat((String)r.getKeyspaceName()).isEqualTo(keyspace));
            Assertions.assertThat((List)SchemaManagerTest.this.queryWithSchemaCaptor.getAllValues()).allSatisfy(queryWithSchema -> {
                Assertions.assertThat((String)queryWithSchema.getKeyspaceName()).isEqualTo(keyspace);
                Assertions.assertThat((int)queryWithSchema.getKeyspaceHash()).isEqualTo(withTableHash);
                Assertions.assertThat((String)queryWithSchema.getQuery().getCql()).isEqualTo("SELECT FROM %s".formatted(table));
            });
        }

        @Test
        public void tableDoesNotExist() {
            String keyspace = RandomStringUtils.randomAlphanumeric((int)16);
            String table = RandomStringUtils.randomAlphanumeric((int)16);
            int withoutTableHash = RandomUtils.nextInt();
            Schema.CqlKeyspace cqlKeyspace = Schema.CqlKeyspace.newBuilder().setName(keyspace).build();
            Schema.CqlKeyspaceDescribe keyspaceWithoutTableResponse = Schema.CqlKeyspaceDescribe.newBuilder().setCqlKeyspace(cqlKeyspace).setHash(Int32Value.of((int)withoutTableHash)).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)keyspaceWithoutTableResponse);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            UniAssertSubscriber cache = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.getKeyspace(keyspace).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            cache.awaitItem().assertCompleted();
            QueryOuterClass.Response queryResponse = QueryOuterClass.Response.newBuilder().addWarnings("whatever").build();
            Schema.QueryWithSchemaResponse queryWithSchemaResponse = Schema.QueryWithSchemaResponse.newBuilder().setResponse(queryResponse).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)queryWithSchemaResponse);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).executeQueryWithSchema((Schema.QueryWithSchema)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            RuntimeException notExistingEx = new RuntimeException("Table not existing");
            Function<Schema.CqlTable, Uni> queryFunction = t -> {
                if (t == null) {
                    throw notExistingEx;
                }
                String cql = "SELECT FROM %s".formatted(t.getName());
                QueryOuterClass.Query query = QueryOuterClass.Query.newBuilder().setCql(cql).build();
                return Uni.createFrom().item((Object)query);
            };
            Throwable failure = ((UniAssertSubscriber)SchemaManagerTest.this.schemaManager.queryWithSchema(keyspace, table, k -> {
                throw new RuntimeException("Must not throw!");
            }, queryFunction).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create())).awaitFailure().getFailure();
            Assertions.assertThat((Throwable)failure).isEqualTo((Object)notExistingEx);
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService, (VerificationMode)Mockito.times((int)2))).describeKeyspace((Schema.DescribeKeyspaceQuery)SchemaManagerTest.this.describeKeyspaceCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SchemaManagerTest.this.bridgeService});
            Assertions.assertThat((List)SchemaManagerTest.this.describeKeyspaceCaptor.getAllValues()).allSatisfy(r -> Assertions.assertThat((String)r.getKeyspaceName()).isEqualTo(keyspace));
        }

        @Test
        public void keyspaceDoesNotExist() {
            String keyspace = RandomStringUtils.randomAlphanumeric((int)16);
            String table = RandomStringUtils.randomAlphanumeric((int)16);
            RuntimeException exception = new RuntimeException("my-exception");
            Function<String, Uni> missingKeyspace = k -> Uni.createFrom().failure((Throwable)exception);
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                Status status = Status.NOT_FOUND;
                observer.onError((Throwable)new StatusRuntimeException(status));
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            UniAssertSubscriber result = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.queryWithSchema(keyspace, table, missingKeyspace, t -> null).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            Throwable failure = result.awaitFailure().getFailure();
            Assertions.assertThat((Throwable)failure).isEqualTo((Object)exception);
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)SchemaManagerTest.this.describeKeyspaceCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SchemaManagerTest.this.bridgeService});
            Assertions.assertThat((List)SchemaManagerTest.this.describeKeyspaceCaptor.getAllValues()).allSatisfy(r -> Assertions.assertThat((String)r.getKeyspaceName()).isEqualTo(keyspace));
        }
    }

    @Nested
    class GetTablesAuthorized {
        GetTablesAuthorized() {
        }

        @Test
        public void happyPath() {
            String keyspace = RandomStringUtils.randomAlphanumeric((int)16);
            String table1 = RandomStringUtils.randomAlphanumeric((int)16);
            String table2 = RandomStringUtils.randomAlphanumeric((int)16);
            Schema.AuthorizeSchemaReadsResponse authResponse = Schema.AuthorizeSchemaReadsResponse.newBuilder().addAllAuthorized(Arrays.asList(false, true)).build();
            Schema.CqlKeyspace cqlKeyspace = Schema.CqlKeyspace.newBuilder().setName(keyspace).build();
            Schema.CqlTable cqlTable1 = Schema.CqlTable.newBuilder().setName(table1).build();
            Schema.CqlTable cqlTable2 = Schema.CqlTable.newBuilder().setName(table2).build();
            Schema.CqlKeyspaceDescribe response = Schema.CqlKeyspaceDescribe.newBuilder().setCqlKeyspace(cqlKeyspace).addTables(cqlTable1).addTables(cqlTable2).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)authResponse);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).authorizeSchemaReads((Schema.AuthorizeSchemaReadsRequest)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)response);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            ((AssertSubscriber)SchemaManagerTest.this.schemaManager.getTablesAuthorized(keyspace, k -> {
                throw new RuntimeException("Must not throw!");
            }).subscribe().withSubscriber((MultiSubscriber)AssertSubscriber.create())).awaitNextItem().assertItems((Object[])new Schema.CqlTable[]{cqlTable2}).awaitCompletion().assertCompleted();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).authorizeSchemaReads((Schema.AuthorizeSchemaReadsRequest)SchemaManagerTest.this.schemaReadsCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)SchemaManagerTest.this.describeKeyspaceCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SchemaManagerTest.this.bridgeService});
            Assertions.assertThat((Collection)((CaffeineCache)SchemaManagerTest.this.keyspaceCache.as(CaffeineCache.class)).keySet()).contains(new Object[]{new CompositeCacheKey(new Object[]{keyspace, Optional.empty()})});
            ((ObjectAssert)Assertions.assertThat((List)SchemaManagerTest.this.schemaReadsCaptor.getAllValues()).singleElement()).extracting(Schema.AuthorizeSchemaReadsRequest::getSchemaReadsList).satisfies(new ThrowingConsumer[]{reads -> ((ListAssert)((ListAssert)Assertions.assertThat((List)reads).hasSize(2)).anySatisfy(read -> {
                Assertions.assertThat((String)read.getKeyspaceName()).isEqualTo(keyspace);
                Assertions.assertThat((String)read.getElementName().getValue()).isEqualTo(table1);
                Assertions.assertThat((Comparable)read.getElementType()).isEqualTo((Object)Schema.SchemaRead.ElementType.TABLE);
            })).anySatisfy(read -> {
                Assertions.assertThat((String)read.getKeyspaceName()).isEqualTo(keyspace);
                Assertions.assertThat((String)read.getElementName().getValue()).isEqualTo(table2);
                Assertions.assertThat((Comparable)read.getElementType()).isEqualTo((Object)Schema.SchemaRead.ElementType.TABLE);
            })});
        }
    }

    @Nested
    class GetTableAuthorized {
        GetTableAuthorized() {
        }

        @Test
        public void happyPath() {
            String keyspace = RandomStringUtils.randomAlphanumeric((int)16);
            String table = RandomStringUtils.randomAlphanumeric((int)16);
            Schema.AuthorizeSchemaReadsResponse authResponse = Schema.AuthorizeSchemaReadsResponse.newBuilder().addAuthorized(true).build();
            Schema.CqlKeyspace cqlKeyspace = Schema.CqlKeyspace.newBuilder().setName(keyspace).build();
            Schema.CqlTable cqlTable = Schema.CqlTable.newBuilder().setName(table).build();
            Schema.CqlKeyspaceDescribe response = Schema.CqlKeyspaceDescribe.newBuilder().setCqlKeyspace(cqlKeyspace).addTables(cqlTable).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)authResponse);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).authorizeSchemaReads((Schema.AuthorizeSchemaReadsRequest)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)response);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            UniAssertSubscriber result = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.getTableAuthorized(keyspace, table, k -> Uni.createFrom().nothing()).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            result.awaitItem().assertItem((Object)cqlTable).assertCompleted();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).authorizeSchemaReads((Schema.AuthorizeSchemaReadsRequest)SchemaManagerTest.this.schemaReadsCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)SchemaManagerTest.this.describeKeyspaceCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SchemaManagerTest.this.bridgeService});
            Assertions.assertThat((Collection)((CaffeineCache)SchemaManagerTest.this.keyspaceCache.as(CaffeineCache.class)).keySet()).contains(new Object[]{new CompositeCacheKey(new Object[]{keyspace, Optional.empty()})});
            ((ObjectAssert)Assertions.assertThat((List)SchemaManagerTest.this.schemaReadsCaptor.getAllValues()).singleElement()).extracting(Schema.AuthorizeSchemaReadsRequest::getSchemaReadsList).satisfies(new ThrowingConsumer[]{reads -> ((ObjectAssert)Assertions.assertThat((List)reads).singleElement()).satisfies(new ThrowingConsumer[]{read -> {
                Assertions.assertThat((String)read.getKeyspaceName()).isEqualTo(keyspace);
                Assertions.assertThat((String)read.getElementName().getValue()).isEqualTo(table);
                Assertions.assertThat((Comparable)read.getElementType()).isEqualTo((Object)Schema.SchemaRead.ElementType.TABLE);
            }})});
        }

        @Test
        public void notAuthorized() {
            String keyspace = RandomStringUtils.randomAlphanumeric((int)16);
            String table = RandomStringUtils.randomAlphanumeric((int)16);
            Schema.AuthorizeSchemaReadsResponse authResponse = Schema.AuthorizeSchemaReadsResponse.newBuilder().addAuthorized(false).build();
            Schema.CqlKeyspace cqlKeyspace = Schema.CqlKeyspace.newBuilder().setName(keyspace).build();
            Schema.CqlTable cqlTable = Schema.CqlTable.newBuilder().setName(table).build();
            Schema.CqlKeyspaceDescribe response = Schema.CqlKeyspaceDescribe.newBuilder().setCqlKeyspace(cqlKeyspace).addTables(cqlTable).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)authResponse);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).authorizeSchemaReads((Schema.AuthorizeSchemaReadsRequest)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)response);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            UniAssertSubscriber result = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.getTableAuthorized(keyspace, table, k -> Uni.createFrom().nothing()).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            result.awaitFailure().assertFailedWith(UnauthorizedTableException.class);
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).authorizeSchemaReads((Schema.AuthorizeSchemaReadsRequest)SchemaManagerTest.this.schemaReadsCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SchemaManagerTest.this.bridgeService});
        }
    }

    @Nested
    class GetTables {
        GetTables() {
        }

        @Test
        public void happyPath() {
            String keyspace = RandomStringUtils.randomAlphanumeric((int)16);
            String table1 = RandomStringUtils.randomAlphanumeric((int)16);
            String table2 = RandomStringUtils.randomAlphanumeric((int)16);
            Schema.CqlKeyspace cqlKeyspace = Schema.CqlKeyspace.newBuilder().setName(keyspace).build();
            Schema.CqlTable cqlTable1 = Schema.CqlTable.newBuilder().setName(table1).build();
            Schema.CqlTable cqlTable2 = Schema.CqlTable.newBuilder().setName(table2).build();
            Schema.CqlKeyspaceDescribe response = Schema.CqlKeyspaceDescribe.newBuilder().setCqlKeyspace(cqlKeyspace).addTables(cqlTable1).addTables(cqlTable2).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)response);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            ((AssertSubscriber)SchemaManagerTest.this.schemaManager.getTables(keyspace, k -> {
                throw new RuntimeException("Must not throw!");
            }).subscribe().withSubscriber((MultiSubscriber)AssertSubscriber.create())).awaitNextItems(2).assertItems((Object[])new Schema.CqlTable[]{cqlTable1, cqlTable2}).awaitCompletion().assertCompleted();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)SchemaManagerTest.this.describeKeyspaceCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SchemaManagerTest.this.bridgeService});
            Assertions.assertThat((Collection)((CaffeineCache)SchemaManagerTest.this.keyspaceCache.as(CaffeineCache.class)).keySet()).contains(new Object[]{new CompositeCacheKey(new Object[]{keyspace, Optional.empty()})});
        }

        @Test
        public void noTables() {
            String keyspace = RandomStringUtils.randomAlphanumeric((int)16);
            Schema.CqlKeyspace cqlKeyspace = Schema.CqlKeyspace.newBuilder().setName(keyspace).build();
            Schema.CqlKeyspaceDescribe response = Schema.CqlKeyspaceDescribe.newBuilder().setCqlKeyspace(cqlKeyspace).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)response);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            ((AssertSubscriber)SchemaManagerTest.this.schemaManager.getTables(keyspace, k -> Uni.createFrom().nothing()).subscribe().withSubscriber((MultiSubscriber)AssertSubscriber.create())).awaitCompletion().assertHasNotReceivedAnyItem().assertCompleted();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)SchemaManagerTest.this.describeKeyspaceCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SchemaManagerTest.this.bridgeService});
            Assertions.assertThat((Collection)((CaffeineCache)SchemaManagerTest.this.keyspaceCache.as(CaffeineCache.class)).keySet()).contains(new Object[]{new CompositeCacheKey(new Object[]{keyspace, Optional.empty()})});
        }

        @Test
        public void missingKeyspace() {
            String keyspace = RandomStringUtils.randomAlphanumeric((int)16);
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                Status status = Status.NOT_FOUND;
                observer.onError((Throwable)new StatusRuntimeException(status));
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            RuntimeException exception = new RuntimeException("Missing keyspace test exception.");
            Throwable failure = ((AssertSubscriber)SchemaManagerTest.this.schemaManager.getTables(keyspace, k -> Uni.createFrom().failure(exception)).subscribe().withSubscriber((MultiSubscriber)AssertSubscriber.create())).awaitFailure().getFailure();
            Assertions.assertThat((Throwable)failure).isEqualTo((Object)exception);
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)SchemaManagerTest.this.describeKeyspaceCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SchemaManagerTest.this.bridgeService});
            Assertions.assertThat((Collection)((CaffeineCache)SchemaManagerTest.this.keyspaceCache.as(CaffeineCache.class)).keySet()).doesNotContain(new Object[]{new CompositeCacheKey(new Object[]{keyspace, Optional.empty()})});
        }
    }

    @Nested
    class GetTable {
        GetTable() {
        }

        @Test
        public void happyPath() {
            String keyspace = RandomStringUtils.randomAlphanumeric((int)16);
            String table = RandomStringUtils.randomAlphanumeric((int)16);
            Schema.CqlKeyspace cqlKeyspace = Schema.CqlKeyspace.newBuilder().setName(keyspace).build();
            Schema.CqlTable cqlTable = Schema.CqlTable.newBuilder().setName(table).build();
            Schema.CqlKeyspaceDescribe response = Schema.CqlKeyspaceDescribe.newBuilder().setCqlKeyspace(cqlKeyspace).addTables(cqlTable).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)response);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            UniAssertSubscriber result = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.getTable(keyspace, table, k -> {
                throw new RuntimeException("Must not throw!");
            }).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            result.awaitItem().assertItem((Object)cqlTable).assertCompleted();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)SchemaManagerTest.this.describeKeyspaceCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SchemaManagerTest.this.bridgeService});
            Assertions.assertThat((Collection)((CaffeineCache)SchemaManagerTest.this.keyspaceCache.as(CaffeineCache.class)).keySet()).contains(new Object[]{new CompositeCacheKey(new Object[]{keyspace, Optional.empty()})});
        }

        @Test
        public void missingTable() {
            String keyspace = RandomStringUtils.randomAlphanumeric((int)16);
            String table = RandomStringUtils.randomAlphanumeric((int)16);
            Schema.CqlKeyspace cqlKeyspace = Schema.CqlKeyspace.newBuilder().setName(keyspace).build();
            Schema.CqlTable cqlTable = Schema.CqlTable.newBuilder().setName("other").build();
            Schema.CqlKeyspaceDescribe response = Schema.CqlKeyspaceDescribe.newBuilder().setCqlKeyspace(cqlKeyspace).addTables(cqlTable).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)response);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            UniAssertSubscriber result = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.getTable(keyspace, table, k -> Uni.createFrom().nothing()).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            result.awaitItem().assertItem(null).assertCompleted();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)SchemaManagerTest.this.describeKeyspaceCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SchemaManagerTest.this.bridgeService});
            Assertions.assertThat((Collection)((CaffeineCache)SchemaManagerTest.this.keyspaceCache.as(CaffeineCache.class)).keySet()).contains(new Object[]{new CompositeCacheKey(new Object[]{keyspace, Optional.empty()})});
        }

        @Test
        public void missingKeyspace() {
            String keyspace = RandomStringUtils.randomAlphanumeric((int)16);
            String table = RandomStringUtils.randomAlphanumeric((int)16);
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                Status status = Status.NOT_FOUND;
                observer.onError((Throwable)new StatusRuntimeException(status));
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            RuntimeException exception = new RuntimeException("Missing keyspace test exception.");
            UniAssertSubscriber result = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.getTable(keyspace, table, k -> Uni.createFrom().failure(exception)).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            Throwable failure = result.awaitFailure().getFailure();
            Assertions.assertThat((Throwable)failure).isEqualTo((Object)exception);
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)SchemaManagerTest.this.describeKeyspaceCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SchemaManagerTest.this.bridgeService});
            Assertions.assertThat((Collection)((CaffeineCache)SchemaManagerTest.this.keyspaceCache.as(CaffeineCache.class)).keySet()).doesNotContain(new Object[]{new CompositeCacheKey(new Object[]{keyspace, Optional.empty()})});
        }
    }

    @Nested
    class GetKeyspacesAuthorized {
        GetKeyspacesAuthorized() {
        }

        @Test
        public void happyPath() {
            String keyspace1 = RandomStringUtils.randomAlphanumeric((int)16);
            String keyspace2 = RandomStringUtils.randomAlphanumeric((int)16);
            QueryOuterClass.ResultSet.Builder resultSet = QueryOuterClass.ResultSet.newBuilder().addRows(QueryOuterClass.Row.newBuilder().addValues(Values.of((String)keyspace1)).build()).addRows(QueryOuterClass.Row.newBuilder().addValues(Values.of((String)keyspace2)).build());
            QueryOuterClass.Response queryResponse = QueryOuterClass.Response.newBuilder().setResultSet(resultSet).build();
            Schema.AuthorizeSchemaReadsResponse authResponse = Schema.AuthorizeSchemaReadsResponse.newBuilder().addAllAuthorized(Arrays.asList(true, false)).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                Schema.DescribeKeyspaceQuery query = (Schema.DescribeKeyspaceQuery)invocationOnMock.getArgument(0);
                String keyspace = query.getKeyspaceName();
                Schema.CqlKeyspace value = Schema.CqlKeyspace.newBuilder().setName(keyspace).build();
                Schema.CqlKeyspaceDescribe cqlKeyspace = Schema.CqlKeyspaceDescribe.newBuilder().setCqlKeyspace(value).build();
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)cqlKeyspace);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)authResponse);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).authorizeSchemaReads((Schema.AuthorizeSchemaReadsRequest)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)queryResponse);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).executeQuery((QueryOuterClass.Query)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            List result = ((AssertSubscriber)SchemaManagerTest.this.schemaManager.getKeyspacesAuthorized().subscribe().withSubscriber((MultiSubscriber)AssertSubscriber.create())).awaitNextItems(1).awaitCompletion().assertCompleted().getItems();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).authorizeSchemaReads((Schema.AuthorizeSchemaReadsRequest)SchemaManagerTest.this.schemaReadsCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)SchemaManagerTest.this.describeKeyspaceCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).executeQuery((QueryOuterClass.Query)SchemaManagerTest.this.queryCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SchemaManagerTest.this.bridgeService});
            Set cacheState = ((CaffeineCache)SchemaManagerTest.this.keyspaceCache.as(CaffeineCache.class)).keySet();
            Assertions.assertThat((Collection)cacheState).contains(new Object[]{new CompositeCacheKey(new Object[]{keyspace1, Optional.empty()})});
            Assertions.assertThat((Collection)cacheState).doesNotContain(new Object[]{new CompositeCacheKey(new Object[]{keyspace2, Optional.empty()})});
            ((ObjectAssert)Assertions.assertThat((List)result).singleElement()).satisfies(new ThrowingConsumer[]{k -> Assertions.assertThat((String)k.getCqlKeyspace().getName()).isEqualTo(keyspace1)});
            ((ObjectAssert)Assertions.assertThat((List)SchemaManagerTest.this.describeKeyspaceCaptor.getAllValues()).singleElement()).satisfies(new ThrowingConsumer[]{k -> Assertions.assertThat((String)k.getKeyspaceName()).isEqualTo(keyspace1)});
            ((ObjectAssert)Assertions.assertThat((List)SchemaManagerTest.this.queryCaptor.getAllValues()).singleElement()).satisfies(new ThrowingConsumer[]{query -> Assertions.assertThat((String)query.getCql()).isEqualTo("SELECT keyspace_name FROM system_schema.keyspaces")});
            ((ObjectAssert)Assertions.assertThat((List)SchemaManagerTest.this.schemaReadsCaptor.getAllValues()).singleElement()).extracting(Schema.AuthorizeSchemaReadsRequest::getSchemaReadsList).satisfies(new ThrowingConsumer[]{reads -> ((ListAssert)((ListAssert)Assertions.assertThat((List)reads).hasSize(2)).anySatisfy(read -> {
                Assertions.assertThat((String)read.getKeyspaceName()).isEqualTo(keyspace1);
                Assertions.assertThat((Comparable)read.getElementType()).isEqualTo((Object)Schema.SchemaRead.ElementType.KEYSPACE);
            })).anySatisfy(read -> {
                Assertions.assertThat((String)read.getKeyspaceName()).isEqualTo(keyspace2);
                Assertions.assertThat((Comparable)read.getElementType()).isEqualTo((Object)Schema.SchemaRead.ElementType.KEYSPACE);
            })});
        }
    }

    @Nested
    class GetKeyspaces {
        GetKeyspaces() {
        }

        @Test
        public void happyPath() {
            String keyspace1 = RandomStringUtils.randomAlphanumeric((int)16);
            String keyspace2 = RandomStringUtils.randomAlphanumeric((int)16);
            QueryOuterClass.ResultSet.Builder resultSet = QueryOuterClass.ResultSet.newBuilder().addRows(QueryOuterClass.Row.newBuilder().addValues(Values.of((String)keyspace1)).build()).addRows(QueryOuterClass.Row.newBuilder().addValues(Values.of((String)keyspace2)).build());
            QueryOuterClass.Response queryResponse = QueryOuterClass.Response.newBuilder().setResultSet(resultSet).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                Schema.DescribeKeyspaceQuery query = (Schema.DescribeKeyspaceQuery)invocationOnMock.getArgument(0);
                String keyspace = query.getKeyspaceName();
                Schema.CqlKeyspace value = Schema.CqlKeyspace.newBuilder().setName(keyspace).build();
                Schema.CqlKeyspaceDescribe cqlKeyspace = Schema.CqlKeyspaceDescribe.newBuilder().setCqlKeyspace(value).build();
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)cqlKeyspace);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)queryResponse);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).executeQuery((QueryOuterClass.Query)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            List result = ((AssertSubscriber)SchemaManagerTest.this.schemaManager.getKeyspaces().subscribe().withSubscriber((MultiSubscriber)AssertSubscriber.create())).awaitNextItems(2).awaitCompletion().assertCompleted().getItems();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService, (VerificationMode)Mockito.times((int)2))).describeKeyspace((Schema.DescribeKeyspaceQuery)SchemaManagerTest.this.describeKeyspaceCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).executeQuery((QueryOuterClass.Query)SchemaManagerTest.this.queryCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SchemaManagerTest.this.bridgeService});
            Set cacheState = ((CaffeineCache)SchemaManagerTest.this.keyspaceCache.as(CaffeineCache.class)).keySet();
            Assertions.assertThat((Collection)cacheState).contains(new Object[]{new CompositeCacheKey(new Object[]{keyspace1, Optional.empty()})});
            Assertions.assertThat((Collection)cacheState).contains(new Object[]{new CompositeCacheKey(new Object[]{keyspace2, Optional.empty()})});
            ((ListAssert)Assertions.assertThat((List)result).hasSize(2)).extracting(Schema.CqlKeyspaceDescribe::getCqlKeyspace).flatExtracting(new ThrowingExtractor[]{Schema.CqlKeyspace::getName}).contains(new Object[]{keyspace1, keyspace2});
            ((ListAssert)Assertions.assertThat((List)SchemaManagerTest.this.describeKeyspaceCaptor.getAllValues()).hasSize(2)).flatExtracting(new ThrowingExtractor[]{Schema.DescribeKeyspaceQuery::getKeyspaceName}).contains(new Object[]{keyspace1, keyspace2});
            ((ObjectAssert)Assertions.assertThat((List)SchemaManagerTest.this.queryCaptor.getAllValues()).singleElement()).satisfies(new ThrowingConsumer[]{query -> Assertions.assertThat((String)query.getCql()).isEqualTo("SELECT keyspace_name FROM system_schema.keyspaces")});
        }

        @Test
        public void noneExists() {
            QueryOuterClass.ResultSet.Builder resultSet = QueryOuterClass.ResultSet.newBuilder();
            QueryOuterClass.Response queryResponse = QueryOuterClass.Response.newBuilder().setResultSet(resultSet).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)queryResponse);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).executeQuery((QueryOuterClass.Query)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            ((AssertSubscriber)SchemaManagerTest.this.schemaManager.getKeyspaces().subscribe().withSubscriber((MultiSubscriber)AssertSubscriber.create())).awaitCompletion().assertCompleted().assertHasNotReceivedAnyItem();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).executeQuery((QueryOuterClass.Query)SchemaManagerTest.this.queryCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SchemaManagerTest.this.bridgeService});
            ((ObjectAssert)Assertions.assertThat((List)SchemaManagerTest.this.queryCaptor.getAllValues()).singleElement()).satisfies(new ThrowingConsumer[]{query -> Assertions.assertThat((String)query.getCql()).isEqualTo("SELECT keyspace_name FROM system_schema.keyspaces")});
        }

        @Test
        public void deletedBetweenCalls() {
            String keyspace1 = RandomStringUtils.randomAlphanumeric((int)16);
            String keyspace2 = RandomStringUtils.randomAlphanumeric((int)16);
            QueryOuterClass.ResultSet.Builder resultSet = QueryOuterClass.ResultSet.newBuilder().addRows(QueryOuterClass.Row.newBuilder().addValues(Values.of((String)keyspace1)).build()).addRows(QueryOuterClass.Row.newBuilder().addValues(Values.of((String)keyspace2)).build());
            QueryOuterClass.Response queryResponse = QueryOuterClass.Response.newBuilder().setResultSet(resultSet).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                Schema.DescribeKeyspaceQuery query = (Schema.DescribeKeyspaceQuery)invocationOnMock.getArgument(0);
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                String keyspace = query.getKeyspaceName();
                if (Objects.equals(keyspace, keyspace1)) {
                    Schema.CqlKeyspace value = Schema.CqlKeyspace.newBuilder().setName(keyspace).build();
                    Schema.CqlKeyspaceDescribe cqlKeyspace = Schema.CqlKeyspaceDescribe.newBuilder().setCqlKeyspace(value).build();
                    observer.onNext((Object)cqlKeyspace);
                    observer.onCompleted();
                } else {
                    Status status = Status.NOT_FOUND;
                    observer.onError((Throwable)new StatusRuntimeException(status));
                }
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)queryResponse);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).executeQuery((QueryOuterClass.Query)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            List result = ((AssertSubscriber)SchemaManagerTest.this.schemaManager.getKeyspaces().subscribe().withSubscriber((MultiSubscriber)AssertSubscriber.create())).awaitNextItems(1).awaitCompletion().assertCompleted().getItems();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService, (VerificationMode)Mockito.times((int)2))).describeKeyspace((Schema.DescribeKeyspaceQuery)SchemaManagerTest.this.describeKeyspaceCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).executeQuery((QueryOuterClass.Query)SchemaManagerTest.this.queryCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SchemaManagerTest.this.bridgeService});
            Set cacheState = ((CaffeineCache)SchemaManagerTest.this.keyspaceCache.as(CaffeineCache.class)).keySet();
            Assertions.assertThat((Collection)cacheState).contains(new Object[]{new CompositeCacheKey(new Object[]{keyspace1, Optional.empty()})});
            Assertions.assertThat((Collection)cacheState).doesNotContain(new Object[]{new CompositeCacheKey(new Object[]{keyspace2, Optional.empty()})});
            ((ObjectAssert)Assertions.assertThat((List)result).singleElement()).satisfies(new ThrowingConsumer[]{k -> Assertions.assertThat((String)k.getCqlKeyspace().getName()).isEqualTo(keyspace1)});
            ((ListAssert)Assertions.assertThat((List)SchemaManagerTest.this.describeKeyspaceCaptor.getAllValues()).hasSize(2)).flatExtracting(new ThrowingExtractor[]{Schema.DescribeKeyspaceQuery::getKeyspaceName}).contains(new Object[]{keyspace1, keyspace2});
            ((ObjectAssert)Assertions.assertThat((List)SchemaManagerTest.this.queryCaptor.getAllValues()).singleElement()).satisfies(new ThrowingConsumer[]{query -> Assertions.assertThat((String)query.getCql()).isEqualTo("SELECT keyspace_name FROM system_schema.keyspaces")});
        }
    }

    @Nested
    class GetKeyspaceAuthorized {
        GetKeyspaceAuthorized() {
        }

        @Test
        public void happyPath() {
            String keyspace = RandomStringUtils.randomAlphanumeric((int)16);
            Schema.CqlKeyspace value = Schema.CqlKeyspace.newBuilder().setName(keyspace).build();
            Schema.AuthorizeSchemaReadsResponse authResponse = Schema.AuthorizeSchemaReadsResponse.newBuilder().addAuthorized(true).build();
            Schema.CqlKeyspaceDescribe response = Schema.CqlKeyspaceDescribe.newBuilder().setCqlKeyspace(value).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)authResponse);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).authorizeSchemaReads((Schema.AuthorizeSchemaReadsRequest)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)response);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            UniAssertSubscriber result = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.getKeyspaceAuthorized(keyspace).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            result.awaitItem().assertItem((Object)response).assertCompleted();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).authorizeSchemaReads((Schema.AuthorizeSchemaReadsRequest)SchemaManagerTest.this.schemaReadsCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)SchemaManagerTest.this.describeKeyspaceCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SchemaManagerTest.this.bridgeService});
            Assertions.assertThat((Collection)((CaffeineCache)SchemaManagerTest.this.keyspaceCache.as(CaffeineCache.class)).keySet()).contains(new Object[]{new CompositeCacheKey(new Object[]{keyspace, Optional.empty()})});
            ((ObjectAssert)Assertions.assertThat((List)SchemaManagerTest.this.schemaReadsCaptor.getAllValues()).singleElement()).extracting(Schema.AuthorizeSchemaReadsRequest::getSchemaReadsList).satisfies(new ThrowingConsumer[]{reads -> ((ObjectAssert)Assertions.assertThat((List)reads).singleElement()).satisfies(new ThrowingConsumer[]{read -> {
                Assertions.assertThat((String)read.getKeyspaceName()).isEqualTo(keyspace);
                Assertions.assertThat((Comparable)read.getElementType()).isEqualTo((Object)Schema.SchemaRead.ElementType.KEYSPACE);
            }})});
        }

        @Test
        public void cachedHashNotValidated() {
            String keyspace = RandomStringUtils.randomAlphanumeric((int)16);
            Schema.CqlKeyspace value = Schema.CqlKeyspace.newBuilder().setName(keyspace).build();
            Schema.AuthorizeSchemaReadsResponse authResponse = Schema.AuthorizeSchemaReadsResponse.newBuilder().addAuthorized(true).build();
            Schema.CqlKeyspaceDescribe response = Schema.CqlKeyspaceDescribe.newBuilder().setCqlKeyspace(value).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)authResponse);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).authorizeSchemaReads((Schema.AuthorizeSchemaReadsRequest)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)response);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            UniAssertSubscriber result = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.getKeyspaceAuthorized(keyspace, false).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            result.awaitItem().assertItem((Object)response).assertCompleted();
            UniAssertSubscriber cachedResult = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.getKeyspaceAuthorized(keyspace, false).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            cachedResult.awaitItem().assertItem((Object)response).assertCompleted();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService, (VerificationMode)Mockito.times((int)2))).authorizeSchemaReads((Schema.AuthorizeSchemaReadsRequest)SchemaManagerTest.this.schemaReadsCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)SchemaManagerTest.this.describeKeyspaceCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SchemaManagerTest.this.bridgeService});
            Assertions.assertThat((Collection)((CaffeineCache)SchemaManagerTest.this.keyspaceCache.as(CaffeineCache.class)).keySet()).contains(new Object[]{new CompositeCacheKey(new Object[]{keyspace, Optional.empty()})});
            ((ListAssert)Assertions.assertThat((List)SchemaManagerTest.this.schemaReadsCaptor.getAllValues()).hasSize(2)).allSatisfy(captured -> Assertions.assertThat((Object)captured).extracting(Schema.AuthorizeSchemaReadsRequest::getSchemaReadsList).satisfies(new ThrowingConsumer[]{reads -> ((ObjectAssert)Assertions.assertThat((List)reads).singleElement()).satisfies(new ThrowingConsumer[]{read -> {
                Assertions.assertThat((String)read.getKeyspaceName()).isEqualTo(keyspace);
                Assertions.assertThat((Comparable)read.getElementType()).isEqualTo((Object)Schema.SchemaRead.ElementType.KEYSPACE);
            }})}));
        }

        @Test
        public void notAuthorized() {
            String keyspace = RandomStringUtils.randomAlphanumeric((int)16);
            Schema.CqlKeyspace value = Schema.CqlKeyspace.newBuilder().setName(keyspace).build();
            Schema.AuthorizeSchemaReadsResponse authResponse = Schema.AuthorizeSchemaReadsResponse.newBuilder().addAuthorized(false).build();
            Schema.CqlKeyspaceDescribe response = Schema.CqlKeyspaceDescribe.newBuilder().setCqlKeyspace(value).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)authResponse);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).authorizeSchemaReads((Schema.AuthorizeSchemaReadsRequest)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)response);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            UniAssertSubscriber result = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.getKeyspaceAuthorized(keyspace).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            result.awaitFailure().assertFailedWith(UnauthorizedKeyspaceException.class);
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).authorizeSchemaReads((Schema.AuthorizeSchemaReadsRequest)SchemaManagerTest.this.schemaReadsCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SchemaManagerTest.this.bridgeService});
            Assertions.assertThat((Collection)((CaffeineCache)SchemaManagerTest.this.keyspaceCache.as(CaffeineCache.class)).keySet()).doesNotContain(new Object[]{new CompositeCacheKey(new Object[]{keyspace, Optional.empty()})});
        }
    }

    @Nested
    class GetKeyspace {
        GetKeyspace() {
        }

        @Test
        public void doesNotExist() {
            String keyspace = RandomStringUtils.randomAlphanumeric((int)16);
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                Status status = Status.NOT_FOUND;
                observer.onError((Throwable)new StatusRuntimeException(status));
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            UniAssertSubscriber result = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.getKeyspace(keyspace).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            result.awaitItem().assertItem(null).assertCompleted();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)SchemaManagerTest.this.describeKeyspaceCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SchemaManagerTest.this.bridgeService});
            Assertions.assertThat((Collection)((CaffeineCache)SchemaManagerTest.this.keyspaceCache.as(CaffeineCache.class)).keySet()).doesNotContain(new Object[]{new CompositeCacheKey(new Object[]{keyspace, Optional.empty()})});
        }

        @Test
        public void errorThenCached() {
            String keyspace = RandomStringUtils.randomAlphanumeric((int)16);
            Status status = Status.UNAVAILABLE;
            StatusRuntimeException error = new StatusRuntimeException(status);
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onError((Throwable)error);
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            UniAssertSubscriber result = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.getKeyspace(keyspace).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            result.awaitFailure().assertFailedWith(StatusRuntimeException.class);
            Schema.CqlKeyspace value = Schema.CqlKeyspace.newBuilder().setName(keyspace).build();
            Schema.CqlKeyspaceDescribe response = Schema.CqlKeyspaceDescribe.newBuilder().setCqlKeyspace(value).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)response);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            UniAssertSubscriber updatedResult = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.getKeyspace(keyspace).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            updatedResult.awaitItem().assertItem((Object)response).assertCompleted();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService, (VerificationMode)Mockito.times((int)2))).describeKeyspace((Schema.DescribeKeyspaceQuery)SchemaManagerTest.this.describeKeyspaceCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SchemaManagerTest.this.bridgeService});
            Assertions.assertThat((List)SchemaManagerTest.this.describeKeyspaceCaptor.getAllValues()).allSatisfy(r -> Assertions.assertThat((String)r.getKeyspaceName()).isEqualTo(keyspace));
            Assertions.assertThat((Collection)((CaffeineCache)SchemaManagerTest.this.keyspaceCache.as(CaffeineCache.class)).keySet()).contains(new Object[]{new CompositeCacheKey(new Object[]{keyspace, Optional.empty()})});
        }

        @Test
        public void notCached() {
            String keyspace = RandomStringUtils.randomAlphanumeric((int)16);
            Schema.CqlKeyspace value = Schema.CqlKeyspace.newBuilder().setName(keyspace).build();
            Schema.CqlKeyspaceDescribe response = Schema.CqlKeyspaceDescribe.newBuilder().setCqlKeyspace(value).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)response);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            UniAssertSubscriber result = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.getKeyspace(keyspace).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            result.awaitItem().assertItem((Object)response).assertCompleted();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)SchemaManagerTest.this.describeKeyspaceCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SchemaManagerTest.this.bridgeService});
            Assertions.assertThat((Collection)((CaffeineCache)SchemaManagerTest.this.keyspaceCache.as(CaffeineCache.class)).keySet()).contains(new Object[]{new CompositeCacheKey(new Object[]{keyspace, Optional.empty()})});
        }

        @Test
        public void notCachedMultiTenancy() {
            String keyspace = RandomStringUtils.randomAlphanumeric((int)16);
            String tenant1 = RandomStringUtils.randomAlphanumeric((int)16);
            String tenant2 = RandomStringUtils.randomAlphanumeric((int)16);
            Schema.CqlKeyspace value = Schema.CqlKeyspace.newBuilder().setName(keyspace).build();
            Schema.CqlKeyspaceDescribe response = Schema.CqlKeyspaceDescribe.newBuilder().setCqlKeyspace(value).build();
            Mockito.when((Object)SchemaManagerTest.this.requestInfo.getTenantId()).thenReturn(Optional.of(tenant1));
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)response);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            UniAssertSubscriber result = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.getKeyspace(keyspace).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            result.awaitItem().assertItem((Object)response).assertCompleted();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService, (VerificationMode)Mockito.times((int)1))).describeKeyspace((Schema.DescribeKeyspaceQuery)SchemaManagerTest.this.describeKeyspaceCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            Mockito.when((Object)SchemaManagerTest.this.requestInfo.getTenantId()).thenReturn(Optional.of(tenant2));
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)response);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            UniAssertSubscriber result2 = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.getKeyspace(keyspace).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            result2.awaitItem().assertItem((Object)response).assertCompleted();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService, (VerificationMode)Mockito.times((int)2))).describeKeyspace((Schema.DescribeKeyspaceQuery)SchemaManagerTest.this.describeKeyspaceCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SchemaManagerTest.this.bridgeService});
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)((CaffeineCache)SchemaManagerTest.this.keyspaceCache.as(CaffeineCache.class)).keySet()).contains(new Object[]{new CompositeCacheKey(new Object[]{keyspace, Optional.of(tenant1)})})).contains(new Object[]{new CompositeCacheKey(new Object[]{keyspace, Optional.of(tenant2)})});
        }

        @Test
        public void cachedUpdated() throws Exception {
            int hash = RandomUtils.nextInt();
            String keyspace = RandomStringUtils.randomAlphanumeric((int)16);
            Schema.CqlKeyspace value = Schema.CqlKeyspace.newBuilder().setName(keyspace).build();
            Schema.CqlKeyspaceDescribe response = Schema.CqlKeyspaceDescribe.newBuilder().setCqlKeyspace(value).setHash(Int32Value.newBuilder().setValue(hash)).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)response);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            UniAssertSubscriber result = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.getKeyspace(keyspace).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            result.awaitItem().assertItem((Object)response).assertCompleted();
            int updatedHash = RandomUtils.nextInt();
            Schema.CqlKeyspaceDescribe updatedResponse = Schema.CqlKeyspaceDescribe.newBuilder().setCqlKeyspace(value).setHash(Int32Value.newBuilder().setValue(updatedHash)).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)updatedResponse);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            UniAssertSubscriber updatedResult = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.getKeyspace(keyspace).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            updatedResult.awaitItem().assertItem((Object)updatedResponse).assertCompleted();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService, (VerificationMode)Mockito.times((int)2))).describeKeyspace((Schema.DescribeKeyspaceQuery)SchemaManagerTest.this.describeKeyspaceCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SchemaManagerTest.this.bridgeService});
            Assertions.assertThat((List)SchemaManagerTest.this.describeKeyspaceCaptor.getAllValues()).allSatisfy(r -> Assertions.assertThat((String)r.getKeyspaceName()).isEqualTo(keyspace));
            CompletableFuture cachedKeyspace = ((CaffeineCache)SchemaManagerTest.this.keyspaceCache.as(CaffeineCache.class)).getIfPresent((Object)new CompositeCacheKey(new Object[]{keyspace, Optional.empty()}));
            Assertions.assertThat((CompletableFuture)cachedKeyspace).isNotNull();
            Assertions.assertThat(cachedKeyspace.get()).isEqualTo((Object)updatedResponse);
        }

        @Test
        public void cachedNotUpdated() {
            int hash = RandomUtils.nextInt();
            String keyspace = RandomStringUtils.randomAlphanumeric((int)16);
            Schema.CqlKeyspace value = Schema.CqlKeyspace.newBuilder().setName(keyspace).build();
            Schema.CqlKeyspaceDescribe response = Schema.CqlKeyspaceDescribe.newBuilder().setCqlKeyspace(value).setHash(Int32Value.newBuilder().setValue(hash)).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)response);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            UniAssertSubscriber result = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.getKeyspace(keyspace).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            result.awaitItem().assertItem((Object)response).assertCompleted();
            Schema.CqlKeyspaceDescribe updatedResponse = Schema.CqlKeyspaceDescribe.newBuilder().setHash(Int32Value.newBuilder().setValue(hash)).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)updatedResponse);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            UniAssertSubscriber updatedResult = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.getKeyspace(keyspace).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            updatedResult.awaitItem().assertItem((Object)response).assertCompleted();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService, (VerificationMode)Mockito.times((int)2))).describeKeyspace((Schema.DescribeKeyspaceQuery)SchemaManagerTest.this.describeKeyspaceCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            Assertions.assertThat((List)SchemaManagerTest.this.describeKeyspaceCaptor.getAllValues()).allSatisfy(r -> Assertions.assertThat((String)r.getKeyspaceName()).isEqualTo(keyspace));
            Assertions.assertThat((Collection)((CaffeineCache)SchemaManagerTest.this.keyspaceCache.as(CaffeineCache.class)).keySet()).contains(new Object[]{new CompositeCacheKey(new Object[]{keyspace, Optional.empty()})});
        }

        @Test
        public void cachedThenRemoved() {
            int hash = RandomUtils.nextInt();
            String keyspace = RandomStringUtils.randomAlphanumeric((int)16);
            Schema.CqlKeyspace value = Schema.CqlKeyspace.newBuilder().setName(keyspace).build();
            Schema.CqlKeyspaceDescribe response = Schema.CqlKeyspaceDescribe.newBuilder().setCqlKeyspace(value).setHash(Int32Value.newBuilder().setValue(hash)).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)response);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            UniAssertSubscriber result = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.getKeyspace(keyspace).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            result.awaitItem().assertItem((Object)response).assertCompleted();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                Status status = Status.NOT_FOUND;
                observer.onError((Throwable)new StatusRuntimeException(status));
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            UniAssertSubscriber updatedResult = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.getKeyspace(keyspace).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            updatedResult.awaitItem().assertItem(null).assertCompleted();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService, (VerificationMode)Mockito.times((int)2))).describeKeyspace((Schema.DescribeKeyspaceQuery)SchemaManagerTest.this.describeKeyspaceCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SchemaManagerTest.this.bridgeService});
            Assertions.assertThat((List)SchemaManagerTest.this.describeKeyspaceCaptor.getAllValues()).allSatisfy(r -> Assertions.assertThat((String)r.getKeyspaceName()).isEqualTo(keyspace));
            Assertions.assertThat((Collection)((CaffeineCache)SchemaManagerTest.this.keyspaceCache.as(CaffeineCache.class)).keySet()).doesNotContain(new Object[]{new CompositeCacheKey(new Object[]{keyspace, Optional.empty()})});
        }

        @Test
        public void cachedHashNotValidated() {
            int hash = RandomUtils.nextInt();
            String keyspace = RandomStringUtils.randomAlphanumeric((int)16);
            Schema.CqlKeyspace value = Schema.CqlKeyspace.newBuilder().setName(keyspace).build();
            Schema.CqlKeyspaceDescribe response = Schema.CqlKeyspaceDescribe.newBuilder().setCqlKeyspace(value).setHash(Int32Value.newBuilder().setValue(hash)).build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)response);
                observer.onCompleted();
                return null;
            }).when((Object)SchemaManagerTest.this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            UniAssertSubscriber result = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.getKeyspace(keyspace, false).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            result.awaitItem().assertItem((Object)response).assertCompleted();
            UniAssertSubscriber cachedResult = (UniAssertSubscriber)SchemaManagerTest.this.schemaManager.getKeyspace(keyspace, false).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
            cachedResult.awaitItem().assertItem((Object)response).assertCompleted();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)SchemaManagerTest.this.bridgeService, (VerificationMode)Mockito.times((int)1))).describeKeyspace((Schema.DescribeKeyspaceQuery)SchemaManagerTest.this.describeKeyspaceCaptor.capture(), (StreamObserver)ArgumentMatchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{SchemaManagerTest.this.bridgeService});
            Assertions.assertThat((List)SchemaManagerTest.this.describeKeyspaceCaptor.getAllValues()).allSatisfy(r -> Assertions.assertThat((String)r.getKeyspaceName()).isEqualTo(keyspace));
            Assertions.assertThat((Collection)((CaffeineCache)SchemaManagerTest.this.keyspaceCache.as(CaffeineCache.class)).keySet()).contains(new Object[]{new CompositeCacheKey(new Object[]{keyspace, Optional.empty()})});
        }
    }
}

