/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.grpc;

import com.google.common.collect.ImmutableMap;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import io.quarkus.grpc.GrpcClient;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import io.smallrye.mutiny.helpers.test.UniAssertSubscriber;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.stargate.bridge.proto.MutinyStargateBridgeGrpc;
import io.stargate.bridge.proto.Schema;
import io.stargate.bridge.proto.StargateBridgeGrpc;
import io.stargate.sgv2.api.common.testprofiles.FixedTenantTestProfile;
import io.stargate.sgv2.common.bridge.BridgeTest;
import io.stargate.sgv2.common.testprofiles.NoGlobalResourcesTestProfile;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.apache.commons.lang3.RandomStringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@QuarkusTest
@TestProfile(value=Profile.class)
@Disabled(value="Disabled due to intermmittent failure, needs analysis")
class StargateBridgeInterceptorDeadlineTest
extends BridgeTest {
    @GrpcClient(value="bridge")
    MutinyStargateBridgeGrpc.MutinyStargateBridgeStub client;
    ArgumentCaptor<Metadata> headersCaptor;

    StargateBridgeInterceptorDeadlineTest() {
    }

    @BeforeEach
    public void init() {
        this.headersCaptor = ArgumentCaptor.forClass(Metadata.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void happyPath() {
        String keyspaceName = RandomStringUtils.randomAlphanumeric((int)16);
        Schema.DescribeKeyspaceQuery query = Schema.DescribeKeyspaceQuery.newBuilder().setKeyspaceName(keyspaceName).build();
        Schema.CqlKeyspaceDescribe response = Schema.CqlKeyspaceDescribe.newBuilder().setCqlKeyspace(Schema.CqlKeyspace.newBuilder().setName(keyspaceName).build()).buildPartial();
        Semaphore semaphore = new Semaphore(0);
        ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
            semaphore.acquire();
            return null;
        }).when((Object)this.bridgeService)).describeKeyspace((Schema.DescribeKeyspaceQuery)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
        UniAssertSubscriber result = (UniAssertSubscriber)this.client.describeKeyspace(query).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create());
        try {
            Throwable failure = result.awaitFailure().getFailure();
            Assertions.assertThat((Throwable)failure).isInstanceOfSatisfying(StatusRuntimeException.class, e -> Assertions.assertThat((Comparable)e.getStatus().getCode()).isEqualTo((Object)Status.Code.DEADLINE_EXCEEDED));
        }
        finally {
            semaphore.release();
        }
    }

    public static class Profile
    extends FixedTenantTestProfile
    implements NoGlobalResourcesTestProfile {
        @Override
        public Map<String, String> getConfigOverrides() {
            return ImmutableMap.builder().putAll(super.getConfigOverrides()).put((Object)"stargate.grpc.call-deadline", (Object)"PT1S").build();
        }
    }
}

