package io.stargate.bridge.proto;

import io.quarkus.grpc.MutinyService;

@jakarta.annotation.Generated(value = "by Mutiny Grpc generator", comments = "Source: bridge.proto")
public interface StargateBridge extends MutinyService {

    /**
     * <pre>
     *  Executes a single CQL query.
     * </pre>
     */
    io.smallrye.mutiny.Uni<io.stargate.bridge.proto.QueryOuterClass.Response> executeQuery(io.stargate.bridge.proto.QueryOuterClass.Query request);

    /**
     * <pre>
     *  Executes a single CQL query, assuming that a keyspace with the given version hash exists on the
     *  bridge side.
     *  This is an optimization when the client builds a query based on a keyspace&#39;s contents: with
     *  this operation, it can use its local version of the keyspace (therefore avoiding an extra
     *  network hop to fetch it), and execute the query optimistically. If the keyspace has changed,
     *  the bridge will reply with the new version, allowing the client to retry.
     * </pre>
     */
    io.smallrye.mutiny.Uni<io.stargate.bridge.proto.Schema.QueryWithSchemaResponse> executeQueryWithSchema(io.stargate.bridge.proto.Schema.QueryWithSchema request);

    /**
     * <pre>
     *  Executes a batch of CQL queries.
     * </pre>
     */
    io.smallrye.mutiny.Uni<io.stargate.bridge.proto.QueryOuterClass.Response> executeBatch(io.stargate.bridge.proto.QueryOuterClass.Batch request);

    /**
     * <pre>
     *  Similar to CQL &quot;DESCRIBE KEYSPACE&quot;.
     *  Note that this operation does not perform any authorization check. The rationale is that, most
     *  of the time, client services use schema metadata to build another query that will be
     *  immediately executed with `ExecuteQuery` (which does check authorization).
     *  If that is not the case (e.g. you return the metadata directly to the client), you can check
     *  authorization explicitly with `AuthorizeSchemaReads`.
     * </pre>
     */
    io.smallrye.mutiny.Uni<io.stargate.bridge.proto.Schema.CqlKeyspaceDescribe> describeKeyspace(io.stargate.bridge.proto.Schema.DescribeKeyspaceQuery request);

    /**
     * <pre>
     *  Checks whether the client is authorized to describe one or more schema elements.
     * </pre>
     */
    io.smallrye.mutiny.Uni<io.stargate.bridge.proto.Schema.AuthorizeSchemaReadsResponse> authorizeSchemaReads(io.stargate.bridge.proto.Schema.AuthorizeSchemaReadsRequest request);

    /**
     * <pre>
     *  Checks which features are supported by the persistence backend.
     * </pre>
     */
    io.smallrye.mutiny.Uni<io.stargate.bridge.proto.Schema.SupportedFeaturesResponse> getSupportedFeatures(io.stargate.bridge.proto.Schema.SupportedFeaturesRequest request);
}
