/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.grpc;

import io.smallrye.mutiny.Uni;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.bridge.proto.Schema;
import io.stargate.sgv2.api.common.StargateRequestInfo;
import io.stargate.sgv2.api.common.grpc.StargateBridgeClient;
import io.stargate.sgv2.api.common.schema.SchemaManager;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.apache.commons.codec.binary.Hex;

@ApplicationScoped
public class StargateBridgeClientImpl
implements StargateBridgeClient {
    private static final Function<String, Uni<? extends Schema.CqlKeyspaceDescribe>> MISSING_KEYSPACE = ks -> Uni.createFrom().nullItem();
    @Inject
    SchemaManager schemaManager;
    @Inject
    StargateRequestInfo requestInfo;

    @Override
    public CompletionStage<QueryOuterClass.Response> executeQueryAsync(QueryOuterClass.Query query) {
        return this.requestInfo.getStargateBridge().executeQuery(query).subscribeAsCompletionStage();
    }

    @Override
    public CompletionStage<QueryOuterClass.Response> executeQueryAsync(String keyspaceName, String tableName, Function<Optional<Schema.CqlTable>, QueryOuterClass.Query> queryProducer) {
        return this.getTableAsync(keyspaceName, tableName, true).thenCompose(table -> this.executeQueryAsync((QueryOuterClass.Query)queryProducer.apply((Optional<Schema.CqlTable>)table)));
    }

    @Override
    public CompletionStage<QueryOuterClass.Response> executeBatchAsync(QueryOuterClass.Batch batch) {
        return this.requestInfo.getStargateBridge().executeBatch(batch).subscribeAsCompletionStage();
    }

    @Override
    public CompletionStage<Optional<Schema.CqlKeyspaceDescribe>> getKeyspaceAsync(String keyspaceName, boolean checkIfAuthorized) {
        Uni<Schema.CqlKeyspaceDescribe> keyspace = checkIfAuthorized ? this.schemaManager.getKeyspaceAuthorized(keyspaceName) : this.schemaManager.getKeyspace(keyspaceName);
        return keyspace.map(Optional::ofNullable).subscribeAsCompletionStage();
    }

    @Override
    public CompletionStage<List<Schema.CqlKeyspaceDescribe>> getAllKeyspacesAsync() {
        return this.schemaManager.getKeyspaces().collect().asList().subscribeAsCompletionStage();
    }

    @Override
    public String decorateKeyspaceName(String keyspaceName) {
        return this.requestInfo.getTenantId().map(tenantId -> Hex.encodeHexString((byte[])tenantId.getBytes(StandardCharsets.UTF_8)) + "_" + keyspaceName).orElse(keyspaceName);
    }

    @Override
    public CompletionStage<Optional<Schema.CqlTable>> getTableAsync(String keyspaceName, String tableName, boolean checkIfAuthorized) {
        Uni<Schema.CqlTable> table = checkIfAuthorized ? this.schemaManager.getTableAuthorized(keyspaceName, tableName, MISSING_KEYSPACE) : this.schemaManager.getTable(keyspaceName, tableName, MISSING_KEYSPACE);
        return table.map(Optional::ofNullable).subscribeAsCompletionStage();
    }

    @Override
    public CompletionStage<List<Schema.CqlTable>> getTablesAsync(String keyspaceName) {
        return this.schemaManager.getTables(keyspaceName, MISSING_KEYSPACE).collect().asList().subscribeAsCompletionStage();
    }

    @Override
    public CompletionStage<List<Boolean>> authorizeSchemaReadsAsync(List<Schema.SchemaRead> schemaReads) {
        return this.requestInfo.getStargateBridge().authorizeSchemaReads(Schema.AuthorizeSchemaReadsRequest.newBuilder().addAllSchemaReads(schemaReads).build()).map(Schema.AuthorizeSchemaReadsResponse::getAuthorizedList).subscribeAsCompletionStage();
    }

    @Override
    public CompletionStage<Schema.SupportedFeaturesResponse> getSupportedFeaturesAsync() {
        return this.requestInfo.getStargateBridge().getSupportedFeatures(Schema.SupportedFeaturesRequest.getDefaultInstance()).subscribeAsCompletionStage();
    }
}

