/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.config;

import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.sgv2.api.common.config.SerialConsistencyValid;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class SerialConsistencyValidatorTest {
    @Test
    public void validSerialConsistency() {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set constraintViolations = validator.validate((Object)new TestRecord(QueryOuterClass.Consistency.SERIAL), new Class[0]);
        Assertions.assertThat((int)constraintViolations.size()).isEqualTo(0);
        constraintViolations = validator.validate((Object)new TestRecord(QueryOuterClass.Consistency.LOCAL_SERIAL), new Class[0]);
        Assertions.assertThat((int)constraintViolations.size()).isEqualTo(0);
    }

    @Test
    public void invalidSerialConsistency() {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set constraintViolations = validator.validate((Object)new TestRecord(QueryOuterClass.Consistency.LOCAL_ONE), new Class[0]);
        Assertions.assertThat((int)constraintViolations.size()).isEqualTo(1);
        Assertions.assertThat((Collection)constraintViolations).anyMatch(SerialConsistencyValidatorTest.forVariable("serialConsistency").and(SerialConsistencyValidatorTest.havingMessage("must be any of [SERIAL, LOCAL_SERIAL]")));
        constraintViolations = validator.validate((Object)new TestRecord(null), new Class[0]);
        Assertions.assertThat((int)constraintViolations.size()).isEqualTo(1);
        Assertions.assertThat((Collection)constraintViolations).anyMatch(SerialConsistencyValidatorTest.forVariable("serialConsistency").and(SerialConsistencyValidatorTest.havingMessage("must be any of [SERIAL, LOCAL_SERIAL]")));
    }

    public static Predicate<ConstraintViolation<TestRecord>> forVariable(String propertyPath) {
        return l -> propertyPath.equals(l.getPropertyPath().toString());
    }

    public static Predicate<ConstraintViolation<TestRecord>> havingMessage(String message) {
        return l -> message.equals(l.getMessage().toString());
    }

    private record TestRecord(@SerialConsistencyValid(anyOf={QueryOuterClass.Consistency.SERIAL, QueryOuterClass.Consistency.LOCAL_SERIAL}) QueryOuterClass.Consistency serialConsistency) {
    }
}

