/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.security.challenge.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.smallrye.mutiny.Uni;
import io.stargate.sgv2.api.common.exception.model.dto.ApiError;
import io.stargate.sgv2.api.common.security.challenge.ChallengeSender;
import io.vertx.ext.web.RoutingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiErrorChallengeSender
implements ChallengeSender {
    private static final Logger LOG = LoggerFactory.getLogger(ApiErrorChallengeSender.class);
    private final String headerName;
    private final ObjectMapper objectMapper;

    public ApiErrorChallengeSender(String headerName, ObjectMapper objectMapper) {
        this.headerName = headerName;
        this.objectMapper = objectMapper;
    }

    @Override
    public Uni<Boolean> apply(RoutingContext context, ChallengeData challengeData) {
        int status = challengeData.status;
        context.response().setStatusCode(status);
        String message = "Role unauthorized for operation: Missing token, expecting one in the %s header.".formatted(this.headerName);
        ApiError apiError = new ApiError(message, status);
        try {
            String response = this.objectMapper.writeValueAsString((Object)apiError);
            context.response().headers().set("Content-Type", "application/json");
            context.response().headers().set("Content-Length", String.valueOf(response.getBytes().length));
            return Uni.createFrom().completionStage(context.response().write(response).map((Object)true).toCompletionStage());
        }
        catch (JsonProcessingException e) {
            LOG.error("Unable to serialize API error instance {} to JSON.", (Object)apiError, (Object)e);
            return Uni.createFrom().item((Object)true);
        }
    }
}

