/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.schema;

import com.google.protobuf.BytesValue;
import com.google.protobuf.Int32Value;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.opentelemetry.extension.annotations.WithSpan;
import io.quarkus.cache.Cache;
import io.quarkus.cache.CacheInvalidate;
import io.quarkus.cache.CacheKey;
import io.quarkus.cache.CacheName;
import io.quarkus.cache.CacheResult;
import io.quarkus.cache.CaffeineCache;
import io.quarkus.cache.CompositeCacheKey;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.tuples.Tuple2;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.bridge.proto.Schema;
import io.stargate.bridge.proto.StargateBridge;
import io.stargate.sgv2.api.common.StargateRequestInfo;
import io.stargate.sgv2.api.common.grpc.UnauthorizedKeyspaceException;
import io.stargate.sgv2.api.common.grpc.UnauthorizedTableException;
import io.stargate.sgv2.api.common.grpc.proto.SchemaReads;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@ApplicationScoped
public class SchemaManager {
    @Inject
    @CacheName(value="keyspace-cache")
    Cache keyspaceCache;
    @Inject
    StargateRequestInfo requestInfo;

    @WithSpan
    public Uni<Schema.CqlKeyspaceDescribe> getKeyspace(String keyspace) {
        return this.getKeyspace(keyspace, true);
    }

    @WithSpan
    public Uni<Schema.CqlKeyspaceDescribe> getKeyspace(String keyspace, boolean validateHash) {
        StargateBridge bridge = this.requestInfo.getStargateBridge();
        return this.getKeyspaceInternal(bridge, keyspace, validateHash);
    }

    @WithSpan
    public Multi<Schema.CqlKeyspaceDescribe> getKeyspaces() {
        StargateBridge bridge = this.requestInfo.getStargateBridge();
        return this.getKeyspaceNames(bridge).onItem().transformToUniAndMerge(keyspace -> this.getKeyspaceInternal(bridge, (String)keyspace, true));
    }

    @WithSpan
    public Uni<Schema.CqlTable> getTable(String keyspace, String table, Function<String, Uni<? extends Schema.CqlKeyspaceDescribe>> missingKeyspace) {
        StargateBridge bridge = this.requestInfo.getStargateBridge();
        return this.getTableInternal(bridge, keyspace, table, missingKeyspace);
    }

    @WithSpan
    public Multi<Schema.CqlTable> getTables(String keyspace, Function<String, Uni<? extends Schema.CqlKeyspaceDescribe>> missingKeyspace) {
        StargateBridge bridge = this.requestInfo.getStargateBridge();
        return this.getKeyspaceInternal(bridge, keyspace, true).onItem().ifNull().switchTo(() -> (Uni)missingKeyspace.apply(keyspace)).onItem().ifNotNull().transformToMulti(k -> Multi.createFrom().iterable((Iterable)k.getTablesList()));
    }

    @WithSpan
    public Uni<Schema.CqlKeyspaceDescribe> getKeyspaceAuthorized(String keyspace) {
        return this.getKeyspaceAuthorized(keyspace, true);
    }

    @WithSpan
    public Uni<Schema.CqlKeyspaceDescribe> getKeyspaceAuthorized(String keyspace, boolean validateHash) {
        StargateBridge bridge = this.requestInfo.getStargateBridge();
        return this.authorizeKeyspaceInternal(bridge, keyspace).onItem().transformToUni(authorized -> {
            if (authorized.booleanValue()) {
                return this.getKeyspaceInternal(bridge, keyspace, validateHash);
            }
            UnauthorizedKeyspaceException unauthorized = new UnauthorizedKeyspaceException(keyspace);
            return Uni.createFrom().failure((Throwable)unauthorized);
        });
    }

    @WithSpan
    public Multi<Schema.CqlKeyspaceDescribe> getKeyspacesAuthorized() {
        StargateBridge bridge = this.requestInfo.getStargateBridge();
        return this.getKeyspaceNames(bridge).collect().asList().onItem().transformToMulti(keyspaceNames -> {
            if (null == keyspaceNames || keyspaceNames.isEmpty()) {
                return Multi.createFrom().empty();
            }
            List reads = keyspaceNames.stream().map(n -> SchemaReads.keyspace(n)).collect(Collectors.toList());
            Schema.AuthorizeSchemaReadsRequest request = Schema.AuthorizeSchemaReadsRequest.newBuilder().addAllSchemaReads(reads).build();
            return bridge.authorizeSchemaReads(request).onItem().ifNotNull().transformToMulti(response -> {
                ArrayList<String> authorizedKeyspaces = new ArrayList<String>(keyspaceNames.size());
                List authorizedList = response.getAuthorizedList();
                for (int i = 0; i < authorizedList.size(); ++i) {
                    if (!((Boolean)authorizedList.get(i)).booleanValue()) continue;
                    authorizedKeyspaces.add((String)keyspaceNames.get(i));
                }
                return Multi.createFrom().iterable(authorizedKeyspaces);
            });
        }).onItem().transformToUniAndMerge(keyspace -> this.getKeyspaceInternal(bridge, (String)keyspace, true));
    }

    @WithSpan
    public Uni<Schema.CqlTable> getTableAuthorized(String keyspace, String table, Function<String, Uni<? extends Schema.CqlKeyspaceDescribe>> missingKeyspace) {
        StargateBridge bridge = this.requestInfo.getStargateBridge();
        return this.authorizeTableInternal(bridge, keyspace, table).onItem().transformToUni(authorized -> {
            if (authorized.booleanValue()) {
                return this.getTableInternal(bridge, keyspace, table, missingKeyspace);
            }
            UnauthorizedTableException unauthorized = new UnauthorizedTableException(keyspace, table);
            return Uni.createFrom().failure((Throwable)unauthorized);
        });
    }

    @WithSpan
    public Multi<Schema.CqlTable> getTablesAuthorized(String keyspace, Function<String, Uni<? extends Schema.CqlKeyspaceDescribe>> missingKeyspace) {
        StargateBridge bridge = this.requestInfo.getStargateBridge();
        return this.getKeyspaceInternal(bridge, keyspace, true).onItem().ifNull().switchTo(() -> (Uni)missingKeyspace.apply(keyspace)).onItem().ifNotNull().transformToMulti(keyspaceDescribe -> {
            List tables = keyspaceDescribe.getTablesList();
            if (tables.isEmpty()) {
                return Multi.createFrom().empty();
            }
            List reads = tables.stream().map(t -> SchemaReads.table(keyspace, t.getName())).collect(Collectors.toList());
            Schema.AuthorizeSchemaReadsRequest request = Schema.AuthorizeSchemaReadsRequest.newBuilder().addAllSchemaReads(reads).build();
            return bridge.authorizeSchemaReads(request).onItem().ifNotNull().transformToMulti(response -> {
                ArrayList<Schema.CqlTable> authorizedTables = new ArrayList<Schema.CqlTable>(tables.size());
                List authorizedList = response.getAuthorizedList();
                for (int i = 0; i < authorizedList.size(); ++i) {
                    if (!((Boolean)authorizedList.get(i)).booleanValue()) continue;
                    authorizedTables.add((Schema.CqlTable)tables.get(i));
                }
                return Multi.createFrom().iterable(authorizedTables);
            });
        });
    }

    public Uni<QueryOuterClass.Response> queryWithSchema(String keyspace, String table, Function<String, Uni<? extends QueryOuterClass.Response>> missingKeyspace, Function<Schema.CqlTable, Uni<QueryOuterClass.Query>> queryFunction) {
        Uni<Schema.CqlKeyspaceDescribe> keyspaceUni = this.getKeyspace(keyspace, false);
        Optional<String> tenantId = this.requestInfo.getTenantId();
        return this.queryWithSchema(keyspaceUni, keyspace, table, tenantId, () -> (Uni)missingKeyspace.apply(keyspace), queryFunction, true);
    }

    public Uni<QueryOuterClass.Response> queryWithSchemaAuthorized(String keyspace, String table, Function<String, Uni<? extends QueryOuterClass.Response>> missingKeyspace, Function<Schema.CqlTable, Uni<QueryOuterClass.Query>> queryFunction) {
        Uni<Schema.CqlKeyspaceDescribe> keyspaceUni = this.getKeyspaceAuthorized(keyspace, false);
        Optional<String> tenantId = this.requestInfo.getTenantId();
        return this.queryWithSchema(keyspaceUni, keyspace, table, tenantId, () -> (Uni)missingKeyspace.apply(keyspace), queryFunction, true);
    }

    private Uni<QueryOuterClass.Response> queryWithSchema(Uni<Schema.CqlKeyspaceDescribe> keyspaceUni, String keyspace, String table, Optional<String> tenantId, Supplier<Uni<? extends QueryOuterClass.Response>> missingKeyspace, Function<Schema.CqlTable, Uni<QueryOuterClass.Query>> queryFunction, boolean revalidateOnTableMiss) {
        return keyspaceUni.onItem().ifNotNull().transformToUni(cqlKeyspace -> {
            Schema.CqlTable cqlTable = this.findTable((Schema.CqlKeyspaceDescribe)cqlKeyspace, table);
            if (null != cqlTable || !revalidateOnTableMiss) {
                return this.queryWithSchemaOnKeyspaceTable((Schema.CqlKeyspaceDescribe)cqlKeyspace, cqlTable, queryFunction).onItem().transformToUni(this.queryWithSchemaHandler(keyspace, table, tenantId, missingKeyspace, queryFunction));
            }
            Uni<Schema.CqlKeyspaceDescribe> validatedKeyspace = this.getKeyspace(keyspace);
            return this.queryWithSchema(validatedKeyspace, keyspace, table, tenantId, missingKeyspace, queryFunction, false);
        }).onItem().ifNull().switchTo(missingKeyspace);
    }

    private Function<Schema.QueryWithSchemaResponse, Uni<? extends QueryOuterClass.Response>> queryWithSchemaHandler(String keyspace, String table, Optional<String> tenantId, Supplier<Uni<? extends QueryOuterClass.Response>> missingKeyspace, Function<Schema.CqlTable, Uni<QueryOuterClass.Query>> queryFunction) {
        return response -> {
            if (response.hasNoKeyspace()) {
                return (Uni)missingKeyspace.get();
            }
            if (response.hasNewKeyspace()) {
                return this.invalidateKeyspace(keyspace, tenantId).flatMap(v -> this.cacheKeyspace(keyspace, tenantId, response.getNewKeyspace())).flatMap(updatedKeyspace -> {
                    Schema.CqlTable cqlTable = this.findTable((Schema.CqlKeyspaceDescribe)updatedKeyspace, table);
                    return this.queryWithSchemaOnKeyspaceTable((Schema.CqlKeyspaceDescribe)updatedKeyspace, cqlTable, queryFunction);
                }).onItem().transformToUni(this.queryWithSchemaHandler(keyspace, table, tenantId, missingKeyspace, queryFunction));
            }
            return Uni.createFrom().item((Object)response.getResponse());
        };
    }

    private Uni<Schema.QueryWithSchemaResponse> queryWithSchemaOnKeyspaceTable(Schema.CqlKeyspaceDescribe cqlKeyspace, Schema.CqlTable cqlTable, Function<Schema.CqlTable, Uni<QueryOuterClass.Query>> queryFunction) {
        return Uni.createFrom().item((Object)cqlTable).flatMap(queryFunction::apply).flatMap(query -> {
            Schema.QueryWithSchema request = Schema.QueryWithSchema.newBuilder().setQuery(query).setKeyspaceName(cqlKeyspace.getCqlKeyspace().getName()).setKeyspaceHash(cqlKeyspace.getHash().getValue()).build();
            return this.requestInfo.getStargateBridge().executeQueryWithSchema(request);
        });
    }

    private Uni<Boolean> authorizeKeyspaceInternal(StargateBridge bridge, String keyspaceName) {
        Schema.SchemaRead schemaRead = SchemaReads.keyspace(keyspaceName);
        return this.authorizeInternal(bridge, schemaRead);
    }

    private Uni<Boolean> authorizeTableInternal(StargateBridge bridge, String keyspaceName, String tableName) {
        Schema.SchemaRead schemaRead = SchemaReads.table(keyspaceName, tableName);
        return this.authorizeInternal(bridge, schemaRead);
    }

    private Uni<Boolean> authorizeInternal(StargateBridge bridge, Schema.SchemaRead schemaRead) {
        Schema.AuthorizeSchemaReadsRequest request = Schema.AuthorizeSchemaReadsRequest.newBuilder().addSchemaReads(schemaRead).build();
        return bridge.authorizeSchemaReads(request).map(response -> (Boolean)response.getAuthorizedList().iterator().next());
    }

    private Uni<Schema.CqlKeyspaceDescribe> getKeyspaceInternal(StargateBridge bridge, String keyspaceName, boolean validateHash) {
        Optional<String> tenantId = this.requestInfo.getTenantId();
        return Uni.createFrom().deferred(() -> {
            CompositeCacheKey cacheKey = new CompositeCacheKey(new Object[]{keyspaceName, tenantId});
            CompletableFuture keyspaceFuture = ((CaffeineCache)this.keyspaceCache.as(CaffeineCache.class)).getIfPresent((Object)cacheKey);
            if (null != keyspaceFuture) {
                return Uni.createFrom().future((Future)keyspaceFuture).onFailure().recoverWithUni(() -> this.invalidateKeyspace(keyspaceName, tenantId)).onItem().transform(k -> {
                    if (k instanceof Schema.CqlKeyspaceDescribe) {
                        Schema.CqlKeyspaceDescribe cqlKeyspace = (Schema.CqlKeyspaceDescribe)k;
                        return Tuple2.of((Object)cqlKeyspace, (Object)true);
                    }
                    return null;
                });
            }
            return Uni.createFrom().nullItem();
        }).onItem().ifNull().switchTo(() -> this.fetchKeyspace(keyspaceName, tenantId, bridge).map(k -> Tuple2.of((Object)k, (Object)false))).flatMap(tuple -> {
            Schema.CqlKeyspaceDescribe keyspace = (Schema.CqlKeyspaceDescribe)tuple.getItem1();
            Boolean cached = (Boolean)tuple.getItem2();
            if (!cached.booleanValue() || !validateHash) {
                return Uni.createFrom().item((Object)keyspace);
            }
            Schema.DescribeKeyspaceQuery request = Schema.DescribeKeyspaceQuery.newBuilder().setKeyspaceName(keyspaceName).setHash(keyspace.getHash()).build();
            return bridge.describeKeyspace(request).onItem().transformToUni(updatedKeyspace -> {
                if (null != updatedKeyspace && updatedKeyspace.hasCqlKeyspace()) {
                    return this.invalidateKeyspace(keyspaceName, tenantId).flatMap(v -> this.cacheKeyspace(keyspaceName, tenantId, (Schema.CqlKeyspaceDescribe)updatedKeyspace));
                }
                return Uni.createFrom().item((Object)keyspace);
            });
        }).onFailure().recoverWithUni(t -> {
            StatusRuntimeException sre;
            if (t instanceof StatusRuntimeException && Objects.equals((sre = (StatusRuntimeException)t).getStatus().getCode(), Status.Code.NOT_FOUND)) {
                return this.invalidateKeyspace(keyspaceName, tenantId).flatMap(v -> Uni.createFrom().nullItem());
            }
            return Uni.createFrom().failure(t);
        });
    }

    private Uni<Schema.CqlTable> getTableInternal(StargateBridge bridge, String keyspaceName, String tableName, Function<String, Uni<? extends Schema.CqlKeyspaceDescribe>> missingKeyspace) {
        return this.getKeyspaceInternal(bridge, keyspaceName, true).onItem().ifNull().switchTo(() -> (Uni)missingKeyspace.apply(keyspaceName)).onItem().ifNotNull().transform(cqlKeyspace -> this.findTable((Schema.CqlKeyspaceDescribe)cqlKeyspace, tableName));
    }

    private Schema.CqlTable findTable(Schema.CqlKeyspaceDescribe keyspace, String tableName) {
        List tables = keyspace.getTablesList();
        Optional<Schema.CqlTable> table = tables.stream().filter(t -> Objects.equals(t.getName(), tableName)).findFirst();
        return table.orElse(null);
    }

    private Multi<String> getKeyspaceNames(StargateBridge bridge) {
        return Multi.createBy().repeating().uni(() -> new AtomicReference<Paging>(new Paging(true, null)), state -> {
            Paging paging = (Paging)state.get();
            if (!paging.hasMore()) {
                return Uni.createFrom().item(Collections.emptyList());
            }
            QueryOuterClass.Query.Builder queryBuilder = QueryOuterClass.Query.newBuilder().setCql("SELECT keyspace_name FROM system_schema.keyspaces");
            QueryOuterClass.QueryParameters.Builder params = QueryOuterClass.QueryParameters.newBuilder().setPageSize(Int32Value.of((int)100));
            if (null != paging.pageState()) {
                params.setPagingState(paging.pageState());
            }
            queryBuilder.setParameters(params);
            return bridge.executeQuery(queryBuilder.build()).flatMap(response -> {
                QueryOuterClass.ResultSet resultSet = response.getResultSet();
                state.set(new Paging(resultSet.hasPagingState(), resultSet.getPagingState()));
                List keyspaceNames = resultSet.getRowsList().stream().map(r -> r.getValues(0).getString()).collect(Collectors.toList());
                return Uni.createFrom().item(keyspaceNames);
            });
        }).until(List::isEmpty).onItem().transformToMultiAndMerge(l -> Multi.createFrom().iterable((Iterable)l));
    }

    @CacheResult(cacheName="keyspace-cache")
    protected Uni<Schema.CqlKeyspaceDescribe> fetchKeyspace(@CacheKey String keyspaceName, @CacheKey Optional<String> tenantId, StargateBridge bridge) {
        Schema.DescribeKeyspaceQuery request = Schema.DescribeKeyspaceQuery.newBuilder().setKeyspaceName(keyspaceName).build();
        return bridge.describeKeyspace(request).memoize().indefinitely();
    }

    @CacheResult(cacheName="keyspace-cache")
    protected Uni<Schema.CqlKeyspaceDescribe> cacheKeyspace(@CacheKey String keyspaceName, @CacheKey Optional<String> tenantId, Schema.CqlKeyspaceDescribe keyspace) {
        return Uni.createFrom().item((Object)keyspace);
    }

    @CacheInvalidate(cacheName="keyspace-cache")
    protected Uni<Void> invalidateKeyspace(@CacheKey String keyspaceName, @CacheKey Optional<String> tenantId) {
        return Uni.createFrom().nullItem();
    }

    private record Paging(boolean hasMore, BytesValue pageState) {
    }
}

