/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.token.impl;

import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.mockito.InjectMock;
import io.stargate.sgv2.api.common.token.CassandraTokenResolver;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.SecurityContext;
import java.util.Optional;
import org.apache.commons.lang3.RandomStringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@QuarkusTest
class PrincipalTokenResolverTest {
    @Inject
    Instance<CassandraTokenResolver> tokenResolver;
    @InjectMock(returnsDeepMocks=true)
    SecurityContext securityContext;

    PrincipalTokenResolverTest() {
    }

    @Nested
    class Resolve {
        Resolve() {
        }

        @Test
        public void happyPath() {
            String token = RandomStringUtils.randomAlphanumeric((int)16);
            Mockito.when((Object)PrincipalTokenResolverTest.this.securityContext.getUserPrincipal().getName()).thenReturn((Object)token);
            Optional result = ((CassandraTokenResolver)PrincipalTokenResolverTest.this.tokenResolver.get()).resolve(null, PrincipalTokenResolverTest.this.securityContext);
            Assertions.assertThat((Optional)result).contains((Object)token);
        }

        @Test
        public void noPrincipal() {
            Mockito.when((Object)PrincipalTokenResolverTest.this.securityContext.getUserPrincipal()).thenReturn(null);
            Optional result = ((CassandraTokenResolver)PrincipalTokenResolverTest.this.tokenResolver.get()).resolve(null, PrincipalTokenResolverTest.this.securityContext);
            Assertions.assertThat((Optional)result).isEmpty();
        }
    }
}

