/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.grpc;

import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.mockito.InjectMock;
import io.smallrye.mutiny.Uni;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.bridge.proto.Schema;
import io.stargate.bridge.proto.StargateBridge;
import io.stargate.sgv2.api.common.StargateRequestInfo;
import io.stargate.sgv2.api.common.grpc.StargateBridgeClient;
import io.stargate.sgv2.api.common.schema.SchemaManager;
import jakarta.inject.Inject;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@QuarkusTest
public class StargateBridgeClientTest {
    @InjectMock
    SchemaManager schemaManager;
    StargateBridge reactiveBridge;
    @InjectMock
    StargateRequestInfo requestInfo;
    @Inject
    StargateBridgeClient client;

    @BeforeEach
    public void setup() {
        this.reactiveBridge = (StargateBridge)Mockito.mock(StargateBridge.class);
        Mockito.when((Object)this.requestInfo.getStargateBridge()).thenReturn((Object)this.reactiveBridge);
    }

    @Test
    public void shouldForwardCqlQuery() {
        QueryOuterClass.Query query = QueryOuterClass.Query.getDefaultInstance();
        QueryOuterClass.Response expectedResponse = QueryOuterClass.Response.getDefaultInstance();
        Mockito.when((Object)this.reactiveBridge.executeQuery(query)).thenReturn((Object)Uni.createFrom().item((Object)expectedResponse));
        QueryOuterClass.Response actualResponse = this.client.executeQuery(query);
        Assertions.assertThat((Object)actualResponse).isSameAs((Object)expectedResponse);
    }

    @Test
    public void shouldForwardSchemaLookup() {
        String keyspaceName = "ks";
        Schema.CqlKeyspaceDescribe expectedKeyspace = Schema.CqlKeyspaceDescribe.getDefaultInstance();
        Mockito.when((Object)this.schemaManager.getKeyspace(keyspaceName)).thenReturn((Object)Uni.createFrom().item((Object)expectedKeyspace));
        Optional actualKeyspace = this.client.getKeyspace(keyspaceName, false);
        Assertions.assertThat((Optional)actualKeyspace).hasValueSatisfying(ks -> Assertions.assertThat((Object)ks).isSameAs((Object)expectedKeyspace));
    }
}

