/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.cql.builder;

import io.stargate.bridge.grpc.Values;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.sgv2.api.common.cql.builder.Column;
import io.stargate.sgv2.api.common.cql.builder.Predicate;
import io.stargate.sgv2.api.common.cql.builder.QueryBuilder;
import io.stargate.sgv2.api.common.cql.builder.Replication;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class QueryBuilderTest {
    @ParameterizedTest
    @MethodSource(value={"sampleQueries"})
    @DisplayName(value="Should generate expected CQL string")
    public void generateCql(String actualCql, String expectedCql) {
        Assertions.assertThat((String)actualCql).isEqualTo(expectedCql);
    }

    public static Arguments[] sampleQueries() {
        return new Arguments[]{Arguments.arguments((Object[])new Object[]{new QueryBuilder().create().keyspace("ks").withReplication(Replication.simpleStrategy((int)1)).build().getCql(), "CREATE KEYSPACE ks WITH replication = { 'class': 'SimpleStrategy', 'replication_factor': 1 }"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().create().keyspace("Ks").withReplication(Replication.simpleStrategy((int)1)).build().getCql(), "CREATE KEYSPACE \"Ks\" WITH replication = { 'class': 'SimpleStrategy', 'replication_factor': 1 }"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().create().keyspace("ks").ifNotExists().withReplication(Replication.simpleStrategy((int)1)).build().getCql(), "CREATE KEYSPACE IF NOT EXISTS ks WITH replication = { 'class': 'SimpleStrategy', 'replication_factor': 1 }"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().create().keyspace("ks").ifNotExists().withReplication(Replication.networkTopologyStrategy((Map)new LinkedHashMap<String, Integer>(){
            {
                this.put("dc1", 3);
                this.put("dc2", 4);
            }
        })).build().getCql(), "CREATE KEYSPACE IF NOT EXISTS ks WITH replication = { 'class': 'NetworkTopologyStrategy', 'dc1': 3, 'dc2': 4 }"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().alter().keyspace("ks").withReplication(Replication.simpleStrategy((int)1)).build().getCql(), "ALTER KEYSPACE ks WITH replication = { 'class': 'SimpleStrategy', 'replication_factor': 1 }"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().alter().keyspace("ks").withReplication(Replication.simpleStrategy((int)1)).andDurableWrites(false).build().getCql(), "ALTER KEYSPACE ks WITH replication = { 'class': 'SimpleStrategy', 'replication_factor': 1 } AND durable_writes = false"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().drop().keyspace("ks").build().getCql(), "DROP KEYSPACE ks"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().drop().keyspace("ks").ifExists().build().getCql(), "DROP KEYSPACE IF EXISTS ks"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().create().table("ks", "tbl").column("k", "int", Column.Kind.PARTITION_KEY).build().getCql(), "CREATE TABLE ks.tbl (k int, PRIMARY KEY ((k)))"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().create().table("Ks", "Tbl").column("k", "int", Column.Kind.PARTITION_KEY).build().getCql(), "CREATE TABLE \"Ks\".\"Tbl\" (k int, PRIMARY KEY ((k)))"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().create().table("tbl").column("k", "int", Column.Kind.PARTITION_KEY).build().getCql(), "CREATE TABLE tbl (k int, PRIMARY KEY ((k)))"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().create().table("ks", "tbl").ifNotExists().column("k", "int", Column.Kind.PARTITION_KEY).build().getCql(), "CREATE TABLE IF NOT EXISTS ks.tbl (k int, PRIMARY KEY ((k)))"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().create().table("ks", "tbl").ifNotExists().column("k", "int", Column.Kind.PARTITION_KEY).column("cc", "text", Column.Kind.CLUSTERING, Column.Order.DESC).column("v", "int").column("s", "int", Column.Kind.STATIC).build().getCql(), "CREATE TABLE IF NOT EXISTS ks.tbl (k int, cc text, v int, s int STATIC, PRIMARY KEY ((k), cc)) WITH CLUSTERING ORDER BY (cc DESC)"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().create().table("ks", "tbl").column("k", "int", Column.Kind.PARTITION_KEY).withComment("'test' comment").withDefaultTTL(3600).build().getCql(), "CREATE TABLE ks.tbl (k int, PRIMARY KEY ((k))) WITH comment = '''test'' comment' AND default_time_to_live = 3600"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().alter().table("ks", "tbl").addColumn("c", "int").addColumn("d", "int").build().getCql(), "ALTER TABLE ks.tbl ADD (c int, d int)"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().alter().table("ks", "tbl").dropColumn("c").dropColumn("d").build().getCql(), "ALTER TABLE ks.tbl DROP (c, d)"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().alter().table("ks", "tbl").renameColumn("c", "c2").renameColumn("d", "d2").build().getCql(), "ALTER TABLE ks.tbl RENAME c TO c2 AND d TO d2"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().drop().table("ks", "tbl").build().getCql(), "DROP TABLE ks.tbl"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().drop().table("ks", "tbl").ifExists().build().getCql(), "DROP TABLE IF EXISTS ks.tbl"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().truncate().table("ks", "tbl").build().getCql(), "TRUNCATE ks.tbl"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().create().index().on("ks", "tbl").column("c").build().getCql(), "CREATE INDEX ON ks.tbl (c)"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().create().index("idx").on("ks", "tbl").column("c").build().getCql(), "CREATE INDEX idx ON ks.tbl (c)"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().create().index("idx").ifNotExists().on("ks", "tbl").column("c").build().getCql(), "CREATE INDEX IF NOT EXISTS idx ON ks.tbl (c)"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().create().index().on("ks", "tbl").column("c").indexEntries().build().getCql(), "CREATE INDEX ON ks.tbl (ENTRIES(c))"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().create().index().on("ks", "tbl").column("c").indexFull().build().getCql(), "CREATE INDEX ON ks.tbl (FULL(c))"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().create().index().on("ks", "tbl").column("c").indexKeys().build().getCql(), "CREATE INDEX ON ks.tbl (KEYS(c))"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().create().index().on("ks", "tbl").column("c").indexValues().build().getCql(), "CREATE INDEX ON ks.tbl (VALUES(c))"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().create().index().on("ks", "tbl").column("c").custom("IndexClass").build().getCql(), "CREATE CUSTOM INDEX ON ks.tbl (c) USING 'IndexClass'"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().drop().index("idx").ifExists().build().getCql(), "DROP INDEX IF EXISTS idx"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().drop().index("ks", "idx").build().getCql(), "DROP INDEX ks.idx"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().create().materializedView("ks", "v").asSelect().column("a", Column.Kind.PARTITION_KEY).column("b").column("c").from("ks", "tbl").build().getCql(), "CREATE MATERIALIZED VIEW ks.v AS SELECT a, b, c FROM ks.tbl WHERE a IS NOT NULL AND b IS NOT NULL AND c IS NOT NULL PRIMARY KEY ((a))"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().drop().materializedView("ks", "tbl").build().getCql(), "DROP MATERIALIZED VIEW ks.tbl"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().drop().materializedView("ks", "tbl").ifExists().build().getCql(), "DROP MATERIALIZED VIEW IF EXISTS ks.tbl"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().create().type("ks", "t").column("a", "int").column("b", "int").build().getCql(), "CREATE TYPE ks.t (a int, b int)"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().alter().type("ks", "t").renameColumn("a", "a2").renameColumn("b", "b2").build().getCql(), "ALTER TYPE ks.t RENAME a TO a2 AND b TO b2"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().drop().type("ks", "t").build().getCql(), "DROP TYPE ks.t"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().drop().type("ks", "t").ifExists().build().getCql(), "DROP TYPE IF EXISTS ks.t"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().alter().type("ks", "t").addColumn("c", "int").addColumn("d", "int").build().getCql(), "ALTER TYPE ks.t ADD c int, d int"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().select().from("ks", "tbl").build().getCql(), "SELECT * FROM ks.tbl"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().select().column(new String[]{"a", "b", "c"}).from("ks", "tbl").build().getCql(), "SELECT a, b, c FROM ks.tbl"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().select().count("a").from("ks", "tbl").build().getCql(), "SELECT COUNT(a) FROM ks.tbl"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().select().count().from("ks", "tbl").build().getCql(), "SELECT COUNT(1) FROM ks.tbl"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().select().count("a").from("ks", "tbl").limit(Integer.valueOf(1)).build().getCql(), "SELECT COUNT(a) FROM ks.tbl LIMIT 1"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().select().count("a").from("ks", "tbl").limit(Values.of((long)1L)).build().getCql(), "SELECT COUNT(a) FROM ks.tbl LIMIT ?"}), Arguments.arguments((Object[])new Object[]{new QueryBuilder().select().count("a").from("ks", "tbl").limit().build().getCql(), "SELECT COUNT(a) FROM ks.tbl LIMIT ?"})};
    }

    @Test
    public void generateBatchQuery() {
        QueryOuterClass.BatchQuery batchQuery = new QueryBuilder().select().from("ks", "tbl").where("id", Predicate.EQ, (Object)Values.of((long)1L)).buildForBatch();
        Assertions.assertThat((String)batchQuery.getCql()).isEqualTo("SELECT * FROM ks.tbl WHERE id = ?");
        Assertions.assertThat((List)batchQuery.getValues().getValuesList()).containsOnly((Object[])new QueryOuterClass.Value[]{Values.of((long)1L)});
    }

    @Test
    public void failWhenBatchQueryHasParameters() {
        Assertions.assertThatThrownBy(() -> new QueryBuilder().select().from("ks", "tbl").parameters(QueryOuterClass.QueryParameters.newBuilder().build()).buildForBatch()).isInstanceOf(IllegalStateException.class);
    }
}

