package io.stargate.sgv2.api.common.cql.builder;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link BuiltCondition}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBuiltCondition.builder()}.
 */
@Generated(from = "BuiltCondition", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableBuiltCondition implements BuiltCondition {
  private final BuiltCondition.LHS lhs;
  private final Predicate predicate;
  private final Term value;

  private ImmutableBuiltCondition(
      BuiltCondition.LHS lhs,
      Predicate predicate,
      Term value) {
    this.lhs = lhs;
    this.predicate = predicate;
    this.value = value;
  }

  /**
   * @return The value of the {@code lhs} attribute
   */
  @Override
  public BuiltCondition.LHS lhs() {
    return lhs;
  }

  /**
   * @return The value of the {@code predicate} attribute
   */
  @Override
  public Predicate predicate() {
    return predicate;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public Term value() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BuiltCondition#lhs() lhs} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lhs
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBuiltCondition withLhs(BuiltCondition.LHS value) {
    if (this.lhs == value) return this;
    BuiltCondition.LHS newValue = Objects.requireNonNull(value, "lhs");
    return new ImmutableBuiltCondition(newValue, this.predicate, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BuiltCondition#predicate() predicate} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for predicate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBuiltCondition withPredicate(Predicate value) {
    Predicate newValue = Objects.requireNonNull(value, "predicate");
    if (this.predicate == newValue) return this;
    return new ImmutableBuiltCondition(this.lhs, newValue, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BuiltCondition#value() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBuiltCondition withValue(Term value) {
    if (this.value == value) return this;
    Term newValue = Objects.requireNonNull(value, "value");
    return new ImmutableBuiltCondition(this.lhs, this.predicate, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBuiltCondition} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBuiltCondition
        && equalTo(0, (ImmutableBuiltCondition) another);
  }

  private boolean equalTo(int synthetic, ImmutableBuiltCondition another) {
    return lhs.equals(another.lhs)
        && predicate.equals(another.predicate)
        && value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code lhs}, {@code predicate}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + lhs.hashCode();
    h += (h << 5) + predicate.hashCode();
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code BuiltCondition} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("BuiltCondition")
        .omitNullValues()
        .add("lhs", lhs)
        .add("predicate", predicate)
        .add("value", value)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link BuiltCondition} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable BuiltCondition instance
   */
  public static ImmutableBuiltCondition copyOf(BuiltCondition instance) {
    if (instance instanceof ImmutableBuiltCondition) {
      return (ImmutableBuiltCondition) instance;
    }
    return ImmutableBuiltCondition.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBuiltCondition ImmutableBuiltCondition}.
   * <pre>
   * ImmutableBuiltCondition.builder()
   *    .lhs(io.stargate.sgv2.api.common.cql.builder.BuiltCondition.LHS) // required {@link BuiltCondition#lhs() lhs}
   *    .predicate(io.stargate.sgv2.api.common.cql.builder.Predicate) // required {@link BuiltCondition#predicate() predicate}
   *    .value(io.stargate.sgv2.api.common.cql.builder.Term) // required {@link BuiltCondition#value() value}
   *    .build();
   * </pre>
   * @return A new ImmutableBuiltCondition builder
   */
  public static ImmutableBuiltCondition.Builder builder() {
    return new ImmutableBuiltCondition.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBuiltCondition ImmutableBuiltCondition}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "BuiltCondition", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_LHS = 0x1L;
    private static final long INIT_BIT_PREDICATE = 0x2L;
    private static final long INIT_BIT_VALUE = 0x4L;
    private long initBits = 0x7L;

    private @Nullable BuiltCondition.LHS lhs;
    private @Nullable Predicate predicate;
    private @Nullable Term value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BuiltCondition} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BuiltCondition instance) {
      Objects.requireNonNull(instance, "instance");
      lhs(instance.lhs());
      predicate(instance.predicate());
      value(instance.value());
      return this;
    }

    /**
     * Initializes the value for the {@link BuiltCondition#lhs() lhs} attribute.
     * @param lhs The value for lhs 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder lhs(BuiltCondition.LHS lhs) {
      this.lhs = Objects.requireNonNull(lhs, "lhs");
      initBits &= ~INIT_BIT_LHS;
      return this;
    }

    /**
     * Initializes the value for the {@link BuiltCondition#predicate() predicate} attribute.
     * @param predicate The value for predicate 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder predicate(Predicate predicate) {
      this.predicate = Objects.requireNonNull(predicate, "predicate");
      initBits &= ~INIT_BIT_PREDICATE;
      return this;
    }

    /**
     * Initializes the value for the {@link BuiltCondition#value() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(Term value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableBuiltCondition ImmutableBuiltCondition}.
     * @return An immutable instance of BuiltCondition
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBuiltCondition build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableBuiltCondition(lhs, predicate, value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_LHS) != 0) attributes.add("lhs");
      if ((initBits & INIT_BIT_PREDICATE) != 0) attributes.add("predicate");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build BuiltCondition, some of required attributes are not set " + attributes;
    }
  }
}
