/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.exception;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.quarkus.arc.lookup.LookupIfProperty;
import io.stargate.sgv2.api.common.exception.model.dto.ApiError;
import jakarta.ws.rs.core.Response;
import org.jboss.resteasy.reactive.RestResponse;
import org.jboss.resteasy.reactive.server.ServerExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LookupIfProperty(name="stargate.exception-mappers.enabled", stringValue="true", lookupIfMissing=true)
public class StatusRuntimeExceptionMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatusRuntimeExceptionMapper.class);

    @ServerExceptionMapper
    public RestResponse<ApiError> statusRuntimeException(StatusRuntimeException exception) {
        Status.Code sc = exception.getStatus().getCode();
        String msg = exception.getMessage();
        switch (sc) {
            case ALREADY_EXISTS: {
                return StatusRuntimeExceptionMapper.grpcResponseNoLog(sc, Response.Status.CONFLICT, "Resource already exists", msg);
            }
            case FAILED_PRECONDITION: {
                return StatusRuntimeExceptionMapper.grpcResponseNoLog(sc, Response.Status.BAD_REQUEST, "Invalid state or argument(s) for gRPC operation", msg);
            }
            case INVALID_ARGUMENT: {
                return StatusRuntimeExceptionMapper.grpcResponseNoLog(sc, Response.Status.BAD_REQUEST, "Invalid argument for gRPC operation", msg);
            }
            case NOT_FOUND: {
                return StatusRuntimeExceptionMapper.grpcResponseNoLog(sc, Response.Status.NOT_FOUND, "Unknown gRPC operation", msg);
            }
            case PERMISSION_DENIED: {
                return StatusRuntimeExceptionMapper.grpcResponseNoLog(sc, Response.Status.UNAUTHORIZED, "Unauthorized gRPC operation", msg);
            }
            case UNAUTHENTICATED: {
                return StatusRuntimeExceptionMapper.grpcResponseNoLog(sc, Response.Status.UNAUTHORIZED, "Unauthenticated gRPC operation", msg);
            }
            case UNAVAILABLE: {
                return StatusRuntimeExceptionMapper.grpcResponseAndLogAsError(sc, Response.Status.BAD_GATEWAY, "gRPC service unavailable", msg);
            }
            case UNIMPLEMENTED: {
                return StatusRuntimeExceptionMapper.grpcResponseAndLogAsError(sc, Response.Status.NOT_IMPLEMENTED, "Unimplemented gRPC operation", msg);
            }
            case DEADLINE_EXCEEDED: {
                return StatusRuntimeExceptionMapper.grpcResponseAndLogAsError(sc, Response.Status.GATEWAY_TIMEOUT, "gRPC service timeout", msg);
            }
        }
        return StatusRuntimeExceptionMapper.grpcResponseAndLogAsError(sc, Response.Status.INTERNAL_SERVER_ERROR, "Unhandled gRPC failure", msg);
    }

    private static RestResponse<ApiError> grpcResponseAndLogAsError(Status.Code grpcCode, Response.Status httpStatus, String prefix, String suffix) {
        String message = StatusRuntimeExceptionMapper.buildFailureMessage(grpcCode, httpStatus, prefix, suffix);
        LOGGER.error("Bridge gRPC call failed, problem: {}", (Object)message);
        return StatusRuntimeExceptionMapper.buildRestResponse(grpcCode, httpStatus, message);
    }

    private static RestResponse<ApiError> grpcResponseNoLog(Status.Code grpcCode, Response.Status httpStatus, String prefix, String suffix) {
        return StatusRuntimeExceptionMapper.buildRestResponse(grpcCode, httpStatus, StatusRuntimeExceptionMapper.buildFailureMessage(grpcCode, httpStatus, prefix, suffix));
    }

    private static String buildFailureMessage(Status.Code grpcCode, Response.Status httpStatus, String prefix, String suffix) {
        return String.format("%s (Status.Code.%s->%d): %s", prefix, grpcCode, httpStatus.getStatusCode(), suffix);
    }

    private static RestResponse<ApiError> buildRestResponse(Status.Code grpcCode, Response.Status httpStatus, String message) {
        return RestResponse.ResponseBuilder.create((Response.StatusType)httpStatus, (Object)new ApiError(message, httpStatus.getStatusCode(), grpcCode.toString())).build();
    }
}

