package io.stargate.sgv2.api.common.config;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RequestParams}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRequestParams.builder()}.
 */
@Generated(from = "RequestParams", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRequestParams implements RequestParams {
  private final boolean compactMapData;

  private ImmutableRequestParams(boolean compactMapData) {
    this.compactMapData = compactMapData;
  }

  /**
   * This is an option set by the client in an API call to get the map data during a read operation
   * or to specify the format of the map data during a write operation. if true
   * <pre>
   *     "map": {
   *        "key1": "value1",
   *        "key2": "value2"
   *      }
   * </pre>
   * else
   * <pre>
   *      "map": [
   *      {
   *        "key": "key1",
   *        "value": "value1"
   *      },
   *      {
   *        "key": "key2",
   *        "value": "value2"
   *      }
   *      ]
   * </pre>
   * @return boolean
   */
  @Override
  public boolean compactMapData() {
    return compactMapData;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RequestParams#compactMapData() compactMapData} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for compactMapData
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRequestParams withCompactMapData(boolean value) {
    if (this.compactMapData == value) return this;
    return new ImmutableRequestParams(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRequestParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRequestParams
        && equalTo(0, (ImmutableRequestParams) another);
  }

  private boolean equalTo(int synthetic, ImmutableRequestParams another) {
    return compactMapData == another.compactMapData;
  }

  /**
   * Computes a hash code from attributes: {@code compactMapData}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Booleans.hashCode(compactMapData);
    return h;
  }

  /**
   * Prints the immutable value {@code RequestParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RequestParams")
        .omitNullValues()
        .add("compactMapData", compactMapData)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link RequestParams} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RequestParams instance
   */
  public static ImmutableRequestParams copyOf(RequestParams instance) {
    if (instance instanceof ImmutableRequestParams) {
      return (ImmutableRequestParams) instance;
    }
    return ImmutableRequestParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRequestParams ImmutableRequestParams}.
   * <pre>
   * ImmutableRequestParams.builder()
   *    .compactMapData(boolean) // required {@link RequestParams#compactMapData() compactMapData}
   *    .build();
   * </pre>
   * @return A new ImmutableRequestParams builder
   */
  public static ImmutableRequestParams.Builder builder() {
    return new ImmutableRequestParams.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRequestParams ImmutableRequestParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RequestParams", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_COMPACT_MAP_DATA = 0x1L;
    private long initBits = 0x1L;

    private boolean compactMapData;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RequestParams} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(RequestParams instance) {
      Objects.requireNonNull(instance, "instance");
      compactMapData(instance.compactMapData());
      return this;
    }

    /**
     * Initializes the value for the {@link RequestParams#compactMapData() compactMapData} attribute.
     * @param compactMapData The value for compactMapData 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder compactMapData(boolean compactMapData) {
      this.compactMapData = compactMapData;
      initBits &= ~INIT_BIT_COMPACT_MAP_DATA;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRequestParams ImmutableRequestParams}.
     * @return An immutable instance of RequestParams
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRequestParams build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRequestParams(compactMapData);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_COMPACT_MAP_DATA) != 0) attributes.add("compactMapData");
      return "Cannot build RequestParams, some of required attributes are not set " + attributes;
    }
  }
}
