/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.properties.datastore.configuration;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import io.quarkus.grpc.GrpcClient;
import io.quarkus.test.junit.QuarkusTest;
import io.stargate.bridge.proto.Schema;
import io.stargate.bridge.proto.StargateBridgeGrpc;
import io.stargate.sgv2.api.common.config.DataStoreConfig;
import io.stargate.sgv2.api.common.properties.datastore.DataStoreProperties;
import io.stargate.sgv2.api.common.properties.datastore.configuration.DataStorePropertiesConfiguration;
import io.stargate.sgv2.common.bridge.BridgeTest;
import jakarta.inject.Inject;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@QuarkusTest
public class BridgeDataStorePropertiesRetryTest
extends BridgeTest {
    @GrpcClient(value="bridge")
    StargateBridgeGrpc.StargateBridgeBlockingStub bridge;
    @Inject
    DataStorePropertiesConfiguration dataStorePropertiesConfiguration;
    private final Schema.SupportedFeaturesResponse SUCCESS_RESPONSE = Schema.SupportedFeaturesResponse.newBuilder().setSecondaryIndexes(false).setSai(false).setLoggedBatches(true).build();

    @Test
    public void dataStoreWithNoRetriesOk() {
        AtomicInteger callCounter = new AtomicInteger(0);
        DataStoreProperties props = this.fetchDataStoreProperties(1, callCounter, this.SUCCESS_RESPONSE);
        this.verifyProperties(props, this.SUCCESS_RESPONSE);
        Assertions.assertThat((AtomicInteger)callCounter).hasValue(1);
    }

    @Test
    public void dataStoreWithOneRetryOk() {
        AtomicInteger callCounter = new AtomicInteger(0);
        DataStoreProperties props = this.fetchDataStoreProperties(2, callCounter, this.SUCCESS_RESPONSE);
        this.verifyProperties(props, this.SUCCESS_RESPONSE);
        Assertions.assertThat((AtomicInteger)callCounter).hasValue(2);
    }

    @Test
    public void dataStoreWithTwoRetriesOk() {
        AtomicInteger callCounter = new AtomicInteger(0);
        DataStoreProperties props = this.fetchDataStoreProperties(3, callCounter, this.SUCCESS_RESPONSE);
        this.verifyProperties(props, this.SUCCESS_RESPONSE);
        Assertions.assertThat((AtomicInteger)callCounter).hasValue(3);
    }

    @Test
    public void dataStoreWithTwoRetriesFail() {
        AtomicInteger callCounter = new AtomicInteger(0);
        Throwable e = Assertions.catchThrowable(() -> this.fetchDataStoreProperties(6, callCounter, this.SUCCESS_RESPONSE));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isNotNull()).isInstanceOf(StatusRuntimeException.class);
        Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"UNAVAILABLE"});
        Assertions.assertThat((AtomicInteger)callCounter).hasValue(5);
    }

    private void verifyProperties(DataStoreProperties props, Schema.SupportedFeaturesResponse expected) {
        Assertions.assertThat((boolean)props.secondaryIndexesEnabled()).isEqualTo(expected.getSecondaryIndexes());
        Assertions.assertThat((boolean)props.saiEnabled()).isEqualTo(expected.getSai());
        Assertions.assertThat((boolean)props.loggedBatchesEnabled()).isEqualTo(expected.getLoggedBatches());
    }

    private DataStoreProperties fetchDataStoreProperties(int callsToSucceed, AtomicInteger callCounter, Schema.SupportedFeaturesResponse response) {
        DataStoreConfig config = (DataStoreConfig)Mockito.mock(DataStoreConfig.class);
        Mockito.when((Object)config.ignoreBridge()).thenReturn((Object)false);
        ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocation -> {
            int callNr = callCounter.incrementAndGet();
            StreamObserver observer = (StreamObserver)invocation.getArgument(1);
            if (callNr == callsToSucceed) {
                observer.onNext((Object)response);
                observer.onCompleted();
            } else {
                observer.onError((Throwable)new StatusRuntimeException(Status.UNAVAILABLE));
            }
            return null;
        }).when((Object)this.bridgeService)).getSupportedFeatures((Schema.SupportedFeaturesRequest)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
        return this.dataStorePropertiesConfiguration.configuration(this.bridge, config);
    }
}

