/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.common.bridge;

import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import io.smallrye.mutiny.Uni;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.bridge.proto.Schema;
import io.stargate.bridge.proto.StargateBridge;
import io.stargate.sgv2.common.bridge.ValidatingPaginator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class ValidatingStargateBridge
implements StargateBridge {
    private final List<QueryExpectation> expectedQueries = new ArrayList<QueryExpectation>();

    public void reset() {
        this.expectedQueries.clear();
    }

    public void validate() {
        this.expectedQueries.forEach(QueryExpectation::validate);
    }

    public Uni<QueryOuterClass.Response> executeQuery(QueryOuterClass.Query query) {
        QueryExpectation expectation = this.findQueryExpectation(query.getCql(), query.getValues().getValuesList());
        return expectation.execute(query.getParameters());
    }

    public Uni<Schema.QueryWithSchemaResponse> executeQueryWithSchema(Schema.QueryWithSchema request) {
        return this.executeQuery(request.getQuery()).map(response -> Schema.QueryWithSchemaResponse.newBuilder().setResponse(response).build());
    }

    public Uni<QueryOuterClass.Response> executeBatch(QueryOuterClass.Batch batch) {
        return batch.getQueriesList().stream().map(query -> {
            QueryExpectation expectation = this.findQueryExpectation(query.getCql(), query.getValues().getValuesList());
            return expectation.execute(batch.getParameters(), batch.getType());
        }).reduce((first, second) -> second).orElseThrow(() -> new AssertionError((Object)"Batch should have at least one query"));
    }

    private QueryExpectation findQueryExpectation(String cql, List<QueryOuterClass.Value> values) {
        return this.expectedQueries.stream().filter(q -> q.matches(cql, values)).findFirst().orElseThrow(() -> new AssertionError((Object)String.format("Unexpected query, should have been mocked with withQuery(): %s, Values: %s", cql, values)));
    }

    public Uni<Schema.CqlKeyspaceDescribe> describeKeyspace(Schema.DescribeKeyspaceQuery request) {
        throw new UnsupportedOperationException("Not implemented by this mock");
    }

    public Uni<Schema.AuthorizeSchemaReadsResponse> authorizeSchemaReads(Schema.AuthorizeSchemaReadsRequest request) {
        throw new UnsupportedOperationException("Not implemented by this mock");
    }

    public Uni<Schema.SupportedFeaturesResponse> getSupportedFeatures(Schema.SupportedFeaturesRequest request) {
        throw new UnsupportedOperationException("Not implemented by this mock");
    }

    private QueryExpectation add(QueryExpectation expectation) {
        this.expectedQueries.add(expectation);
        return expectation;
    }

    public QueryExpectation withQuery(String cql, QueryOuterClass.Value ... values) {
        return this.add(new QueryExpectation(Pattern.quote(cql), Arrays.asList(values)));
    }

    public QueryExpectation withAnySelectFrom(String keyspace, String table) {
        String regex = "SELECT.*FROM.*\\\"%s\\\"\\.\\\"%s\\\".*\n".formatted(keyspace, table);
        return this.add(new QueryExpectation(regex, Collections.emptyList()));
    }

    public static class QueryExpectation
    extends QueryAssert {
        private final Pattern cqlPattern;
        private final List<QueryOuterClass.Value> values;
        private int pageSize = Integer.MAX_VALUE;
        private QueryOuterClass.Batch.Type batchType;
        private boolean enriched;
        private QueryOuterClass.ResumeMode resumeMode;
        private QueryOuterClass.Consistency consistency = QueryOuterClass.Consistency.LOCAL_QUORUM;
        private List<List<QueryOuterClass.Value>> rows;
        private Iterable<? extends QueryOuterClass.ColumnSpec> columnSpec;
        private Function<List<QueryOuterClass.Value>, ByteBuffer> comparableKey;

        private QueryExpectation(String cqlRegex, List<QueryOuterClass.Value> values) {
            this.cqlPattern = Pattern.compile(cqlRegex);
            this.values = values;
        }

        private QueryExpectation(String cqlRegex) {
            this(cqlRegex, Collections.emptyList());
        }

        public QueryExpectation withPageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public QueryExpectation inBatch(QueryOuterClass.Batch.Type batchType) {
            this.batchType = batchType;
            return this;
        }

        public QueryExpectation enriched() {
            this.enriched = true;
            return this;
        }

        public QueryExpectation withResumeMode(QueryOuterClass.ResumeMode resumeMode) {
            this.resumeMode = resumeMode;
            return this;
        }

        public QueryExpectation withConsistency(QueryOuterClass.Consistency consistency) {
            this.consistency = consistency;
            return this;
        }

        public QueryExpectation withColumnSpec(Iterable<? extends QueryOuterClass.ColumnSpec> columnSpec) {
            this.columnSpec = columnSpec;
            return this;
        }

        public QueryExpectation withComparableKey(Function<List<QueryOuterClass.Value>, ByteBuffer> comparableKey) {
            this.comparableKey = comparableKey;
            return this;
        }

        public QueryAssert returningNothing() {
            return this.returning(Collections.emptyList());
        }

        public QueryAssert returning(List<List<QueryOuterClass.Value>> rows) {
            this.rows = rows;
            return this;
        }

        private boolean matches(String expectedCql, List<QueryOuterClass.Value> expectedValues) {
            Matcher matcher = this.cqlPattern.matcher(expectedCql);
            boolean valuesEquals = expectedValues.equals(this.values);
            boolean cqlMatches = matcher.matches();
            return cqlMatches && valuesEquals;
        }

        private Uni<QueryOuterClass.Response> execute(QueryOuterClass.BatchParameters parameters, QueryOuterClass.Batch.Type actualBatchType) {
            QueryOuterClass.Consistency actualConsistency = Optional.ofNullable(parameters).filter(QueryOuterClass.BatchParameters::hasConsistency).map(p -> p.getConsistency().getValue()).orElse(null);
            return this.execute(actualBatchType, false, null, actualConsistency, null, null);
        }

        private Uni<QueryOuterClass.Response> execute(QueryOuterClass.QueryParameters parameters) {
            Boolean actualEnriched = Optional.ofNullable(parameters).map(QueryOuterClass.QueryParameters::getEnriched).orElse(false);
            QueryOuterClass.ResumeMode actualResumeMode = Optional.ofNullable(parameters).filter(QueryOuterClass.QueryParameters::hasResumeMode).map(p -> p.getResumeMode().getValue()).orElse(null);
            QueryOuterClass.Consistency actualConsistency = Optional.ofNullable(parameters).filter(QueryOuterClass.QueryParameters::hasConsistency).map(p -> p.getConsistency().getValue()).orElse(null);
            Integer actualPageSize = Optional.ofNullable(parameters).filter(QueryOuterClass.QueryParameters::hasPageSize).map(p -> p.getPageSize().getValue()).orElse(null);
            BytesValue actualPagingState = Optional.ofNullable(parameters).filter(QueryOuterClass.QueryParameters::hasPagingState).map(QueryOuterClass.QueryParameters::getPagingState).orElse(null);
            return this.execute(null, actualEnriched, actualResumeMode, actualConsistency, actualPageSize, actualPagingState);
        }

        private Uni<QueryOuterClass.Response> execute(QueryOuterClass.Batch.Type actualBatchType, Boolean actualEnriched, QueryOuterClass.ResumeMode actualResumeMode, QueryOuterClass.Consistency actualConsistency, Integer actualPageSize, BytesValue actualPagingState) {
            int pageSizeUsed;
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)actualBatchType).as("Batch type for query %s", new Object[]{this.cqlPattern})).isEqualTo((Object)this.batchType);
            ((AbstractBooleanAssert)Assertions.assertThat((Boolean)actualEnriched).as("Enriched flag for the query %s", new Object[]{this.cqlPattern})).isEqualTo(this.enriched);
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)actualResumeMode).as("Resume mode for the query %s", new Object[]{this.cqlPattern})).isEqualTo((Object)this.resumeMode);
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)actualConsistency).as("Consistency for the query %s not matching, actual %s, expected %s", new Object[]{this.cqlPattern, actualConsistency, this.consistency})).isEqualTo((Object)this.consistency);
            if (this.pageSize < Integer.MAX_VALUE) {
                pageSizeUsed = this.pageSize;
                ((AbstractIntegerAssert)Assertions.assertThat((Integer)actualPageSize).as("Page size of %d expected, but query parameters are null.", new Object[]{pageSizeUsed})).isNotNull();
                ((AbstractIntegerAssert)Assertions.assertThat((Integer)actualPageSize).as("Page size mismatch, expected %d but actual was %d", new Object[]{pageSizeUsed, actualPageSize})).isEqualTo(pageSizeUsed);
            } else {
                pageSizeUsed = Optional.ofNullable(actualPageSize).orElse(this.pageSize);
            }
            Optional<ByteBuffer> pagingState = Optional.ofNullable(actualPagingState).flatMap(p -> {
                ByteBuffer byteBuffer = actualPagingState.getValue().asReadOnlyByteBuffer();
                return Optional.of(byteBuffer);
            });
            ValidatingPaginator paginator = ValidatingPaginator.of(pageSizeUsed, pagingState);
            this.executed();
            QueryOuterClass.ResultSet.Builder resultSet = QueryOuterClass.ResultSet.newBuilder();
            List<List<QueryOuterClass.Value>> filterRows = paginator.filter(this.rows);
            ByteBuffer nextPagingState = paginator.pagingState();
            if (null != nextPagingState) {
                resultSet.setPagingState(BytesValue.newBuilder().setValue(ByteString.copyFrom((ByteBuffer)nextPagingState)).build());
            }
            for (int i = 0; i < filterRows.size(); ++i) {
                List<QueryOuterClass.Value> row = filterRows.get(i);
                QueryOuterClass.Row.Builder builder = QueryOuterClass.Row.newBuilder().addAllValues(row);
                ByteBuffer rowPageState = paginator.pagingStateForRow(i);
                if (null != rowPageState) {
                    builder.setPagingState(BytesValue.newBuilder().setValue(ByteString.copyFrom((ByteBuffer)rowPageState)).build());
                }
                if (null != this.comparableKey) {
                    ByteString value = ByteString.copyFrom((ByteBuffer)this.comparableKey.apply(row));
                    builder.setComparableBytes(BytesValue.newBuilder().setValue(value));
                }
                resultSet.addRows(builder);
            }
            if (null != this.columnSpec) {
                resultSet.addAllColumns(this.columnSpec);
            }
            return Uni.createFrom().item((Object)QueryOuterClass.Response.newBuilder().setResultSet(resultSet).build());
        }

        private void validate() {
            ((AbstractIntegerAssert)this.assertExecuteCount().withFailMessage("No queries were executed for this expected pattern: %s, values: %s", new Object[]{this.cqlPattern, this.values})).isGreaterThanOrEqualTo(1);
        }
    }

    public static abstract class QueryAssert {
        private final AtomicInteger executeCount = new AtomicInteger();

        public AbstractIntegerAssert<?> assertExecuteCount() {
            return Assertions.assertThat((int)this.executeCount.get());
        }

        void executed() {
            this.executeCount.incrementAndGet();
        }
    }
}

