/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.grpc;

import io.grpc.StatusRuntimeException;
import io.quarkus.grpc.GrpcClient;
import io.quarkus.grpc.GrpcService;
import io.smallrye.mutiny.Uni;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.bridge.proto.Schema;
import io.stargate.bridge.proto.StargateBridge;
import io.stargate.sgv2.api.common.config.GrpcConfig;
import io.stargate.sgv2.api.common.grpc.qualifier.Retriable;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@GrpcService
@Retriable
public class RetriableStargateBridge
implements StargateBridge {
    private final StargateBridge delegate;
    private final GrpcConfig.Retries retriesConfig;

    @Inject
    public RetriableStargateBridge(@GrpcClient(value="bridge") StargateBridge delegate, GrpcConfig grpcConfig) {
        this.delegate = delegate;
        this.retriesConfig = grpcConfig.retries();
    }

    @Override
    public Uni<QueryOuterClass.Response> executeQuery(QueryOuterClass.Query request) {
        return this.withRetries(this.delegate.executeQuery(request));
    }

    @Override
    public Uni<Schema.QueryWithSchemaResponse> executeQueryWithSchema(Schema.QueryWithSchema request) {
        return this.withRetries(this.delegate.executeQueryWithSchema(request));
    }

    @Override
    public Uni<QueryOuterClass.Response> executeBatch(QueryOuterClass.Batch request) {
        return this.withRetries(this.delegate.executeBatch(request));
    }

    @Override
    public Uni<Schema.CqlKeyspaceDescribe> describeKeyspace(Schema.DescribeKeyspaceQuery request) {
        return this.withRetries(this.delegate.describeKeyspace(request));
    }

    @Override
    public Uni<Schema.AuthorizeSchemaReadsResponse> authorizeSchemaReads(Schema.AuthorizeSchemaReadsRequest request) {
        return this.withRetries(this.delegate.authorizeSchemaReads(request));
    }

    @Override
    public Uni<Schema.SupportedFeaturesResponse> getSupportedFeatures(Schema.SupportedFeaturesRequest request) {
        return this.withRetries(this.delegate.getSupportedFeatures(request));
    }

    private <T> Uni<T> withRetries(Uni<T> source) {
        if (!this.retriesConfig.enabled()) {
            return source;
        }
        return source.onFailure(t -> {
            if (t instanceof StatusRuntimeException) {
                StatusRuntimeException sre = (StatusRuntimeException)t;
                return this.retriesConfig.statusCodes().contains(sre.getStatus().getCode());
            }
            return false;
        }).retry().atMost((long)this.retriesConfig.maxAttempts());
    }
}

