/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.common.testresource;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.test.common.DevServicesContext;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.shaded.com.google.common.collect.ImmutableMap;

public class StargateTestResource
implements QuarkusTestResourceLifecycleManager,
DevServicesContext.ContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(StargateTestResource.class);
    private Map<String, String> initArgs;
    private Optional<String> containerNetworkId;
    private Network network;
    private GenericContainer<?> cassandraContainer;
    private GenericContainer<?> stargateContainer;

    public void setIntegrationTestContext(DevServicesContext context) {
        this.containerNetworkId = context.containerNetworkId();
    }

    public void init(Map<String, String> initArgs) {
        this.initArgs = initArgs;
    }

    public Map<String, String> start() {
        ImmutableMap.Builder<String, String> propsBuilder;
        if (this.shouldSkip()) {
            return Collections.emptyMap();
        }
        boolean reuse = false;
        if (this.containerNetworkId.isPresent()) {
            String networkId = this.containerNetworkId.get();
            propsBuilder = this.startWithContainerNetwork(networkId, reuse);
        } else {
            propsBuilder = this.startWithoutContainerNetwork(reuse);
        }
        Integer authPort = this.stargateContainer.getMappedPort(8081);
        String token = this.getAuthToken(this.stargateContainer.getHost(), authPort);
        LOG.info("Using auth token %s for integration tests.".formatted(token));
        propsBuilder.put((Object)"stargate.int-test.auth-token", (Object)token);
        propsBuilder.put((Object)"stargate.int-test.cassandra.host", (Object)this.cassandraContainer.getHost());
        propsBuilder.put((Object)"stargate.int-test.cassandra.cql-port", (Object)this.cassandraContainer.getMappedPort(9042).toString());
        propsBuilder.put((Object)"stargate.int-test.cluster-version", (Object)StargateTestResource.getClusterVersion());
        ImmutableMap props = propsBuilder.build();
        LOG.info("Using props map for the integration tests: %s".formatted(props));
        return props;
    }

    private boolean shouldSkip() {
        return System.getProperty("quarkus.http.test-host") != null;
    }

    public ImmutableMap.Builder<String, String> startWithoutContainerNetwork(boolean reuse) {
        Network network = this.network();
        this.cassandraContainer = this.baseCassandraContainer(reuse);
        this.cassandraContainer.withNetwork(network);
        this.cassandraContainer.start();
        this.stargateContainer = this.baseCoordinatorContainer(reuse);
        this.stargateContainer.withNetwork(network).withEnv("SEED", "cassandra");
        this.stargateContainer.start();
        Integer bridgePort = this.stargateContainer.getMappedPort(8091);
        ImmutableMap.Builder propsBuilder = ImmutableMap.builder();
        propsBuilder.put((Object)"quarkus.grpc.clients.bridge.port", (Object)String.valueOf(bridgePort));
        return propsBuilder;
    }

    private ImmutableMap.Builder<String, String> startWithContainerNetwork(String networkId, boolean reuse) {
        this.cassandraContainer = this.baseCassandraContainer(reuse);
        this.cassandraContainer.withNetworkMode(networkId);
        this.cassandraContainer.start();
        String cassandraHost = this.cassandraContainer.getCurrentContainerInfo().getConfig().getHostName();
        this.stargateContainer = this.baseCoordinatorContainer(reuse);
        this.stargateContainer.withNetworkMode(networkId).withEnv("SEED", cassandraHost);
        this.stargateContainer.start();
        String stargateHost = this.stargateContainer.getCurrentContainerInfo().getConfig().getHostName();
        ImmutableMap.Builder propsBuilder = ImmutableMap.builder();
        propsBuilder.put((Object)"quarkus.grpc.clients.bridge.host", (Object)stargateHost);
        return propsBuilder;
    }

    public void stop() {
        if (null != this.cassandraContainer && !this.cassandraContainer.isShouldBeReused()) {
            this.cassandraContainer.stop();
        }
        if (null != this.stargateContainer && !this.stargateContainer.isShouldBeReused()) {
            this.stargateContainer.stop();
        }
    }

    private GenericContainer<?> baseCassandraContainer(boolean reuse) {
        String image = this.getCassandraImage();
        GenericContainer container = new GenericContainer(image).withEnv("HEAP_NEWSIZE", "512M").withEnv("MAX_HEAP_SIZE", "2048M").withEnv("CASSANDRA_CGROUP_MEMORY_LIMIT", "true").withEnv("JVM_EXTRA_OPTS", "-Dcassandra.skip_wait_for_gossip_to_settle=0 -Dcassandra.load_ring_state=false -Dcassandra.initial_token=1").withNetworkAliases(new String[]{"cassandra"}).withExposedPorts(new Integer[]{7000, 9042}).withLogConsumer((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger((String)"cassandra-docker")).withPrefix("CASSANDRA")).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Created default superuser role.*\\n", (int)1)).withStartupTimeout(this.getCassandraStartupTimeout()).withReuse(reuse);
        if (this.isDse()) {
            container.withEnv("CLUSTER_NAME", StargateTestResource.getClusterName()).withEnv("DS_LICENSE", "accept");
        } else {
            container.withEnv("CASSANDRA_CLUSTER_NAME", StargateTestResource.getClusterName());
        }
        return container;
    }

    private GenericContainer<?> baseCoordinatorContainer(boolean reuse) {
        String image = this.getStargateImage();
        GenericContainer container = new GenericContainer(image).withEnv("JAVA_OPTS", "-Xmx1G").withEnv("CLUSTER_NAME", StargateTestResource.getClusterName()).withEnv("CLUSTER_VERSION", StargateTestResource.getClusterVersion()).withEnv("SIMPLE_SNITCH", "true").withEnv("ENABLE_AUTH", "true").withNetworkAliases(new String[]{"coordinator"}).withExposedPorts(new Integer[]{8091, 8081, 8084}).withLogConsumer((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger((String)"coordinator-docker")).withPrefix("COORDINATOR")).waitingFor((WaitStrategy)Wait.forHttp((String)"/checker/readiness").forPort(8084).forStatusCode(200)).withStartupTimeout(this.getCoordinatorStartupTimeout()).withReuse(reuse);
        if (this.isDse()) {
            container.withEnv("DSE", "1");
        }
        return container;
    }

    private Network network() {
        if (null == this.network) {
            this.network = Network.newNetwork();
        }
        return this.network;
    }

    private String getCassandraImage() {
        String image = System.getProperty("testing.containers.cassandra-image");
        if (null == image) {
            return "cassandra:4.0.4";
        }
        return image;
    }

    private String getStargateImage() {
        String image = System.getProperty("testing.containers.stargate-image");
        if (null == image) {
            return "stargateio/coordinator-4_0:latest";
        }
        return image;
    }

    private static String getClusterName() {
        return System.getProperty("testing.containers.cluster-name", "int-test-cluster");
    }

    public static String getClusterVersion() {
        return System.getProperty("testing.containers.cluster-version", "4.0");
    }

    private boolean isDse() {
        String dse = System.getProperty("testing.containers.cluster-dse", Defaults.CLUSTER_DSE);
        return "true".equals(dse);
    }

    private Duration getCassandraStartupTimeout() {
        return Duration.ofMinutes(2L);
    }

    private Duration getCoordinatorStartupTimeout() {
        return Duration.ofMinutes(3L);
    }

    private String getAuthToken(String host, int authPort) {
        try {
            String json = "{\n  \"username\":\"cassandra\",\n  \"password\":\"cassandra\"\n}\n";
            URI authUri = new URI("http://%s:%d/v1/auth".formatted(host, authPort));
            HttpRequest request = HttpRequest.newBuilder().uri(authUri).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(json)).build();
            HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
            ObjectMapper objectMapper = new ObjectMapper();
            AuthResponse authResponse = (AuthResponse)objectMapper.readValue(response.body(), AuthResponse.class);
            return authResponse.authToken;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get Cassandra token for integration tests.", e);
        }
    }

    static interface Defaults {
        public static final String CASSANDRA_IMAGE = "cassandra";
        public static final String CASSANDRA_IMAGE_TAG = "4.0.4";
        public static final String STARGATE_IMAGE = "stargateio/coordinator-4_0";
        public static final String STARGATE_IMAGE_TAG = "latest";
        public static final String CLUSTER_NAME = "int-test-cluster";
        public static final String CLUSTER_VERSION = "4.0";
        public static final String CLUSTER_DSE = null;
    }

    record AuthResponse(String authToken) {
    }
}

