package io.stargate.bridge.proto;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * The gPRC API used by Stargate services to interact with the persistence backend.
 * </pre>
 */
@io.quarkus.grpc.common.Generated(value = "by gRPC proto compiler (version 1.51.0)", comments = "Source: bridge.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class StargateBridgeGrpc {

    private StargateBridgeGrpc() {
    }

    public static final String SERVICE_NAME = "stargate.StargateBridge";

    // Static method descriptors that strictly reflect the proto.
    private static volatile io.grpc.MethodDescriptor<io.stargate.bridge.proto.QueryOuterClass.Query, io.stargate.bridge.proto.QueryOuterClass.Response> getExecuteQueryMethod;

    @io.grpc.stub.annotations.RpcMethod(fullMethodName = SERVICE_NAME + '/' + "ExecuteQuery", requestType = io.stargate.bridge.proto.QueryOuterClass.Query.class, responseType = io.stargate.bridge.proto.QueryOuterClass.Response.class, methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
    public static io.grpc.MethodDescriptor<io.stargate.bridge.proto.QueryOuterClass.Query, io.stargate.bridge.proto.QueryOuterClass.Response> getExecuteQueryMethod() {
        io.grpc.MethodDescriptor<io.stargate.bridge.proto.QueryOuterClass.Query, io.stargate.bridge.proto.QueryOuterClass.Response> getExecuteQueryMethod;
        if ((getExecuteQueryMethod = StargateBridgeGrpc.getExecuteQueryMethod) == null) {
            synchronized (StargateBridgeGrpc.class) {
                if ((getExecuteQueryMethod = StargateBridgeGrpc.getExecuteQueryMethod) == null) {
                    StargateBridgeGrpc.getExecuteQueryMethod = getExecuteQueryMethod = io.grpc.MethodDescriptor.<io.stargate.bridge.proto.QueryOuterClass.Query, io.stargate.bridge.proto.QueryOuterClass.Response>newBuilder().setType(io.grpc.MethodDescriptor.MethodType.UNARY).setFullMethodName(generateFullMethodName(SERVICE_NAME, "ExecuteQuery")).setSampledToLocalTracing(true).setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(io.stargate.bridge.proto.QueryOuterClass.Query.getDefaultInstance())).setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(io.stargate.bridge.proto.QueryOuterClass.Response.getDefaultInstance())).setSchemaDescriptor(new StargateBridgeMethodDescriptorSupplier("ExecuteQuery")).build();
                }
            }
        }
        return getExecuteQueryMethod;
    }

    private static volatile io.grpc.MethodDescriptor<io.stargate.bridge.proto.Schema.QueryWithSchema, io.stargate.bridge.proto.Schema.QueryWithSchemaResponse> getExecuteQueryWithSchemaMethod;

    @io.grpc.stub.annotations.RpcMethod(fullMethodName = SERVICE_NAME + '/' + "ExecuteQueryWithSchema", requestType = io.stargate.bridge.proto.Schema.QueryWithSchema.class, responseType = io.stargate.bridge.proto.Schema.QueryWithSchemaResponse.class, methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
    public static io.grpc.MethodDescriptor<io.stargate.bridge.proto.Schema.QueryWithSchema, io.stargate.bridge.proto.Schema.QueryWithSchemaResponse> getExecuteQueryWithSchemaMethod() {
        io.grpc.MethodDescriptor<io.stargate.bridge.proto.Schema.QueryWithSchema, io.stargate.bridge.proto.Schema.QueryWithSchemaResponse> getExecuteQueryWithSchemaMethod;
        if ((getExecuteQueryWithSchemaMethod = StargateBridgeGrpc.getExecuteQueryWithSchemaMethod) == null) {
            synchronized (StargateBridgeGrpc.class) {
                if ((getExecuteQueryWithSchemaMethod = StargateBridgeGrpc.getExecuteQueryWithSchemaMethod) == null) {
                    StargateBridgeGrpc.getExecuteQueryWithSchemaMethod = getExecuteQueryWithSchemaMethod = io.grpc.MethodDescriptor.<io.stargate.bridge.proto.Schema.QueryWithSchema, io.stargate.bridge.proto.Schema.QueryWithSchemaResponse>newBuilder().setType(io.grpc.MethodDescriptor.MethodType.UNARY).setFullMethodName(generateFullMethodName(SERVICE_NAME, "ExecuteQueryWithSchema")).setSampledToLocalTracing(true).setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(io.stargate.bridge.proto.Schema.QueryWithSchema.getDefaultInstance())).setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(io.stargate.bridge.proto.Schema.QueryWithSchemaResponse.getDefaultInstance())).setSchemaDescriptor(new StargateBridgeMethodDescriptorSupplier("ExecuteQueryWithSchema")).build();
                }
            }
        }
        return getExecuteQueryWithSchemaMethod;
    }

    private static volatile io.grpc.MethodDescriptor<io.stargate.bridge.proto.QueryOuterClass.Batch, io.stargate.bridge.proto.QueryOuterClass.Response> getExecuteBatchMethod;

    @io.grpc.stub.annotations.RpcMethod(fullMethodName = SERVICE_NAME + '/' + "ExecuteBatch", requestType = io.stargate.bridge.proto.QueryOuterClass.Batch.class, responseType = io.stargate.bridge.proto.QueryOuterClass.Response.class, methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
    public static io.grpc.MethodDescriptor<io.stargate.bridge.proto.QueryOuterClass.Batch, io.stargate.bridge.proto.QueryOuterClass.Response> getExecuteBatchMethod() {
        io.grpc.MethodDescriptor<io.stargate.bridge.proto.QueryOuterClass.Batch, io.stargate.bridge.proto.QueryOuterClass.Response> getExecuteBatchMethod;
        if ((getExecuteBatchMethod = StargateBridgeGrpc.getExecuteBatchMethod) == null) {
            synchronized (StargateBridgeGrpc.class) {
                if ((getExecuteBatchMethod = StargateBridgeGrpc.getExecuteBatchMethod) == null) {
                    StargateBridgeGrpc.getExecuteBatchMethod = getExecuteBatchMethod = io.grpc.MethodDescriptor.<io.stargate.bridge.proto.QueryOuterClass.Batch, io.stargate.bridge.proto.QueryOuterClass.Response>newBuilder().setType(io.grpc.MethodDescriptor.MethodType.UNARY).setFullMethodName(generateFullMethodName(SERVICE_NAME, "ExecuteBatch")).setSampledToLocalTracing(true).setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(io.stargate.bridge.proto.QueryOuterClass.Batch.getDefaultInstance())).setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(io.stargate.bridge.proto.QueryOuterClass.Response.getDefaultInstance())).setSchemaDescriptor(new StargateBridgeMethodDescriptorSupplier("ExecuteBatch")).build();
                }
            }
        }
        return getExecuteBatchMethod;
    }

    private static volatile io.grpc.MethodDescriptor<io.stargate.bridge.proto.Schema.DescribeKeyspaceQuery, io.stargate.bridge.proto.Schema.CqlKeyspaceDescribe> getDescribeKeyspaceMethod;

    @io.grpc.stub.annotations.RpcMethod(fullMethodName = SERVICE_NAME + '/' + "DescribeKeyspace", requestType = io.stargate.bridge.proto.Schema.DescribeKeyspaceQuery.class, responseType = io.stargate.bridge.proto.Schema.CqlKeyspaceDescribe.class, methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
    public static io.grpc.MethodDescriptor<io.stargate.bridge.proto.Schema.DescribeKeyspaceQuery, io.stargate.bridge.proto.Schema.CqlKeyspaceDescribe> getDescribeKeyspaceMethod() {
        io.grpc.MethodDescriptor<io.stargate.bridge.proto.Schema.DescribeKeyspaceQuery, io.stargate.bridge.proto.Schema.CqlKeyspaceDescribe> getDescribeKeyspaceMethod;
        if ((getDescribeKeyspaceMethod = StargateBridgeGrpc.getDescribeKeyspaceMethod) == null) {
            synchronized (StargateBridgeGrpc.class) {
                if ((getDescribeKeyspaceMethod = StargateBridgeGrpc.getDescribeKeyspaceMethod) == null) {
                    StargateBridgeGrpc.getDescribeKeyspaceMethod = getDescribeKeyspaceMethod = io.grpc.MethodDescriptor.<io.stargate.bridge.proto.Schema.DescribeKeyspaceQuery, io.stargate.bridge.proto.Schema.CqlKeyspaceDescribe>newBuilder().setType(io.grpc.MethodDescriptor.MethodType.UNARY).setFullMethodName(generateFullMethodName(SERVICE_NAME, "DescribeKeyspace")).setSampledToLocalTracing(true).setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(io.stargate.bridge.proto.Schema.DescribeKeyspaceQuery.getDefaultInstance())).setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(io.stargate.bridge.proto.Schema.CqlKeyspaceDescribe.getDefaultInstance())).setSchemaDescriptor(new StargateBridgeMethodDescriptorSupplier("DescribeKeyspace")).build();
                }
            }
        }
        return getDescribeKeyspaceMethod;
    }

    private static volatile io.grpc.MethodDescriptor<io.stargate.bridge.proto.Schema.AuthorizeSchemaReadsRequest, io.stargate.bridge.proto.Schema.AuthorizeSchemaReadsResponse> getAuthorizeSchemaReadsMethod;

    @io.grpc.stub.annotations.RpcMethod(fullMethodName = SERVICE_NAME + '/' + "AuthorizeSchemaReads", requestType = io.stargate.bridge.proto.Schema.AuthorizeSchemaReadsRequest.class, responseType = io.stargate.bridge.proto.Schema.AuthorizeSchemaReadsResponse.class, methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
    public static io.grpc.MethodDescriptor<io.stargate.bridge.proto.Schema.AuthorizeSchemaReadsRequest, io.stargate.bridge.proto.Schema.AuthorizeSchemaReadsResponse> getAuthorizeSchemaReadsMethod() {
        io.grpc.MethodDescriptor<io.stargate.bridge.proto.Schema.AuthorizeSchemaReadsRequest, io.stargate.bridge.proto.Schema.AuthorizeSchemaReadsResponse> getAuthorizeSchemaReadsMethod;
        if ((getAuthorizeSchemaReadsMethod = StargateBridgeGrpc.getAuthorizeSchemaReadsMethod) == null) {
            synchronized (StargateBridgeGrpc.class) {
                if ((getAuthorizeSchemaReadsMethod = StargateBridgeGrpc.getAuthorizeSchemaReadsMethod) == null) {
                    StargateBridgeGrpc.getAuthorizeSchemaReadsMethod = getAuthorizeSchemaReadsMethod = io.grpc.MethodDescriptor.<io.stargate.bridge.proto.Schema.AuthorizeSchemaReadsRequest, io.stargate.bridge.proto.Schema.AuthorizeSchemaReadsResponse>newBuilder().setType(io.grpc.MethodDescriptor.MethodType.UNARY).setFullMethodName(generateFullMethodName(SERVICE_NAME, "AuthorizeSchemaReads")).setSampledToLocalTracing(true).setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(io.stargate.bridge.proto.Schema.AuthorizeSchemaReadsRequest.getDefaultInstance())).setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(io.stargate.bridge.proto.Schema.AuthorizeSchemaReadsResponse.getDefaultInstance())).setSchemaDescriptor(new StargateBridgeMethodDescriptorSupplier("AuthorizeSchemaReads")).build();
                }
            }
        }
        return getAuthorizeSchemaReadsMethod;
    }

    private static volatile io.grpc.MethodDescriptor<io.stargate.bridge.proto.Schema.SupportedFeaturesRequest, io.stargate.bridge.proto.Schema.SupportedFeaturesResponse> getGetSupportedFeaturesMethod;

    @io.grpc.stub.annotations.RpcMethod(fullMethodName = SERVICE_NAME + '/' + "GetSupportedFeatures", requestType = io.stargate.bridge.proto.Schema.SupportedFeaturesRequest.class, responseType = io.stargate.bridge.proto.Schema.SupportedFeaturesResponse.class, methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
    public static io.grpc.MethodDescriptor<io.stargate.bridge.proto.Schema.SupportedFeaturesRequest, io.stargate.bridge.proto.Schema.SupportedFeaturesResponse> getGetSupportedFeaturesMethod() {
        io.grpc.MethodDescriptor<io.stargate.bridge.proto.Schema.SupportedFeaturesRequest, io.stargate.bridge.proto.Schema.SupportedFeaturesResponse> getGetSupportedFeaturesMethod;
        if ((getGetSupportedFeaturesMethod = StargateBridgeGrpc.getGetSupportedFeaturesMethod) == null) {
            synchronized (StargateBridgeGrpc.class) {
                if ((getGetSupportedFeaturesMethod = StargateBridgeGrpc.getGetSupportedFeaturesMethod) == null) {
                    StargateBridgeGrpc.getGetSupportedFeaturesMethod = getGetSupportedFeaturesMethod = io.grpc.MethodDescriptor.<io.stargate.bridge.proto.Schema.SupportedFeaturesRequest, io.stargate.bridge.proto.Schema.SupportedFeaturesResponse>newBuilder().setType(io.grpc.MethodDescriptor.MethodType.UNARY).setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetSupportedFeatures")).setSampledToLocalTracing(true).setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(io.stargate.bridge.proto.Schema.SupportedFeaturesRequest.getDefaultInstance())).setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(io.stargate.bridge.proto.Schema.SupportedFeaturesResponse.getDefaultInstance())).setSchemaDescriptor(new StargateBridgeMethodDescriptorSupplier("GetSupportedFeatures")).build();
                }
            }
        }
        return getGetSupportedFeaturesMethod;
    }

    /**
     * Creates a new async stub that supports all call types for the service
     */
    public static StargateBridgeStub newStub(io.grpc.Channel channel) {
        io.grpc.stub.AbstractStub.StubFactory<StargateBridgeStub> factory = new io.grpc.stub.AbstractStub.StubFactory<StargateBridgeStub>() {

            @java.lang.Override
            public StargateBridgeStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
                return new StargateBridgeStub(channel, callOptions);
            }
        };
        return StargateBridgeStub.newStub(factory, channel);
    }

    /**
     * Creates a new blocking-style stub that supports unary and streaming output calls on the service
     */
    public static StargateBridgeBlockingStub newBlockingStub(io.grpc.Channel channel) {
        io.grpc.stub.AbstractStub.StubFactory<StargateBridgeBlockingStub> factory = new io.grpc.stub.AbstractStub.StubFactory<StargateBridgeBlockingStub>() {

            @java.lang.Override
            public StargateBridgeBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
                return new StargateBridgeBlockingStub(channel, callOptions);
            }
        };
        return StargateBridgeBlockingStub.newStub(factory, channel);
    }

    /**
     * Creates a new ListenableFuture-style stub that supports unary calls on the service
     */
    public static StargateBridgeFutureStub newFutureStub(io.grpc.Channel channel) {
        io.grpc.stub.AbstractStub.StubFactory<StargateBridgeFutureStub> factory = new io.grpc.stub.AbstractStub.StubFactory<StargateBridgeFutureStub>() {

            @java.lang.Override
            public StargateBridgeFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
                return new StargateBridgeFutureStub(channel, callOptions);
            }
        };
        return StargateBridgeFutureStub.newStub(factory, channel);
    }

    /**
     * <pre>
     * The gPRC API used by Stargate services to interact with the persistence backend.
     * </pre>
     */
    public static abstract class StargateBridgeImplBase implements io.grpc.BindableService {

        /**
         * <pre>
         * Executes a single CQL query.
         * </pre>
         */
        public void executeQuery(io.stargate.bridge.proto.QueryOuterClass.Query request, io.grpc.stub.StreamObserver<io.stargate.bridge.proto.QueryOuterClass.Response> responseObserver) {
            io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getExecuteQueryMethod(), responseObserver);
        }

        /**
         * <pre>
         * Executes a single CQL query, assuming that a keyspace with the given version hash exists on the
         * bridge side.
         * This is an optimization when the client builds a query based on a keyspace's contents: with
         * this operation, it can use its local version of the keyspace (therefore avoiding an extra
         * network hop to fetch it), and execute the query optimistically. If the keyspace has changed,
         * the bridge will reply with the new version, allowing the client to retry.
         * </pre>
         */
        public void executeQueryWithSchema(io.stargate.bridge.proto.Schema.QueryWithSchema request, io.grpc.stub.StreamObserver<io.stargate.bridge.proto.Schema.QueryWithSchemaResponse> responseObserver) {
            io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getExecuteQueryWithSchemaMethod(), responseObserver);
        }

        /**
         * <pre>
         * Executes a batch of CQL queries.
         * </pre>
         */
        public void executeBatch(io.stargate.bridge.proto.QueryOuterClass.Batch request, io.grpc.stub.StreamObserver<io.stargate.bridge.proto.QueryOuterClass.Response> responseObserver) {
            io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getExecuteBatchMethod(), responseObserver);
        }

        /**
         * <pre>
         * Similar to CQL "DESCRIBE KEYSPACE".
         * Note that this operation does not perform any authorization check. The rationale is that, most
         * of the time, client services use schema metadata to build another query that will be
         * immediately executed with `ExecuteQuery` (which does check authorization).
         * If that is not the case (e.g. you return the metadata directly to the client), you can check
         * authorization explicitly with `AuthorizeSchemaReads`.
         * </pre>
         */
        public void describeKeyspace(io.stargate.bridge.proto.Schema.DescribeKeyspaceQuery request, io.grpc.stub.StreamObserver<io.stargate.bridge.proto.Schema.CqlKeyspaceDescribe> responseObserver) {
            io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getDescribeKeyspaceMethod(), responseObserver);
        }

        /**
         * <pre>
         * Checks whether the client is authorized to describe one or more schema elements.
         * </pre>
         */
        public void authorizeSchemaReads(io.stargate.bridge.proto.Schema.AuthorizeSchemaReadsRequest request, io.grpc.stub.StreamObserver<io.stargate.bridge.proto.Schema.AuthorizeSchemaReadsResponse> responseObserver) {
            io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getAuthorizeSchemaReadsMethod(), responseObserver);
        }

        /**
         * <pre>
         * Checks which features are supported by the persistence backend.
         * </pre>
         */
        public void getSupportedFeatures(io.stargate.bridge.proto.Schema.SupportedFeaturesRequest request, io.grpc.stub.StreamObserver<io.stargate.bridge.proto.Schema.SupportedFeaturesResponse> responseObserver) {
            io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetSupportedFeaturesMethod(), responseObserver);
        }

        @java.lang.Override
        public io.grpc.ServerServiceDefinition bindService() {
            return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor()).addMethod(getExecuteQueryMethod(), io.grpc.stub.ServerCalls.asyncUnaryCall(new MethodHandlers<io.stargate.bridge.proto.QueryOuterClass.Query, io.stargate.bridge.proto.QueryOuterClass.Response>(this, METHODID_EXECUTE_QUERY))).addMethod(getExecuteQueryWithSchemaMethod(), io.grpc.stub.ServerCalls.asyncUnaryCall(new MethodHandlers<io.stargate.bridge.proto.Schema.QueryWithSchema, io.stargate.bridge.proto.Schema.QueryWithSchemaResponse>(this, METHODID_EXECUTE_QUERY_WITH_SCHEMA))).addMethod(getExecuteBatchMethod(), io.grpc.stub.ServerCalls.asyncUnaryCall(new MethodHandlers<io.stargate.bridge.proto.QueryOuterClass.Batch, io.stargate.bridge.proto.QueryOuterClass.Response>(this, METHODID_EXECUTE_BATCH))).addMethod(getDescribeKeyspaceMethod(), io.grpc.stub.ServerCalls.asyncUnaryCall(new MethodHandlers<io.stargate.bridge.proto.Schema.DescribeKeyspaceQuery, io.stargate.bridge.proto.Schema.CqlKeyspaceDescribe>(this, METHODID_DESCRIBE_KEYSPACE))).addMethod(getAuthorizeSchemaReadsMethod(), io.grpc.stub.ServerCalls.asyncUnaryCall(new MethodHandlers<io.stargate.bridge.proto.Schema.AuthorizeSchemaReadsRequest, io.stargate.bridge.proto.Schema.AuthorizeSchemaReadsResponse>(this, METHODID_AUTHORIZE_SCHEMA_READS))).addMethod(getGetSupportedFeaturesMethod(), io.grpc.stub.ServerCalls.asyncUnaryCall(new MethodHandlers<io.stargate.bridge.proto.Schema.SupportedFeaturesRequest, io.stargate.bridge.proto.Schema.SupportedFeaturesResponse>(this, METHODID_GET_SUPPORTED_FEATURES))).build();
        }
    }

    /**
     * <pre>
     * The gPRC API used by Stargate services to interact with the persistence backend.
     * </pre>
     */
    public static class StargateBridgeStub extends io.grpc.stub.AbstractAsyncStub<StargateBridgeStub> {

        private StargateBridgeStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            super(channel, callOptions);
        }

        @java.lang.Override
        protected StargateBridgeStub build(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            return new StargateBridgeStub(channel, callOptions);
        }

        /**
         * <pre>
         * Executes a single CQL query.
         * </pre>
         */
        public void executeQuery(io.stargate.bridge.proto.QueryOuterClass.Query request, io.grpc.stub.StreamObserver<io.stargate.bridge.proto.QueryOuterClass.Response> responseObserver) {
            io.grpc.stub.ClientCalls.asyncUnaryCall(getChannel().newCall(getExecuteQueryMethod(), getCallOptions()), request, responseObserver);
        }

        /**
         * <pre>
         * Executes a single CQL query, assuming that a keyspace with the given version hash exists on the
         * bridge side.
         * This is an optimization when the client builds a query based on a keyspace's contents: with
         * this operation, it can use its local version of the keyspace (therefore avoiding an extra
         * network hop to fetch it), and execute the query optimistically. If the keyspace has changed,
         * the bridge will reply with the new version, allowing the client to retry.
         * </pre>
         */
        public void executeQueryWithSchema(io.stargate.bridge.proto.Schema.QueryWithSchema request, io.grpc.stub.StreamObserver<io.stargate.bridge.proto.Schema.QueryWithSchemaResponse> responseObserver) {
            io.grpc.stub.ClientCalls.asyncUnaryCall(getChannel().newCall(getExecuteQueryWithSchemaMethod(), getCallOptions()), request, responseObserver);
        }

        /**
         * <pre>
         * Executes a batch of CQL queries.
         * </pre>
         */
        public void executeBatch(io.stargate.bridge.proto.QueryOuterClass.Batch request, io.grpc.stub.StreamObserver<io.stargate.bridge.proto.QueryOuterClass.Response> responseObserver) {
            io.grpc.stub.ClientCalls.asyncUnaryCall(getChannel().newCall(getExecuteBatchMethod(), getCallOptions()), request, responseObserver);
        }

        /**
         * <pre>
         * Similar to CQL "DESCRIBE KEYSPACE".
         * Note that this operation does not perform any authorization check. The rationale is that, most
         * of the time, client services use schema metadata to build another query that will be
         * immediately executed with `ExecuteQuery` (which does check authorization).
         * If that is not the case (e.g. you return the metadata directly to the client), you can check
         * authorization explicitly with `AuthorizeSchemaReads`.
         * </pre>
         */
        public void describeKeyspace(io.stargate.bridge.proto.Schema.DescribeKeyspaceQuery request, io.grpc.stub.StreamObserver<io.stargate.bridge.proto.Schema.CqlKeyspaceDescribe> responseObserver) {
            io.grpc.stub.ClientCalls.asyncUnaryCall(getChannel().newCall(getDescribeKeyspaceMethod(), getCallOptions()), request, responseObserver);
        }

        /**
         * <pre>
         * Checks whether the client is authorized to describe one or more schema elements.
         * </pre>
         */
        public void authorizeSchemaReads(io.stargate.bridge.proto.Schema.AuthorizeSchemaReadsRequest request, io.grpc.stub.StreamObserver<io.stargate.bridge.proto.Schema.AuthorizeSchemaReadsResponse> responseObserver) {
            io.grpc.stub.ClientCalls.asyncUnaryCall(getChannel().newCall(getAuthorizeSchemaReadsMethod(), getCallOptions()), request, responseObserver);
        }

        /**
         * <pre>
         * Checks which features are supported by the persistence backend.
         * </pre>
         */
        public void getSupportedFeatures(io.stargate.bridge.proto.Schema.SupportedFeaturesRequest request, io.grpc.stub.StreamObserver<io.stargate.bridge.proto.Schema.SupportedFeaturesResponse> responseObserver) {
            io.grpc.stub.ClientCalls.asyncUnaryCall(getChannel().newCall(getGetSupportedFeaturesMethod(), getCallOptions()), request, responseObserver);
        }
    }

    /**
     * <pre>
     * The gPRC API used by Stargate services to interact with the persistence backend.
     * </pre>
     */
    public static class StargateBridgeBlockingStub extends io.grpc.stub.AbstractBlockingStub<StargateBridgeBlockingStub> {

        private StargateBridgeBlockingStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            super(channel, callOptions);
        }

        @java.lang.Override
        protected StargateBridgeBlockingStub build(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            return new StargateBridgeBlockingStub(channel, callOptions);
        }

        /**
         * <pre>
         * Executes a single CQL query.
         * </pre>
         */
        public io.stargate.bridge.proto.QueryOuterClass.Response executeQuery(io.stargate.bridge.proto.QueryOuterClass.Query request) {
            return io.grpc.stub.ClientCalls.blockingUnaryCall(getChannel(), getExecuteQueryMethod(), getCallOptions(), request);
        }

        /**
         * <pre>
         * Executes a single CQL query, assuming that a keyspace with the given version hash exists on the
         * bridge side.
         * This is an optimization when the client builds a query based on a keyspace's contents: with
         * this operation, it can use its local version of the keyspace (therefore avoiding an extra
         * network hop to fetch it), and execute the query optimistically. If the keyspace has changed,
         * the bridge will reply with the new version, allowing the client to retry.
         * </pre>
         */
        public io.stargate.bridge.proto.Schema.QueryWithSchemaResponse executeQueryWithSchema(io.stargate.bridge.proto.Schema.QueryWithSchema request) {
            return io.grpc.stub.ClientCalls.blockingUnaryCall(getChannel(), getExecuteQueryWithSchemaMethod(), getCallOptions(), request);
        }

        /**
         * <pre>
         * Executes a batch of CQL queries.
         * </pre>
         */
        public io.stargate.bridge.proto.QueryOuterClass.Response executeBatch(io.stargate.bridge.proto.QueryOuterClass.Batch request) {
            return io.grpc.stub.ClientCalls.blockingUnaryCall(getChannel(), getExecuteBatchMethod(), getCallOptions(), request);
        }

        /**
         * <pre>
         * Similar to CQL "DESCRIBE KEYSPACE".
         * Note that this operation does not perform any authorization check. The rationale is that, most
         * of the time, client services use schema metadata to build another query that will be
         * immediately executed with `ExecuteQuery` (which does check authorization).
         * If that is not the case (e.g. you return the metadata directly to the client), you can check
         * authorization explicitly with `AuthorizeSchemaReads`.
         * </pre>
         */
        public io.stargate.bridge.proto.Schema.CqlKeyspaceDescribe describeKeyspace(io.stargate.bridge.proto.Schema.DescribeKeyspaceQuery request) {
            return io.grpc.stub.ClientCalls.blockingUnaryCall(getChannel(), getDescribeKeyspaceMethod(), getCallOptions(), request);
        }

        /**
         * <pre>
         * Checks whether the client is authorized to describe one or more schema elements.
         * </pre>
         */
        public io.stargate.bridge.proto.Schema.AuthorizeSchemaReadsResponse authorizeSchemaReads(io.stargate.bridge.proto.Schema.AuthorizeSchemaReadsRequest request) {
            return io.grpc.stub.ClientCalls.blockingUnaryCall(getChannel(), getAuthorizeSchemaReadsMethod(), getCallOptions(), request);
        }

        /**
         * <pre>
         * Checks which features are supported by the persistence backend.
         * </pre>
         */
        public io.stargate.bridge.proto.Schema.SupportedFeaturesResponse getSupportedFeatures(io.stargate.bridge.proto.Schema.SupportedFeaturesRequest request) {
            return io.grpc.stub.ClientCalls.blockingUnaryCall(getChannel(), getGetSupportedFeaturesMethod(), getCallOptions(), request);
        }
    }

    /**
     * <pre>
     * The gPRC API used by Stargate services to interact with the persistence backend.
     * </pre>
     */
    public static class StargateBridgeFutureStub extends io.grpc.stub.AbstractFutureStub<StargateBridgeFutureStub> {

        private StargateBridgeFutureStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            super(channel, callOptions);
        }

        @java.lang.Override
        protected StargateBridgeFutureStub build(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            return new StargateBridgeFutureStub(channel, callOptions);
        }

        /**
         * <pre>
         * Executes a single CQL query.
         * </pre>
         */
        public com.google.common.util.concurrent.ListenableFuture<io.stargate.bridge.proto.QueryOuterClass.Response> executeQuery(io.stargate.bridge.proto.QueryOuterClass.Query request) {
            return io.grpc.stub.ClientCalls.futureUnaryCall(getChannel().newCall(getExecuteQueryMethod(), getCallOptions()), request);
        }

        /**
         * <pre>
         * Executes a single CQL query, assuming that a keyspace with the given version hash exists on the
         * bridge side.
         * This is an optimization when the client builds a query based on a keyspace's contents: with
         * this operation, it can use its local version of the keyspace (therefore avoiding an extra
         * network hop to fetch it), and execute the query optimistically. If the keyspace has changed,
         * the bridge will reply with the new version, allowing the client to retry.
         * </pre>
         */
        public com.google.common.util.concurrent.ListenableFuture<io.stargate.bridge.proto.Schema.QueryWithSchemaResponse> executeQueryWithSchema(io.stargate.bridge.proto.Schema.QueryWithSchema request) {
            return io.grpc.stub.ClientCalls.futureUnaryCall(getChannel().newCall(getExecuteQueryWithSchemaMethod(), getCallOptions()), request);
        }

        /**
         * <pre>
         * Executes a batch of CQL queries.
         * </pre>
         */
        public com.google.common.util.concurrent.ListenableFuture<io.stargate.bridge.proto.QueryOuterClass.Response> executeBatch(io.stargate.bridge.proto.QueryOuterClass.Batch request) {
            return io.grpc.stub.ClientCalls.futureUnaryCall(getChannel().newCall(getExecuteBatchMethod(), getCallOptions()), request);
        }

        /**
         * <pre>
         * Similar to CQL "DESCRIBE KEYSPACE".
         * Note that this operation does not perform any authorization check. The rationale is that, most
         * of the time, client services use schema metadata to build another query that will be
         * immediately executed with `ExecuteQuery` (which does check authorization).
         * If that is not the case (e.g. you return the metadata directly to the client), you can check
         * authorization explicitly with `AuthorizeSchemaReads`.
         * </pre>
         */
        public com.google.common.util.concurrent.ListenableFuture<io.stargate.bridge.proto.Schema.CqlKeyspaceDescribe> describeKeyspace(io.stargate.bridge.proto.Schema.DescribeKeyspaceQuery request) {
            return io.grpc.stub.ClientCalls.futureUnaryCall(getChannel().newCall(getDescribeKeyspaceMethod(), getCallOptions()), request);
        }

        /**
         * <pre>
         * Checks whether the client is authorized to describe one or more schema elements.
         * </pre>
         */
        public com.google.common.util.concurrent.ListenableFuture<io.stargate.bridge.proto.Schema.AuthorizeSchemaReadsResponse> authorizeSchemaReads(io.stargate.bridge.proto.Schema.AuthorizeSchemaReadsRequest request) {
            return io.grpc.stub.ClientCalls.futureUnaryCall(getChannel().newCall(getAuthorizeSchemaReadsMethod(), getCallOptions()), request);
        }

        /**
         * <pre>
         * Checks which features are supported by the persistence backend.
         * </pre>
         */
        public com.google.common.util.concurrent.ListenableFuture<io.stargate.bridge.proto.Schema.SupportedFeaturesResponse> getSupportedFeatures(io.stargate.bridge.proto.Schema.SupportedFeaturesRequest request) {
            return io.grpc.stub.ClientCalls.futureUnaryCall(getChannel().newCall(getGetSupportedFeaturesMethod(), getCallOptions()), request);
        }
    }

    private static final int METHODID_EXECUTE_QUERY = 0;

    private static final int METHODID_EXECUTE_QUERY_WITH_SCHEMA = 1;

    private static final int METHODID_EXECUTE_BATCH = 2;

    private static final int METHODID_DESCRIBE_KEYSPACE = 3;

    private static final int METHODID_AUTHORIZE_SCHEMA_READS = 4;

    private static final int METHODID_GET_SUPPORTED_FEATURES = 5;

    private static final class MethodHandlers<Req, Resp> implements io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>, io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>, io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>, io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {

        private final StargateBridgeImplBase serviceImpl;

        private final int methodId;

        MethodHandlers(StargateBridgeImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch(methodId) {
                case METHODID_EXECUTE_QUERY:
                    serviceImpl.executeQuery((io.stargate.bridge.proto.QueryOuterClass.Query) request, (io.grpc.stub.StreamObserver<io.stargate.bridge.proto.QueryOuterClass.Response>) responseObserver);
                    break;
                case METHODID_EXECUTE_QUERY_WITH_SCHEMA:
                    serviceImpl.executeQueryWithSchema((io.stargate.bridge.proto.Schema.QueryWithSchema) request, (io.grpc.stub.StreamObserver<io.stargate.bridge.proto.Schema.QueryWithSchemaResponse>) responseObserver);
                    break;
                case METHODID_EXECUTE_BATCH:
                    serviceImpl.executeBatch((io.stargate.bridge.proto.QueryOuterClass.Batch) request, (io.grpc.stub.StreamObserver<io.stargate.bridge.proto.QueryOuterClass.Response>) responseObserver);
                    break;
                case METHODID_DESCRIBE_KEYSPACE:
                    serviceImpl.describeKeyspace((io.stargate.bridge.proto.Schema.DescribeKeyspaceQuery) request, (io.grpc.stub.StreamObserver<io.stargate.bridge.proto.Schema.CqlKeyspaceDescribe>) responseObserver);
                    break;
                case METHODID_AUTHORIZE_SCHEMA_READS:
                    serviceImpl.authorizeSchemaReads((io.stargate.bridge.proto.Schema.AuthorizeSchemaReadsRequest) request, (io.grpc.stub.StreamObserver<io.stargate.bridge.proto.Schema.AuthorizeSchemaReadsResponse>) responseObserver);
                    break;
                case METHODID_GET_SUPPORTED_FEATURES:
                    serviceImpl.getSupportedFeatures((io.stargate.bridge.proto.Schema.SupportedFeaturesRequest) request, (io.grpc.stub.StreamObserver<io.stargate.bridge.proto.Schema.SupportedFeaturesResponse>) responseObserver);
                    break;
                default:
                    throw new AssertionError();
            }
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public io.grpc.stub.StreamObserver<Req> invoke(io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch(methodId) {
                default:
                    throw new AssertionError();
            }
        }
    }

    private static abstract class StargateBridgeBaseDescriptorSupplier implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {

        StargateBridgeBaseDescriptorSupplier() {
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
            return io.stargate.bridge.proto.Bridge.getDescriptor();
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
            return getFileDescriptor().findServiceByName("StargateBridge");
        }
    }

    private static final class StargateBridgeFileDescriptorSupplier extends StargateBridgeBaseDescriptorSupplier {

        StargateBridgeFileDescriptorSupplier() {
        }
    }

    private static final class StargateBridgeMethodDescriptorSupplier extends StargateBridgeBaseDescriptorSupplier implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {

        private final String methodName;

        StargateBridgeMethodDescriptorSupplier(String methodName) {
            this.methodName = methodName;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
            return getServiceDescriptor().findMethodByName(methodName);
        }
    }

    private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

    public static io.grpc.ServiceDescriptor getServiceDescriptor() {
        io.grpc.ServiceDescriptor result = serviceDescriptor;
        if (result == null) {
            synchronized (StargateBridgeGrpc.class) {
                result = serviceDescriptor;
                if (result == null) {
                    serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME).setSchemaDescriptor(new StargateBridgeFileDescriptorSupplier()).addMethod(getExecuteQueryMethod()).addMethod(getExecuteQueryWithSchemaMethod()).addMethod(getExecuteBatchMethod()).addMethod(getDescribeKeyspaceMethod()).addMethod(getAuthorizeSchemaReadsMethod()).addMethod(getGetSupportedFeaturesMethod()).build();
                }
            }
        }
        return result;
    }
}

