/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.logging;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import io.stargate.sgv2.api.common.StargateRequestInfo;
import io.stargate.sgv2.api.common.config.LoggingConfig;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Set;
import org.jboss.resteasy.reactive.server.ServerResponseFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class LoggingFilter {
    private static final Logger logger = LoggerFactory.getLogger(LoggingFilter.class);
    private final StargateRequestInfo requestInfo;
    private final LoggingConfig loggingConfig;

    @Inject
    public LoggingFilter(StargateRequestInfo requestInfo, LoggingConfig loggingConfig) {
        this.requestInfo = requestInfo;
        this.loggingConfig = loggingConfig;
    }

    @ServerResponseFilter
    public void logRequestIfRequired(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        if (this.isLoggingAllowed(requestContext, responseContext)) {
            logger.debug(this.buildRequestInfo(requestContext, responseContext, this.loggingConfig.requestBodyLoggingEnabled()));
        }
    }

    private String buildRequestInfo(ContainerRequestContext requestContext, ContainerResponseContext responseContext, boolean logRequestBody) {
        String requestBody = logRequestBody ? this.getRequestBody(requestContext) : "";
        return String.format("REQUEST INFO :: %s %s %s %s %s", this.requestInfo.getTenantId().orElse("tenant-unknown"), responseContext.getStatus(), requestContext.getMethod(), requestContext.getUriInfo().getPath(), requestBody);
    }

    private String getRequestBody(ContainerRequestContext requestContext) {
        try {
            InputStream inputStream = requestContext.getEntityStream();
            if (inputStream == null || !inputStream.markSupported()) {
                return "";
            }
            inputStream.reset();
            return CharStreams.toString((Readable)new InputStreamReader(inputStream, Charsets.UTF_8));
        }
        catch (IOException e) {
            logger.error("Exception occurred while trying to log request info", (Throwable)e);
            return "";
        }
    }

    private boolean isLoggingAllowed(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        Set<String> allowedErrorCodes;
        if (!this.loggingConfig.enabled()) {
            return false;
        }
        Set<String> allowedTenants = this.loggingConfig.enabledTenants().orElse(Collections.singleton("all"));
        if (!allowedTenants.contains("all") && !allowedTenants.contains(this.requestInfo.getTenantId().orElse(""))) {
            return false;
        }
        Set<String> allowedPaths = this.loggingConfig.enabledPaths().orElse(Collections.singleton("all"));
        if (!allowedPaths.contains("all") && !allowedPaths.contains(requestContext.getUriInfo().getPath())) {
            return false;
        }
        Set<String> allowedPathPrefixes = this.loggingConfig.enabledPathPrefixes().orElse(Collections.singleton("all"));
        if (!allowedPathPrefixes.contains("all")) {
            boolean found = false;
            for (String prefix : allowedPathPrefixes) {
                if (!requestContext.getUriInfo().getPath().startsWith(prefix)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        }
        if (!(allowedErrorCodes = this.loggingConfig.enabledErrorCodes().orElse(Collections.singleton("all"))).contains("all") && !allowedErrorCodes.contains(String.valueOf(responseContext.getStatus()))) {
            return false;
        }
        Set<String> allowedMethods = this.loggingConfig.enabledMethods().orElse(Collections.singleton("all"));
        return allowedMethods.contains("all") || allowedMethods.contains(requestContext.getMethod());
    }
}

