/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.security;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpCredentialTransport;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.smallrye.mutiny.Uni;
import io.stargate.sgv2.api.common.security.HeaderAuthenticationRequest;
import io.stargate.sgv2.api.common.security.challenge.ChallengeSender;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.inject.Instance;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderBasedAuthenticationMechanism
implements HttpAuthenticationMechanism {
    private static final Logger LOG = LoggerFactory.getLogger(HeaderBasedAuthenticationMechanism.class);
    private final String headerName;
    private final Instance<ChallengeSender> customChallengeSender;

    public HeaderBasedAuthenticationMechanism(String headerName, Instance<ChallengeSender> customChallengeSender) {
        this.headerName = headerName;
        this.customChallengeSender = customChallengeSender;
    }

    public Uni<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
        String headerValue = context.request().getHeader(this.headerName);
        if (null != headerValue) {
            HeaderAuthenticationRequest request = new HeaderAuthenticationRequest(this.headerName, headerValue);
            HttpSecurityUtils.setRoutingContextAttribute((AuthenticationRequest)request, (RoutingContext)context);
            return identityProviderManager.authenticate((AuthenticationRequest)request);
        }
        return Uni.createFrom().optional(Optional.empty());
    }

    public Uni<ChallengeData> getChallenge(RoutingContext context) {
        return Uni.createFrom().item((Object)new ChallengeData(HttpResponseStatus.UNAUTHORIZED.code(), null, null));
    }

    public Uni<Boolean> sendChallenge(RoutingContext context) {
        if (!this.customChallengeSender.isResolvable()) {
            return super.sendChallenge(context);
        }
        return this.getChallenge(context).flatMap(c -> (Uni)((ChallengeSender)this.customChallengeSender.get()).apply(context, c));
    }

    public Set<Class<? extends AuthenticationRequest>> getCredentialTypes() {
        return Collections.singleton(HeaderAuthenticationRequest.class);
    }

    public Uni<HttpCredentialTransport> getCredentialTransport(RoutingContext context) {
        HttpCredentialTransport transport = new HttpCredentialTransport(HttpCredentialTransport.Type.OTHER_HEADER, this.headerName);
        return Uni.createFrom().item((Object)transport);
    }
}

