/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.metrics;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.quarkus.micrometer.runtime.HttpServerMetricsTagsContributor;
import io.stargate.sgv2.api.common.StargateRequestInfo;
import io.stargate.sgv2.api.common.config.MetricsConfig;
import io.vertx.core.http.HttpServerRequest;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.regex.Pattern;

@ApplicationScoped
public class TenantRequestMetricsTagProvider
implements HttpServerMetricsTagsContributor {
    private static final Pattern USER_AGENT_SPLIT = Pattern.compile("[\\s/]");
    private static final String UNKNOWN_VALUE = "unknown";
    private final MetricsConfig.TenantRequestCounterConfig config;
    private final StargateRequestInfo requestInfo;
    private final Tag errorTrue;
    private final Tag errorFalse;
    private final Tag tenantUnknown;

    @Inject
    public TenantRequestMetricsTagProvider(StargateRequestInfo requestInfo, MetricsConfig metricsConfig) {
        this.requestInfo = requestInfo;
        this.config = metricsConfig.tenantRequestCounter();
        this.errorTrue = Tag.of((String)this.config.errorTag(), (String)"true");
        this.errorFalse = Tag.of((String)this.config.errorTag(), (String)"false");
        this.tenantUnknown = Tag.of((String)this.config.tenantTag(), (String)UNKNOWN_VALUE);
    }

    public Tags contribute(HttpServerMetricsTagsContributor.Context context) {
        Tag tenantTag = this.requestInfo.getTenantId().map(id -> Tag.of((String)this.config.tenantTag(), (String)id)).orElse(this.tenantUnknown);
        Tags tags = Tags.of((Tag[])new Tag[]{tenantTag});
        if (this.config.userAgentTagEnabled()) {
            String userAgentValue = this.getUserAgentValue(context.request());
            tags = tags.and(new Tag[]{Tag.of((String)this.config.userAgentTag(), (String)userAgentValue)});
        }
        return tags;
    }

    private String getUserAgentValue(HttpServerRequest request) {
        String headerString = request.getHeader("user-agent");
        if (null != headerString && !headerString.isBlank()) {
            String[] split = USER_AGENT_SPLIT.split(headerString);
            if (split.length > 0) {
                return split[0];
            }
            return headerString;
        }
        return UNKNOWN_VALUE;
    }
}

