/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.security;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpCredentialTransport;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.smallrye.mutiny.Uni;
import io.stargate.sgv2.api.common.exception.model.dto.ApiError;
import io.stargate.sgv2.api.common.security.HeaderAuthenticationRequest;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderBasedAuthenticationMechanism
implements HttpAuthenticationMechanism {
    private static final Logger LOG = LoggerFactory.getLogger(HeaderBasedAuthenticationMechanism.class);
    private final String headerName;
    private final ObjectMapper objectMapper;

    public HeaderBasedAuthenticationMechanism(String headerName, ObjectMapper objectMapper) {
        this.headerName = headerName;
        this.objectMapper = objectMapper;
    }

    public Uni<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
        String headerValue = context.request().getHeader(this.headerName);
        if (null != headerValue) {
            HeaderAuthenticationRequest request = new HeaderAuthenticationRequest(this.headerName, headerValue);
            HttpSecurityUtils.setRoutingContextAttribute((AuthenticationRequest)request, (RoutingContext)context);
            return identityProviderManager.authenticate((AuthenticationRequest)request);
        }
        return Uni.createFrom().optional(Optional.empty());
    }

    public Uni<ChallengeData> getChallenge(RoutingContext context) {
        return Uni.createFrom().item((Object)new ChallengeData(HttpResponseStatus.UNAUTHORIZED.code(), null, null));
    }

    public Uni<Boolean> sendChallenge(RoutingContext context) {
        return this.getChallenge(context).flatMap(challengeData -> {
            int status = challengeData.status;
            context.response().setStatusCode(status);
            String message = "Role unauthorized for operation: Missing token, expecting one in the %s header.".formatted(this.headerName);
            ApiError apiError = new ApiError(message, status);
            try {
                String response = this.objectMapper.writeValueAsString((Object)apiError);
                context.response().headers().set("Content-Type", "application/json");
                context.response().headers().set("Content-Length", String.valueOf(response.getBytes().length));
                return Uni.createFrom().completionStage(context.response().write(response).map((Object)true).toCompletionStage());
            }
            catch (JsonProcessingException e) {
                LOG.error("Unable to serialize API error instance {} to JSON.", (Object)apiError, (Object)e);
                return Uni.createFrom().item((Object)true);
            }
        });
    }

    public Set<Class<? extends AuthenticationRequest>> getCredentialTypes() {
        return Collections.singleton(HeaderAuthenticationRequest.class);
    }

    public Uni<HttpCredentialTransport> getCredentialTransport(RoutingContext context) {
        HttpCredentialTransport transport = new HttpCredentialTransport(HttpCredentialTransport.Type.OTHER_HEADER, this.headerName);
        return Uni.createFrom().item((Object)transport);
    }
}

