/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.cql.builder;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.stargate.sgv2.api.common.cql.builder.Column;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Column", generator="Immutables")
@Immutable
public final class ImmutableColumn
implements Column {
    private final String name;
    @Nullable
    private final String type;
    @Nullable
    private final Column.Kind kind;
    @Nullable
    private final Column.Order order;
    private final transient int hashCode;
    private volatile transient long lazyInitBitmap;
    private static final long CQL_NAME_LAZY_INIT_BIT = 1L;
    private transient String cqlName;

    private ImmutableColumn(String name, @Nullable String type, @Nullable Column.Kind kind, @Nullable Column.Order order) {
        this.name = name;
        this.type = type;
        this.kind = kind;
        this.order = order;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    @Nullable
    public String type() {
        return this.type;
    }

    @Override
    @Nullable
    public Column.Kind kind() {
        return this.kind;
    }

    @Override
    @Nullable
    public Column.Order order() {
        return this.order;
    }

    public final ImmutableColumn withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableColumn(newValue, this.type, this.kind, this.order);
    }

    public final ImmutableColumn withType(@Nullable String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return new ImmutableColumn(this.name, value, this.kind, this.order);
    }

    public final ImmutableColumn withKind(@Nullable Column.Kind value) {
        if (this.kind == value) {
            return this;
        }
        return new ImmutableColumn(this.name, this.type, value, this.order);
    }

    public final ImmutableColumn withOrder(@Nullable Column.Order value) {
        if (this.order == value) {
            return this;
        }
        return new ImmutableColumn(this.name, this.type, this.kind, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableColumn && this.equalTo(0, (ImmutableColumn)another);
    }

    private boolean equalTo(int synthetic, ImmutableColumn another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.name.equals(another.name) && Objects.equals(this.type, another.type) && Objects.equals((Object)this.kind, (Object)another.kind) && Objects.equals((Object)this.order, (Object)another.order);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + Objects.hashCode((Object)this.kind);
        h += (h << 5) + Objects.hashCode((Object)this.order);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Column").omitNullValues().add("name", (Object)this.name).add("type", (Object)this.type).add("kind", (Object)this.kind).add("order", (Object)this.order).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String cqlName() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableColumn immutableColumn = this;
            synchronized (immutableColumn) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.cqlName = Objects.requireNonNull(Column.super.cqlName(), "cqlName");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.cqlName;
    }

    public static ImmutableColumn copyOf(Column instance) {
        if (instance instanceof ImmutableColumn) {
            return (ImmutableColumn)instance;
        }
        return ImmutableColumn.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Column", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String name;
        @Nullable
        private String type;
        @Nullable
        private Column.Kind kind;
        @Nullable
        private Column.Order order;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Column instance) {
            Column.Order orderValue;
            Column.Kind kindValue;
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            String typeValue = instance.type();
            if (typeValue != null) {
                this.type(typeValue);
            }
            if ((kindValue = instance.kind()) != null) {
                this.kind(kindValue);
            }
            if ((orderValue = instance.order()) != null) {
                this.order(orderValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(@Nullable String type) {
            this.type = type;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder kind(@Nullable Column.Kind kind) {
            this.kind = kind;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder order(@Nullable Column.Order order) {
            this.order = order;
            return this;
        }

        public ImmutableColumn build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableColumn(this.name, this.type, this.kind, this.order);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build Column, some of required attributes are not set " + attributes;
        }
    }
}

