/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.security;

import com.google.common.collect.ImmutableMap;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.QuarkusTestProfile;
import io.quarkus.test.junit.TestProfile;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
@TestProfile(value=Profile.class)
public class HeaderBasedAuthenticationMechanismTest {
    @Test
    public void missingToken() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/v2/testing", new Object[0])).then()).statusCode(401)).body("code", Matchers.is((Object)401), new Object[0])).body("description", Matchers.is((Object)"Role unauthorized for operation: Missing token, expecting one in the X-Cassandra-Token header."), new Object[0]);
    }

    @Test
    public void notProtectedPaths() {
        ((ValidatableResponse)((Response)RestAssured.given().when().get("/testing", new Object[0])).then()).statusCode(200);
    }

    @ApplicationScoped
    @Path(value="")
    public static class TestingResource {
        @GET
        @Produces(value={"application/json"})
        @Path(value="/v2/testing")
        public String greetAuthorized() {
            return "hello-authorized";
        }

        @GET
        @Produces(value={"application/json"})
        @Path(value="/testing")
        public String greet() {
            return "hello";
        }
    }

    public static final class Profile
    implements QuarkusTestProfile {
        public Map<String, String> getConfigOverrides() {
            return ImmutableMap.builder().put((Object)"quarkus.http.auth.proactive", (Object)"true").put((Object)"quarkus.http.auth.permission.default.paths", (Object)"/v2/*").put((Object)"quarkus.http.auth.permission.default.policy", (Object)"authenticated").build();
        }
    }
}

