/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.tenant.impl;

import io.stargate.sgv2.api.common.config.MultiTenancyConfig;
import io.stargate.sgv2.api.common.tenant.TenantResolver;
import io.vertx.ext.web.RoutingContext;
import java.util.Optional;
import javax.ws.rs.core.SecurityContext;

public class SubdomainTenantResolver
implements TenantResolver {
    private final MultiTenancyConfig.TenantResolverConfig.SubdomainTenantResolverConfig config;

    public SubdomainTenantResolver(MultiTenancyConfig.TenantResolverConfig.SubdomainTenantResolverConfig config) {
        this.config = config;
    }

    @Override
    public Optional<String> resolve(RoutingContext context, SecurityContext securityContext) {
        String host = context.request().host();
        int index = host.indexOf(46);
        if (index > 0) {
            int maxChars;
            String tenantId = host.substring(0, index);
            if (this.config.maxChars().isPresent() && (maxChars = this.config.maxChars().getAsInt()) < tenantId.length()) {
                return Optional.of(tenantId.substring(0, maxChars));
            }
            return Optional.of(tenantId);
        }
        return Optional.empty();
    }
}

