/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.schema;

import com.google.protobuf.BytesValue;
import com.google.protobuf.Int32Value;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.opentelemetry.extension.annotations.WithSpan;
import io.quarkus.cache.Cache;
import io.quarkus.cache.CacheInvalidate;
import io.quarkus.cache.CacheKey;
import io.quarkus.cache.CacheName;
import io.quarkus.cache.CacheResult;
import io.quarkus.cache.CaffeineCache;
import io.quarkus.cache.CompositeCacheKey;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.bridge.proto.Schema;
import io.stargate.bridge.proto.StargateBridge;
import io.stargate.sgv2.api.common.StargateRequestInfo;
import io.stargate.sgv2.api.common.grpc.UnauthorizedKeyspaceException;
import io.stargate.sgv2.api.common.grpc.UnauthorizedTableException;
import io.stargate.sgv2.api.common.grpc.proto.SchemaReads;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class SchemaManager {
    @Inject
    @CacheName(value="keyspace-cache")
    Cache keyspaceCache;
    @Inject
    Schema.SchemaRead.SourceApi sourceApi;
    @Inject
    StargateRequestInfo requestInfo;

    @WithSpan
    public Uni<Schema.CqlKeyspaceDescribe> getKeyspace(String keyspace) {
        StargateBridge bridge = this.requestInfo.getStargateBridge();
        return this.getKeyspaceInternal(bridge, keyspace);
    }

    @WithSpan
    public Multi<Schema.CqlKeyspaceDescribe> getKeyspaces() {
        StargateBridge bridge = this.requestInfo.getStargateBridge();
        return this.getKeyspaceNames(bridge).onItem().transformToUniAndMerge(keyspace -> this.getKeyspaceInternal(bridge, (String)keyspace));
    }

    @WithSpan
    public Uni<Schema.CqlTable> getTable(String keyspace, String table, Function<String, Uni<? extends Schema.CqlKeyspaceDescribe>> missingKeyspace) {
        StargateBridge bridge = this.requestInfo.getStargateBridge();
        return this.getTableInternal(bridge, keyspace, table, missingKeyspace);
    }

    @WithSpan
    public Multi<Schema.CqlTable> getTables(String keyspace, Function<String, Uni<? extends Schema.CqlKeyspaceDescribe>> missingKeyspace) {
        StargateBridge bridge = this.requestInfo.getStargateBridge();
        return this.getKeyspaceInternal(bridge, keyspace).onItem().ifNull().switchTo(missingKeyspace.apply(keyspace)).onItem().ifNotNull().transformToMulti(k -> Multi.createFrom().iterable((Iterable)k.getTablesList()));
    }

    @WithSpan
    public Uni<Schema.CqlKeyspaceDescribe> getKeyspaceAuthorized(String keyspace) {
        StargateBridge bridge = this.requestInfo.getStargateBridge();
        return this.authorizeKeyspaceInternal(bridge, keyspace).onItem().transformToUni(authorized -> {
            if (authorized.booleanValue()) {
                return this.getKeyspaceInternal(bridge, keyspace);
            }
            UnauthorizedKeyspaceException unauthorized = new UnauthorizedKeyspaceException(keyspace);
            return Uni.createFrom().failure((Throwable)unauthorized);
        });
    }

    @WithSpan
    public Multi<Schema.CqlKeyspaceDescribe> getKeyspacesAuthorized() {
        StargateBridge bridge = this.requestInfo.getStargateBridge();
        return this.getKeyspaceNames(bridge).collect().asList().onItem().transformToMulti(keyspaceNames -> {
            if (null == keyspaceNames || keyspaceNames.isEmpty()) {
                return Multi.createFrom().empty();
            }
            List reads = keyspaceNames.stream().map(n -> SchemaReads.keyspace(n, this.sourceApi)).collect(Collectors.toList());
            Schema.AuthorizeSchemaReadsRequest request = Schema.AuthorizeSchemaReadsRequest.newBuilder().addAllSchemaReads(reads).build();
            return bridge.authorizeSchemaReads(request).onItem().ifNotNull().transformToMulti(response -> {
                ArrayList<String> authorizedKeyspaces = new ArrayList<String>(keyspaceNames.size());
                List authorizedList = response.getAuthorizedList();
                for (int i = 0; i < authorizedList.size(); ++i) {
                    if (!((Boolean)authorizedList.get(i)).booleanValue()) continue;
                    authorizedKeyspaces.add((String)keyspaceNames.get(i));
                }
                return Multi.createFrom().iterable(authorizedKeyspaces);
            });
        }).onItem().transformToUniAndMerge(keyspace -> this.getKeyspaceInternal(bridge, (String)keyspace));
    }

    @WithSpan
    public Uni<Schema.CqlTable> getTableAuthorized(String keyspace, String table, Function<String, Uni<? extends Schema.CqlKeyspaceDescribe>> missingKeyspace) {
        StargateBridge bridge = this.requestInfo.getStargateBridge();
        return this.authorizeTableInternal(bridge, keyspace, table).onItem().transformToUni(authorized -> {
            if (authorized.booleanValue()) {
                return this.getTableInternal(bridge, keyspace, table, missingKeyspace);
            }
            UnauthorizedTableException unauthorized = new UnauthorizedTableException(keyspace, table);
            return Uni.createFrom().failure((Throwable)unauthorized);
        });
    }

    @WithSpan
    public Multi<Schema.CqlTable> getTablesAuthorized(String keyspace, Function<String, Uni<? extends Schema.CqlKeyspaceDescribe>> missingKeyspace) {
        StargateBridge bridge = this.requestInfo.getStargateBridge();
        return this.getKeyspaceInternal(bridge, keyspace).onItem().ifNull().switchTo(missingKeyspace.apply(keyspace)).onItem().ifNotNull().transformToMulti(keyspaceDescribe -> {
            List tables = keyspaceDescribe.getTablesList();
            if (tables.isEmpty()) {
                return Multi.createFrom().empty();
            }
            List reads = tables.stream().map(t -> SchemaReads.table(keyspace, t.getName(), this.sourceApi)).collect(Collectors.toList());
            Schema.AuthorizeSchemaReadsRequest request = Schema.AuthorizeSchemaReadsRequest.newBuilder().addAllSchemaReads(reads).build();
            return bridge.authorizeSchemaReads(request).onItem().ifNotNull().transformToMulti(response -> {
                ArrayList<Schema.CqlTable> authorizedTables = new ArrayList<Schema.CqlTable>(tables.size());
                List authorizedList = response.getAuthorizedList();
                for (int i = 0; i < authorizedList.size(); ++i) {
                    if (!((Boolean)authorizedList.get(i)).booleanValue()) continue;
                    authorizedTables.add((Schema.CqlTable)tables.get(i));
                }
                return Multi.createFrom().iterable(authorizedTables);
            });
        });
    }

    public Uni<Boolean> authorizeKeyspaceInternal(StargateBridge bridge, String keyspaceName) {
        Schema.SchemaRead schemaRead = SchemaReads.keyspace(keyspaceName, this.sourceApi);
        return this.authorizeInternal(bridge, schemaRead);
    }

    public Uni<Boolean> authorizeTableInternal(StargateBridge bridge, String keyspaceName, String tableName) {
        Schema.SchemaRead schemaRead = SchemaReads.table(keyspaceName, tableName, this.sourceApi);
        return this.authorizeInternal(bridge, schemaRead);
    }

    public Uni<Boolean> authorizeInternal(StargateBridge bridge, Schema.SchemaRead schemaRead) {
        Schema.AuthorizeSchemaReadsRequest request = Schema.AuthorizeSchemaReadsRequest.newBuilder().addSchemaReads(schemaRead).build();
        return bridge.authorizeSchemaReads(request).map(response -> (Boolean)response.getAuthorizedList().iterator().next());
    }

    private Uni<Schema.CqlKeyspaceDescribe> getKeyspaceInternal(StargateBridge bridge, String keyspaceName) {
        Optional<String> tenantId = this.requestInfo.getTenantId();
        CompositeCacheKey cacheKey = new CompositeCacheKey(new Object[]{keyspaceName, tenantId});
        boolean cached = ((CaffeineCache)this.keyspaceCache.as(CaffeineCache.class)).keySet().contains(cacheKey);
        return this.fetchKeyspace(keyspaceName, tenantId, bridge).flatMap(keyspace -> {
            if (!cached) {
                return Uni.createFrom().item(keyspace);
            }
            Schema.DescribeKeyspaceQuery request = Schema.DescribeKeyspaceQuery.newBuilder().setKeyspaceName(keyspaceName).setHash(keyspace.getHash()).build();
            return bridge.describeKeyspace(request).onItem().transformToUni(updatedKeyspace -> {
                if (null != updatedKeyspace && updatedKeyspace.hasCqlKeyspace()) {
                    return this.invalidateKeyspace(keyspaceName, tenantId).flatMap(v -> this.cacheKeyspace(keyspaceName, tenantId, (Schema.CqlKeyspaceDescribe)updatedKeyspace));
                }
                return Uni.createFrom().item(keyspace);
            });
        }).onFailure().recoverWithUni(t -> {
            StatusRuntimeException sre;
            if (t instanceof StatusRuntimeException && Objects.equals((sre = (StatusRuntimeException)t).getStatus().getCode(), Status.Code.NOT_FOUND)) {
                return this.invalidateKeyspace(keyspaceName, tenantId).flatMap(v -> Uni.createFrom().nullItem());
            }
            return Uni.createFrom().failure(t);
        });
    }

    private Uni<Schema.CqlTable> getTableInternal(StargateBridge bridge, String keyspaceName, String tableName, Function<String, Uni<? extends Schema.CqlKeyspaceDescribe>> missingKeyspace) {
        return this.getKeyspaceInternal(bridge, keyspaceName).onItem().ifNull().switchTo(missingKeyspace.apply(keyspaceName)).onItem().ifNotNull().transformToUni(keyspace -> {
            List tables = keyspace.getTablesList();
            Optional<Schema.CqlTable> table = tables.stream().filter(t -> Objects.equals(t.getName(), tableName)).findFirst();
            return Uni.createFrom().optional(table);
        });
    }

    private Multi<String> getKeyspaceNames(StargateBridge bridge) {
        return Multi.createBy().repeating().uni(() -> new AtomicReference<Paging>(new Paging(true, null)), state -> {
            Paging paging = (Paging)state.get();
            if (!paging.hasMore()) {
                return Uni.createFrom().item(Collections.emptyList());
            }
            QueryOuterClass.Query.Builder queryBuilder = QueryOuterClass.Query.newBuilder().setCql("SELECT keyspace_name FROM system_schema.keyspaces");
            QueryOuterClass.QueryParameters.Builder params = QueryOuterClass.QueryParameters.newBuilder().setPageSize(Int32Value.of((int)100));
            if (null != paging.pageState()) {
                params.setPagingState(paging.pageState());
            }
            queryBuilder.setParameters(params);
            return bridge.executeQuery(queryBuilder.build()).flatMap(response -> {
                QueryOuterClass.ResultSet resultSet = response.getResultSet();
                state.set(new Paging(resultSet.hasPagingState(), resultSet.getPagingState()));
                List keyspaceNames = resultSet.getRowsList().stream().map(r -> r.getValues(0).getString()).collect(Collectors.toList());
                return Uni.createFrom().item(keyspaceNames);
            });
        }).until(List::isEmpty).onItem().transformToMultiAndMerge(l -> Multi.createFrom().iterable((Iterable)l));
    }

    @CacheResult(cacheName="keyspace-cache")
    protected Uni<Schema.CqlKeyspaceDescribe> fetchKeyspace(@CacheKey String keyspaceName, @CacheKey Optional<String> tenantId, StargateBridge bridge) {
        Schema.DescribeKeyspaceQuery request = Schema.DescribeKeyspaceQuery.newBuilder().setKeyspaceName(keyspaceName).build();
        return bridge.describeKeyspace(request).memoize().indefinitely();
    }

    @CacheResult(cacheName="keyspace-cache")
    protected Uni<Schema.CqlKeyspaceDescribe> cacheKeyspace(@CacheKey String keyspaceName, @CacheKey Optional<String> tenantId, Schema.CqlKeyspaceDescribe keyspace) {
        return Uni.createFrom().item((Object)keyspace);
    }

    @CacheInvalidate(cacheName="keyspace-cache")
    protected Uni<Void> invalidateKeyspace(@CacheKey String keyspaceName, @CacheKey Optional<String> tenantId) {
        return Uni.createFrom().nullItem();
    }

    private record Paging(boolean hasMore, BytesValue pageState) {
    }
}

