/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.common;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.OptionsMap;
import com.datastax.oss.driver.api.core.config.TypedDriverOption;
import com.datastax.oss.driver.internal.core.auth.PlainTextAuthProvider;
import com.datastax.oss.driver.internal.core.loadbalancing.DcInferringLoadBalancingPolicy;
import io.stargate.sgv2.common.IntegrationTestUtils;
import java.time.Duration;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class CqlEnabledIntegrationTestBase {
    protected final CqlIdentifier keyspaceId = CqlIdentifier.fromInternal((String)("ks" + RandomStringUtils.randomNumeric((int)16)));
    protected CqlSession session;

    @BeforeAll
    public final void buildSession() {
        OptionsMap config = OptionsMap.driverDefaults();
        config.put(TypedDriverOption.REQUEST_TIMEOUT, (Object)Duration.ofSeconds(10L));
        config.put(TypedDriverOption.REQUEST_WARN_IF_SET_KEYSPACE, (Object)false);
        config.put(TypedDriverOption.LOAD_BALANCING_POLICY_CLASS, (Object)DcInferringLoadBalancingPolicy.class.getName());
        if (IntegrationTestUtils.isCassandraAuthEnabled()) {
            config.put(TypedDriverOption.AUTH_PROVIDER_CLASS, (Object)PlainTextAuthProvider.class.getName());
            config.put(TypedDriverOption.AUTH_PROVIDER_USER_NAME, (Object)IntegrationTestUtils.getCassandraUsername());
            config.put(TypedDriverOption.AUTH_PROVIDER_PASSWORD, (Object)IntegrationTestUtils.getCassandraPassword());
        }
        this.session = (CqlSession)((CqlSessionBuilder)((CqlSessionBuilder)CqlSession.builder().addContactPoint(IntegrationTestUtils.getCassandraCqlAddress())).withConfigLoader(DriverConfigLoader.fromMap((OptionsMap)config))).build();
    }

    @BeforeAll
    public final void createKeyspace() {
        this.session.execute("CREATE KEYSPACE IF NOT EXISTS %s WITH replication = {'class': 'SimpleStrategy', 'replication_factor': 1}".formatted(this.keyspaceId.asCql(false)));
        this.session.execute("USE %s".formatted(this.keyspaceId.asCql(false)));
    }

    @AfterAll
    public final void closeSession() {
        if (this.session != null) {
            this.session.close();
        }
    }
}

