/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.properties.datastore.configuration;

import io.grpc.stub.StreamObserver;
import io.quarkus.grpc.GrpcClient;
import io.quarkus.test.junit.QuarkusTest;
import io.stargate.bridge.proto.Schema;
import io.stargate.bridge.proto.StargateBridgeGrpc;
import io.stargate.sgv2.api.common.BridgeTest;
import io.stargate.sgv2.api.common.config.DataStoreConfig;
import io.stargate.sgv2.api.common.properties.datastore.DataStoreProperties;
import io.stargate.sgv2.api.common.properties.datastore.configuration.DataStorePropertiesConfiguration;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@QuarkusTest
class BridgeDataStorePropertiesConfigurationTest
extends BridgeTest {
    @GrpcClient(value="bridge")
    StargateBridgeGrpc.StargateBridgeBlockingStub bridge;
    @Inject
    DataStorePropertiesConfiguration dataStorePropertiesConfiguration;

    BridgeDataStorePropertiesConfigurationTest() {
    }

    @BeforeEach
    public void mockBridge() {
        Schema.SupportedFeaturesResponse response = Schema.SupportedFeaturesResponse.newBuilder().setSecondaryIndexes(false).setSai(true).setLoggedBatches(false).build();
        ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
            StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
            observer.onNext((Object)response);
            observer.onCompleted();
            return null;
        }).when((Object)this.bridgeService)).getSupportedFeatures((Schema.SupportedFeaturesRequest)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
    }

    @Test
    public void dataStoreFromBridge() {
        DataStoreConfig config = (DataStoreConfig)Mockito.mock(DataStoreConfig.class);
        Mockito.when((Object)config.ignoreBridge()).thenReturn((Object)false);
        DataStoreProperties dataStoreProperties = this.dataStorePropertiesConfiguration.configuration(this.bridge, config);
        Assertions.assertThat((boolean)dataStoreProperties.secondaryIndexesEnabled()).isFalse();
        Assertions.assertThat((boolean)dataStoreProperties.saiEnabled()).isTrue();
        Assertions.assertThat((boolean)dataStoreProperties.loggedBatchesEnabled()).isFalse();
    }
}

