/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.cql.builder;

import io.stargate.bridge.grpc.Values;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.sgv2.api.common.cql.builder.BuiltCondition;
import io.stargate.sgv2.api.common.cql.builder.Predicate;
import io.stargate.sgv2.api.common.cql.builder.QueryBuilder;
import io.stargate.sgv2.api.common.cql.builder.Term;
import io.stargate.sgv2.api.common.cql.builder.ValueModifier;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class QueryBuilderValuesTest {
    public static final QueryOuterClass.Value INT_VALUE1 = Values.of((long)1L);
    public static final QueryOuterClass.Value INT_VALUE2 = Values.of((long)10L);
    public static final QueryOuterClass.Value TEXT_VALUE = Values.of((String)"a");

    @Test
    public void shouldBindDirectInsertValues() {
        QueryOuterClass.Query query = new QueryBuilder().insertInto("ks", "tbl").value("c1", (Object)INT_VALUE1).value("c2", (Object)TEXT_VALUE).build();
        Assertions.assertThat((String)query.getCql()).isEqualTo("INSERT INTO ks.tbl (c1, c2) VALUES (?, ?)");
        Assertions.assertThat((List)query.getValues().getValuesList()).containsExactly((Object[])new QueryOuterClass.Value[]{INT_VALUE1, TEXT_VALUE});
    }

    @Test
    public void shouldBindValueModifiers() {
        QueryOuterClass.Query query = new QueryBuilder().update("ks", "tbl").value(ValueModifier.set((String)"c1", (QueryOuterClass.Value)INT_VALUE1)).value(ValueModifier.of((ValueModifier.Target)ValueModifier.Target.mapValue((String)"c2", (Term)Term.of((QueryOuterClass.Value)TEXT_VALUE)), (ValueModifier.Operation)ValueModifier.Operation.APPEND, (QueryOuterClass.Value)INT_VALUE2)).where("k", Predicate.EQ, (Object)INT_VALUE1).build();
        Assertions.assertThat((String)query.getCql()).isEqualTo("UPDATE ks.tbl SET c1 = ?, c2[?] += ? WHERE k = ?");
        Assertions.assertThat((List)query.getValues().getValuesList()).containsExactly((Object[])new QueryOuterClass.Value[]{INT_VALUE1, TEXT_VALUE, INT_VALUE2, INT_VALUE1});
    }

    @Test
    public void shouldBindDirectWhereValues() {
        QueryOuterClass.Query query = new QueryBuilder().select().from("ks", "tbl").where("c1", Predicate.EQ, (Object)INT_VALUE1).where("c2", Predicate.EQ, (Object)TEXT_VALUE).build();
        Assertions.assertThat((String)query.getCql()).isEqualTo("SELECT * FROM ks.tbl WHERE c1 = ? AND c2 = ?");
        Assertions.assertThat((List)query.getValues().getValuesList()).containsExactly((Object[])new QueryOuterClass.Value[]{INT_VALUE1, TEXT_VALUE});
    }

    @Test
    public void shouldBindBuiltConditionsInWhere() {
        QueryOuterClass.Query query = new QueryBuilder().select().from("ks", "tbl").where(BuiltCondition.of((String)"c1", (Predicate)Predicate.EQ, (QueryOuterClass.Value)INT_VALUE1)).where(BuiltCondition.of((BuiltCondition.LHS)BuiltCondition.LHS.mapAccess((String)"c2", (QueryOuterClass.Value)TEXT_VALUE), (Predicate)Predicate.GT, (QueryOuterClass.Value)INT_VALUE2)).build();
        Assertions.assertThat((String)query.getCql()).isEqualTo("SELECT * FROM ks.tbl WHERE c1 = ? AND c2[?] > ?");
        Assertions.assertThat((List)query.getValues().getValuesList()).containsExactly((Object[])new QueryOuterClass.Value[]{INT_VALUE1, TEXT_VALUE, INT_VALUE2});
    }

    @Test
    public void shouldBindDirectIfValues() {
        QueryOuterClass.Query query = new QueryBuilder().delete().from("ks", "tbl").where("k", Predicate.EQ, (Object)INT_VALUE1).ifs("c1", Predicate.EQ, (Object)INT_VALUE2).ifs("c2", Predicate.EQ, (Object)TEXT_VALUE).build();
        Assertions.assertThat((String)query.getCql()).isEqualTo("DELETE FROM ks.tbl WHERE k = ? IF c1 = ? AND c2 = ?");
        Assertions.assertThat((List)query.getValues().getValuesList()).containsExactly((Object[])new QueryOuterClass.Value[]{INT_VALUE1, INT_VALUE2, TEXT_VALUE});
    }

    @Test
    public void shouldBindBuiltConditionsInIfs() {
        QueryOuterClass.Query query = new QueryBuilder().delete().from("ks", "tbl").where("k", Predicate.EQ, (Object)INT_VALUE1).ifs(BuiltCondition.of((String)"c1", (Predicate)Predicate.EQ, (QueryOuterClass.Value)INT_VALUE2)).ifs(BuiltCondition.of((BuiltCondition.LHS)BuiltCondition.LHS.mapAccess((String)"c2", (QueryOuterClass.Value)TEXT_VALUE), (Predicate)Predicate.GT, (QueryOuterClass.Value)INT_VALUE1)).build();
        Assertions.assertThat((String)query.getCql()).isEqualTo("DELETE FROM ks.tbl WHERE k = ? IF c1 = ? AND c2[?] > ?");
        Assertions.assertThat((List)query.getValues().getValuesList()).containsExactly((Object[])new QueryOuterClass.Value[]{INT_VALUE1, INT_VALUE2, TEXT_VALUE, INT_VALUE1});
    }

    @Test
    public void shouldGenerateUniqueMarkerNames() {
        QueryOuterClass.Query query = new QueryBuilder().delete().from("ks", "tbl").where("k", Predicate.GT, (Object)INT_VALUE1).where("k", Predicate.LTE, (Object)INT_VALUE2).build();
        Assertions.assertThat((String)query.getCql()).isEqualTo("DELETE FROM ks.tbl WHERE k > ? AND k <= ?");
        Assertions.assertThat((List)query.getValues().getValuesList()).containsExactly((Object[])new QueryOuterClass.Value[]{INT_VALUE1, INT_VALUE2});
    }

    @Test
    public void shouldBindValuesInQueryOrder() {
        QueryBuilder.QueryBuilder__21 select = new QueryBuilder().select().from("ks", "tbl");
        select.limit(INT_VALUE2);
        select.where(BuiltCondition.of((String)"c1", (Predicate)Predicate.EQ, (QueryOuterClass.Value)INT_VALUE1));
        QueryOuterClass.Query query = select.build();
        Assertions.assertThat((String)query.getCql()).isEqualTo("SELECT * FROM ks.tbl WHERE c1 = ? LIMIT ?");
        Assertions.assertThat((List)query.getValues().getValuesList()).containsExactly((Object[])new QueryOuterClass.Value[]{INT_VALUE1, INT_VALUE2});
    }

    @Test
    public void shouldFailIfMixingValuesAndExplicitMarkers() {
        Assertions.assertThatThrownBy(() -> new QueryBuilder().select().from("tbl").where("a", Predicate.EQ, (Object)INT_VALUE1).where("b", Predicate.EQ, (Object)Term.marker())).isInstanceOf(IllegalStateException.class);
    }
}

