/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.stargate.sgv2.api.common.StargateRequestInfo;
import io.stargate.sgv2.api.common.config.MetricsConfig;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerResponseContext;
import org.jboss.resteasy.reactive.server.ServerResponseFilter;

@ApplicationScoped
public class TenantRequestMetricsFilter {
    private final MeterRegistry meterRegistry;
    private final MetricsConfig.TenantRequestCounterConfig config;
    private final StargateRequestInfo requestInfo;
    private final Tag errorTrue;
    private final Tag errorFalse;
    Tag tenantUnknown;

    @Inject
    public TenantRequestMetricsFilter(MeterRegistry meterRegistry, StargateRequestInfo requestInfo, MetricsConfig metricsConfig) {
        this.meterRegistry = meterRegistry;
        this.requestInfo = requestInfo;
        this.config = metricsConfig.tenantRequestCounter();
        this.errorTrue = Tag.of((String)this.config.errorTag(), (String)"true");
        this.errorFalse = Tag.of((String)this.config.errorTag(), (String)"false");
        this.tenantUnknown = Tag.of((String)this.config.tenantTag(), (String)"UNKNOWN");
    }

    @ServerResponseFilter
    public void record(ContainerResponseContext context) {
        if (this.config.enabled()) {
            Tag tenantTag = this.requestInfo.getTenantId().map(id -> Tag.of((String)this.config.tenantTag(), (String)id)).orElse(this.tenantUnknown);
            boolean error = context.getStatus() >= 500;
            Tag errorTag = error ? this.errorTrue : this.errorFalse;
            this.meterRegistry.counter(this.config.metricName(), (Iterable)Tags.of((Tag[])new Tag[]{tenantTag, errorTag})).increment();
        }
    }
}

