/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.grpc;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import io.quarkus.grpc.GlobalInterceptor;
import io.stargate.sgv2.api.common.StargateRequestInfo;
import io.stargate.sgv2.api.common.grpc.GrpcMetadataResolver;
import java.util.Map;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@GlobalInterceptor
@ApplicationScoped
public class StargateBridgeInterceptor
implements ClientInterceptor {
    @Inject
    GrpcMetadataResolver metadataResolver;
    @Inject
    StargateRequestInfo requestInfo;

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        InjectableContext.ContextState contextState = Arc.container().requestContext().getStateIfActive();
        if (null == contextState || !this.hasStargateRequestBean(contextState.getContextualInstances())) {
            return next.newCall(method, callOptions);
        }
        Metadata metadata = this.metadataResolver.getMetadata(this.requestInfo);
        return new HeaderAttachingClientCall(next.newCall(method, callOptions), metadata);
    }

    private boolean hasStargateRequestBean(Map<InjectableBean<?>, Object> contextualInstances) {
        for (InjectableBean<?> bean : contextualInstances.keySet()) {
            if (!Objects.equals(bean.getBeanClass(), StargateRequestInfo.class)) continue;
            return true;
        }
        return false;
    }

    private static final class HeaderAttachingClientCall<ReqT, RespT>
    extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
        private final Metadata extraHeaders;

        HeaderAttachingClientCall(ClientCall<ReqT, RespT> call, Metadata extraHeaders) {
            super(call);
            this.extraHeaders = extraHeaders;
        }

        public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
            if (this.extraHeaders != null) {
                headers.merge(this.extraHeaders);
            }
            super.start(responseListener, headers);
        }
    }
}

