/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.grpc;

import io.grpc.Metadata;
import io.stargate.sgv2.api.common.StargateRequestInfo;
import io.stargate.sgv2.api.common.config.GrpcMetadataConfig;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class GrpcMetadataResolver {
    private final Metadata.Key<String> tenantIdKey;
    private final Metadata.Key<String> cassandraTokenKey;

    @Inject
    public GrpcMetadataResolver(GrpcMetadataConfig config) {
        this.tenantIdKey = Metadata.Key.of((String)config.tenantIdKey(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        this.cassandraTokenKey = Metadata.Key.of((String)config.cassandraTokenKey(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    }

    public Metadata getMetadata(StargateRequestInfo requestInfo) {
        Metadata metadata = new Metadata();
        requestInfo.getTenantId().ifPresent(t -> metadata.put(this.tenantIdKey, t));
        requestInfo.getCassandraToken().ifPresent(t -> metadata.put(this.cassandraTokenKey, t));
        return metadata;
    }
}

