/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.cql.builder;

import io.stargate.sgv2.api.common.cql.ColumnUtils;
import io.stargate.sgv2.api.common.cql.builder.ImmutableColumn;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@Value.Immutable(prehash=true)
public interface Column {
    public String name();

    @Nullable
    public String type();

    @Nullable
    public Kind kind();

    @Nullable
    public Order order();

    @Value.Lazy
    default public String cqlName() {
        return ColumnUtils.maybeQuote(this.name());
    }

    public static Column reference(String name) {
        return ImmutableColumn.builder().name(name).build();
    }

    public static enum Order {
        ASC,
        DESC;

    }

    public static enum Kind {
        PARTITION_KEY,
        CLUSTERING,
        REGULAR,
        STATIC;

    }
}

