/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common;

import io.quarkus.grpc.GrpcClient;
import io.stargate.bridge.proto.StargateBridge;
import io.stargate.sgv2.api.common.tenant.TenantResolver;
import io.stargate.sgv2.api.common.token.CassandraTokenResolver;
import io.vertx.ext.web.RoutingContext;
import java.util.Optional;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.ws.rs.core.SecurityContext;

@RequestScoped
public class StargateRequestInfo {
    private final Optional<String> tenantId;
    private final Optional<String> cassandraToken;
    private final StargateBridge stargateBridge;

    @Inject
    public StargateRequestInfo(RoutingContext routingContext, SecurityContext securityContext, @GrpcClient(value="bridge") StargateBridge bridge, Instance<TenantResolver> tenantResolver, Instance<CassandraTokenResolver> tokenResolver) {
        this.tenantId = ((TenantResolver)tenantResolver.get()).resolve(routingContext, securityContext);
        this.cassandraToken = ((CassandraTokenResolver)tokenResolver.get()).resolve(routingContext, securityContext);
        this.stargateBridge = bridge;
    }

    public Optional<String> getTenantId() {
        return this.tenantId;
    }

    public Optional<String> getCassandraToken() {
        return this.cassandraToken;
    }

    public StargateBridge getStargateBridge() {
        return this.stargateBridge;
    }
}

