/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.tenant.impl;

import com.google.common.collect.ImmutableMap;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.QuarkusTestProfile;
import io.quarkus.test.junit.TestProfile;
import io.quarkus.test.junit.mockito.InjectMock;
import io.stargate.sgv2.api.common.tenant.TenantResolver;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import java.util.Optional;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@QuarkusTest
@TestProfile(value=Profile.class)
class SubdomainTenantResolverTest {
    @Inject
    Instance<TenantResolver> tenantResolver;
    @InjectMock(returnsDeepMocks=true)
    RoutingContext routingContext;

    SubdomainTenantResolverTest() {
    }

    @Nested
    class Resolve {
        Resolve() {
        }

        @Test
        public void happyPath() {
            Mockito.when((Object)SubdomainTenantResolverTest.this.routingContext.request().host()).thenReturn((Object)"xyz.domain.host");
            Optional result = ((TenantResolver)SubdomainTenantResolverTest.this.tenantResolver.get()).resolve(SubdomainTenantResolverTest.this.routingContext, null);
            Assertions.assertThat((Optional)result).contains((Object)"xyz");
        }

        @Test
        public void topLevelDomain() {
            Mockito.when((Object)SubdomainTenantResolverTest.this.routingContext.request().host()).thenReturn((Object)"domain.host");
            Optional result = ((TenantResolver)SubdomainTenantResolverTest.this.tenantResolver.get()).resolve(SubdomainTenantResolverTest.this.routingContext, null);
            Assertions.assertThat((Optional)result).contains((Object)"domain");
        }

        @Test
        public void maxLengthEnsured() {
            Mockito.when((Object)SubdomainTenantResolverTest.this.routingContext.request().host()).thenReturn((Object)"09cedbf6-9086-42bb-93ac-e497682227ba-eu-west-1.domain.host");
            Optional result = ((TenantResolver)SubdomainTenantResolverTest.this.tenantResolver.get()).resolve(SubdomainTenantResolverTest.this.routingContext, null);
            Assertions.assertThat((Optional)result).contains((Object)"09cedbf6-9086-42bb-93ac-e497682227ba");
        }

        @Test
        public void notDomain() {
            Mockito.when((Object)SubdomainTenantResolverTest.this.routingContext.request().host()).thenReturn((Object)"localhost");
            Optional result = ((TenantResolver)SubdomainTenantResolverTest.this.tenantResolver.get()).resolve(SubdomainTenantResolverTest.this.routingContext, null);
            Assertions.assertThat((Optional)result).isEmpty();
        }
    }

    public static class Profile
    implements QuarkusTestProfile {
        public Map<String, String> getConfigOverrides() {
            return ImmutableMap.builder().put((Object)"stargate.multi-tenancy.enabled", (Object)"true").put((Object)"stargate.multi-tenancy.tenant-resolver.type", (Object)"subdomain").put((Object)"stargate.multi-tenancy.tenant-resolver.subdomain.max-chars", (Object)"36").build();
        }
    }
}

