/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.exception;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.stargate.sgv2.api.common.exception.StatusRuntimeExceptionMapper;
import io.stargate.sgv2.api.common.exception.model.dto.ApiError;
import org.assertj.core.api.Assertions;
import org.jboss.resteasy.reactive.RestResponse;
import org.junit.jupiter.api.Test;

public class StatusRuntimeExceptionMapperTest {
    @Test
    public void grpcStatusAborted() {
        StatusRuntimeExceptionMapper mapper = new StatusRuntimeExceptionMapper();
        StatusRuntimeException error = new StatusRuntimeException(Status.ABORTED);
        RestResponse response = mapper.statusRuntimeException(error);
        Assertions.assertThat((boolean)((ApiError)response.getEntity()).description().endsWith(error.getMessage())).isTrue();
        Assertions.assertThat((String)((ApiError)response.getEntity()).grpcStatus()).isEqualTo(Status.Code.ABORTED.toString());
        Assertions.assertThat((int)((ApiError)response.getEntity()).code()).isEqualTo(500);
    }

    @Test
    public void grpcStatusAlreadyExists() {
        StatusRuntimeExceptionMapper mapper = new StatusRuntimeExceptionMapper();
        StatusRuntimeException error = new StatusRuntimeException(Status.ALREADY_EXISTS);
        RestResponse response = mapper.statusRuntimeException(error);
        Assertions.assertThat((boolean)((ApiError)response.getEntity()).description().endsWith(error.getMessage())).isTrue();
        Assertions.assertThat((String)((ApiError)response.getEntity()).grpcStatus()).isEqualTo(Status.Code.ALREADY_EXISTS.toString());
        Assertions.assertThat((int)((ApiError)response.getEntity()).code()).isEqualTo(500);
    }

    @Test
    public void grpcStatusCancelled() {
        StatusRuntimeExceptionMapper mapper = new StatusRuntimeExceptionMapper();
        StatusRuntimeException error = new StatusRuntimeException(Status.CANCELLED);
        RestResponse response = mapper.statusRuntimeException(error);
        Assertions.assertThat((boolean)((ApiError)response.getEntity()).description().endsWith(error.getMessage())).isTrue();
        Assertions.assertThat((String)((ApiError)response.getEntity()).grpcStatus()).isEqualTo(Status.Code.CANCELLED.toString());
        Assertions.assertThat((int)((ApiError)response.getEntity()).code()).isEqualTo(500);
    }

    @Test
    public void grpcStatusDataLoss() {
        StatusRuntimeExceptionMapper mapper = new StatusRuntimeExceptionMapper();
        StatusRuntimeException error = new StatusRuntimeException(Status.DATA_LOSS);
        RestResponse response = mapper.statusRuntimeException(error);
        Assertions.assertThat((boolean)((ApiError)response.getEntity()).description().endsWith(error.getMessage())).isTrue();
        Assertions.assertThat((String)((ApiError)response.getEntity()).grpcStatus()).isEqualTo(Status.Code.DATA_LOSS.toString());
        Assertions.assertThat((int)((ApiError)response.getEntity()).code()).isEqualTo(500);
    }

    @Test
    public void grpcStatusDeadlineExceeded() {
        StatusRuntimeExceptionMapper mapper = new StatusRuntimeExceptionMapper();
        StatusRuntimeException error = new StatusRuntimeException(Status.DEADLINE_EXCEEDED);
        RestResponse response = mapper.statusRuntimeException(error);
        Assertions.assertThat((boolean)((ApiError)response.getEntity()).description().endsWith(error.getMessage())).isTrue();
        Assertions.assertThat((String)((ApiError)response.getEntity()).grpcStatus()).isEqualTo(Status.Code.DEADLINE_EXCEEDED.toString());
        Assertions.assertThat((int)((ApiError)response.getEntity()).code()).isEqualTo(500);
    }

    @Test
    public void grpcStatusFailedPrecondition() {
        StatusRuntimeExceptionMapper mapper = new StatusRuntimeExceptionMapper();
        StatusRuntimeException error = new StatusRuntimeException(Status.FAILED_PRECONDITION);
        RestResponse response = mapper.statusRuntimeException(error);
        Assertions.assertThat((boolean)((ApiError)response.getEntity()).description().endsWith(error.getMessage())).isTrue();
        Assertions.assertThat((String)((ApiError)response.getEntity()).grpcStatus()).isEqualTo(Status.Code.FAILED_PRECONDITION.toString());
        Assertions.assertThat((int)((ApiError)response.getEntity()).code()).isEqualTo(400);
    }

    @Test
    public void grpcStatusInternal() {
        StatusRuntimeExceptionMapper mapper = new StatusRuntimeExceptionMapper();
        StatusRuntimeException error = new StatusRuntimeException(Status.INTERNAL);
        RestResponse response = mapper.statusRuntimeException(error);
        Assertions.assertThat((boolean)((ApiError)response.getEntity()).description().endsWith(error.getMessage())).isTrue();
        Assertions.assertThat((String)((ApiError)response.getEntity()).grpcStatus()).isEqualTo(Status.Code.INTERNAL.toString());
        Assertions.assertThat((int)((ApiError)response.getEntity()).code()).isEqualTo(500);
    }

    @Test
    public void grpcStatusInvalidArgument() {
        StatusRuntimeExceptionMapper mapper = new StatusRuntimeExceptionMapper();
        StatusRuntimeException error = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        RestResponse response = mapper.statusRuntimeException(error);
        Assertions.assertThat((boolean)((ApiError)response.getEntity()).description().endsWith(error.getMessage())).isTrue();
        Assertions.assertThat((String)((ApiError)response.getEntity()).grpcStatus()).isEqualTo(Status.Code.INVALID_ARGUMENT.toString());
        Assertions.assertThat((int)((ApiError)response.getEntity()).code()).isEqualTo(400);
    }

    @Test
    public void grpcStatusNotFound() {
        StatusRuntimeExceptionMapper mapper = new StatusRuntimeExceptionMapper();
        StatusRuntimeException error = new StatusRuntimeException(Status.NOT_FOUND);
        RestResponse response = mapper.statusRuntimeException(error);
        Assertions.assertThat((boolean)((ApiError)response.getEntity()).description().endsWith(error.getMessage())).isTrue();
        Assertions.assertThat((String)((ApiError)response.getEntity()).grpcStatus()).isEqualTo(Status.Code.NOT_FOUND.toString());
        Assertions.assertThat((int)((ApiError)response.getEntity()).code()).isEqualTo(404);
    }

    @Test
    public void grpcStatusOk() {
        StatusRuntimeExceptionMapper mapper = new StatusRuntimeExceptionMapper();
        StatusRuntimeException error = new StatusRuntimeException(Status.OK);
        RestResponse response = mapper.statusRuntimeException(error);
        Assertions.assertThat((boolean)((ApiError)response.getEntity()).description().endsWith(error.getMessage())).isTrue();
        Assertions.assertThat((String)((ApiError)response.getEntity()).grpcStatus()).isEqualTo(Status.Code.OK.toString());
        Assertions.assertThat((int)((ApiError)response.getEntity()).code()).isEqualTo(500);
    }

    @Test
    public void grpcStatusOutOfRange() {
        StatusRuntimeExceptionMapper mapper = new StatusRuntimeExceptionMapper();
        StatusRuntimeException error = new StatusRuntimeException(Status.OUT_OF_RANGE);
        RestResponse response = mapper.statusRuntimeException(error);
        Assertions.assertThat((boolean)((ApiError)response.getEntity()).description().endsWith(error.getMessage())).isTrue();
        Assertions.assertThat((String)((ApiError)response.getEntity()).grpcStatus()).isEqualTo(Status.Code.OUT_OF_RANGE.toString());
        Assertions.assertThat((int)((ApiError)response.getEntity()).code()).isEqualTo(500);
    }

    @Test
    public void grpcStatusPermissionDenied() {
        StatusRuntimeExceptionMapper mapper = new StatusRuntimeExceptionMapper();
        StatusRuntimeException error = new StatusRuntimeException(Status.PERMISSION_DENIED);
        RestResponse response = mapper.statusRuntimeException(error);
        Assertions.assertThat((boolean)((ApiError)response.getEntity()).description().endsWith(error.getMessage())).isTrue();
        Assertions.assertThat((String)((ApiError)response.getEntity()).grpcStatus()).isEqualTo(Status.Code.PERMISSION_DENIED.toString());
        Assertions.assertThat((int)((ApiError)response.getEntity()).code()).isEqualTo(401);
    }

    @Test
    public void grpcStatusResourceExhausted() {
        StatusRuntimeExceptionMapper mapper = new StatusRuntimeExceptionMapper();
        StatusRuntimeException error = new StatusRuntimeException(Status.RESOURCE_EXHAUSTED);
        RestResponse response = mapper.statusRuntimeException(error);
        Assertions.assertThat((boolean)((ApiError)response.getEntity()).description().endsWith(error.getMessage())).isTrue();
        Assertions.assertThat((String)((ApiError)response.getEntity()).grpcStatus()).isEqualTo(Status.Code.RESOURCE_EXHAUSTED.toString());
        Assertions.assertThat((int)((ApiError)response.getEntity()).code()).isEqualTo(500);
    }

    @Test
    public void grpcStatusUnauthenticated() {
        StatusRuntimeExceptionMapper mapper = new StatusRuntimeExceptionMapper();
        StatusRuntimeException error = new StatusRuntimeException(Status.UNAUTHENTICATED);
        RestResponse response = mapper.statusRuntimeException(error);
        Assertions.assertThat((boolean)((ApiError)response.getEntity()).description().endsWith(error.getMessage())).isTrue();
        Assertions.assertThat((String)((ApiError)response.getEntity()).grpcStatus()).isEqualTo(Status.Code.UNAUTHENTICATED.toString());
        Assertions.assertThat((int)((ApiError)response.getEntity()).code()).isEqualTo(401);
    }

    @Test
    public void grpcStatusUnavailable() {
        StatusRuntimeExceptionMapper mapper = new StatusRuntimeExceptionMapper();
        StatusRuntimeException error = new StatusRuntimeException(Status.UNAVAILABLE);
        RestResponse response = mapper.statusRuntimeException(error);
        Assertions.assertThat((boolean)((ApiError)response.getEntity()).description().endsWith(error.getMessage())).isTrue();
        Assertions.assertThat((String)((ApiError)response.getEntity()).grpcStatus()).isEqualTo(Status.Code.UNAVAILABLE.toString());
        Assertions.assertThat((int)((ApiError)response.getEntity()).code()).isEqualTo(502);
    }

    @Test
    public void grpcStatusUnimplemented() {
        StatusRuntimeExceptionMapper mapper = new StatusRuntimeExceptionMapper();
        StatusRuntimeException error = new StatusRuntimeException(Status.UNIMPLEMENTED);
        RestResponse response = mapper.statusRuntimeException(error);
        Assertions.assertThat((boolean)((ApiError)response.getEntity()).description().endsWith(error.getMessage())).isTrue();
        Assertions.assertThat((String)((ApiError)response.getEntity()).grpcStatus()).isEqualTo(Status.Code.UNIMPLEMENTED.toString());
        Assertions.assertThat((int)((ApiError)response.getEntity()).code()).isEqualTo(501);
    }

    @Test
    public void grpcStatusUnknown() {
        StatusRuntimeExceptionMapper mapper = new StatusRuntimeExceptionMapper();
        StatusRuntimeException error = new StatusRuntimeException(Status.UNKNOWN);
        RestResponse response = mapper.statusRuntimeException(error);
        Assertions.assertThat((boolean)((ApiError)response.getEntity()).description().endsWith(error.getMessage())).isTrue();
        Assertions.assertThat((String)((ApiError)response.getEntity()).grpcStatus()).isEqualTo(Status.Code.UNKNOWN.toString());
        Assertions.assertThat((int)((ApiError)response.getEntity()).code()).isEqualTo(500);
    }
}

