/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common;

import io.grpc.BindableService;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.Server;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.NettyServerBuilder;
import io.stargate.bridge.proto.Schema;
import io.stargate.bridge.proto.StargateBridgeGrpc;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class BridgeTest {
    protected StargateBridgeGrpc.StargateBridgeImplBase bridgeService;
    protected ServerInterceptor bridgeInterceptor;
    Server server;
    ManagedChannel channel;
    @ConfigProperty(name="quarkus.grpc.clients.bridge.host")
    String bridgeHost;
    @ConfigProperty(name="quarkus.grpc.clients.bridge.port")
    int bridgePort;

    protected Schema.SupportedFeaturesResponse getSupportedFeatures() {
        return Schema.SupportedFeaturesResponse.newBuilder().build();
    }

    @BeforeEach
    public void initBridge() throws Exception {
        this.bridgeService = (StargateBridgeGrpc.StargateBridgeImplBase)Mockito.mock(StargateBridgeGrpc.StargateBridgeImplBase.class);
        this.bridgeInterceptor = (ServerInterceptor)Mockito.mock(ServerInterceptor.class);
        Mockito.when((Object)this.bridgeService.bindService()).thenCallRealMethod();
        ((ServerInterceptor)Mockito.lenient().doAnswer(invocation -> {
            ServerCallHandler next = (ServerCallHandler)invocation.getArgument(2);
            return next.startCall((ServerCall)invocation.getArgument(0), (Metadata)invocation.getArgument(1));
        }).when((Object)this.bridgeInterceptor)).interceptCall((ServerCall)ArgumentMatchers.any(), (Metadata)ArgumentMatchers.any(), (ServerCallHandler)ArgumentMatchers.any());
        InetSocketAddress address = new InetSocketAddress(this.bridgeHost, this.bridgePort);
        this.server = ((NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forAddress((SocketAddress)address).directExecutor()).intercept(this.bridgeInterceptor)).addService((BindableService)this.bridgeService)).build();
        this.server.start();
        this.channel = NettyChannelBuilder.forAddress((SocketAddress)address).usePlaintext().build();
        ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)this.bridgeService)).bindService();
    }

    @AfterEach
    public void tearDownBridge() throws Exception {
        this.channel.shutdown();
        this.server.shutdown();
        try {
            this.channel.awaitTermination(5L, TimeUnit.SECONDS);
            this.server.awaitTermination(5L, TimeUnit.SECONDS);
        }
        finally {
            this.channel.shutdownNow();
            this.server.shutdownNow();
        }
    }
}

